/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigDeleteBackupAction
extends ActionNoSessionCMD {
    private static final String AUTO_BACKUP = "autobackup";
    private static final String MANUAL_BACKUP = "manualbackup";
    private static final String FR_CONFIG_BACKUP = "frbak";

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 5L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"backuptype");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"backupname");
        String[] stringArray = string2.replaceAll("\\[", "").replaceAll("\"", "").replaceAll("\\]", "").split(",");
        String string3 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), FR_CONFIG_BACKUP});
        for (String string4 : stringArray) {
            this.deleteBackup(string3, string4, string);
        }
    }

    private void deleteDirectory(String string) {
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    this.deleteDirectory(file2.toString());
                    file2.delete();
                }
            } else {
                file.delete();
            }
            file.delete();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    private void deleteBackup(String string, String string2, String string3) {
        String string4 = "";
        if (ComparatorUtils.equals((String)string3, (String)"manual")) {
            string4 = StableUtils.pathJoin((String[])new String[]{string, MANUAL_BACKUP, string2});
        } else if (ComparatorUtils.equals((String)string3, (String)"auto")) {
            string4 = StableUtils.pathJoin((String[])new String[]{string, AUTO_BACKUP, string2});
        } else {
            FRLogger.getLogger().error("Backup type to delete error.");
            return;
        }
        this.deleteDirectory(string4);
    }

    public String getCMD() {
        return "delete";
    }
}

