/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache.tabledata;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.RecursionTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.tabledata.DepartmentNameAndPostName;
import com.fr.fs.cache.tabledata.TableDataJRole;
import com.fr.fs.cache.tabledata.TableDataSyncThread;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.web.FSConstants;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.DataModel;
import com.fr.privilege.PrivilegeManager;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataSyncAction
implements TableDataSyncThread.Action {
    private static final String DEFAULTPARENTIDSTRINGTYPE = "-1";
    private static long comRoleId = 1L;
    private static Department ALL_DEPARTMENT = new Department(0L, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, "", -2L);
    private Map<String, TableDataUser> tdUser_NameListMap = new HashMap<String, TableDataUser>();
    private Map<String, Department> dp_nameMap = new HashMap<String, Department>();
    private Map<Long, Department> dp_idMap = new HashMap<Long, Department>();
    private Set<String> postSet = new HashSet<String>();
    private final Map<String, CustomRole> customRoleNameListMap = new HashMap<String, CustomRole>();
    private final Map<Long, TableDataJRole> companyRoleIDListMap = new HashMap<Long, TableDataJRole>();
    private Map<String, Long> departIdMap = new ConcurrentHashMap<String, Long>();
    private Set<Long> excludeId = new HashSet<Long>();
    private Map<String, String> markDepartment = new HashMap<String, String>();
    private Map<String, String> markDepAndParentDep = new HashMap<String, String>();
    private boolean isTreeTableDataCollection = false;
    private Set<Long> special = new HashSet<Long>();

    @Override
    public void work() {
        if (!(FSConfig.getProviderInstance().getControl() instanceof TableDataDAOControl)) {
            return;
        }
        try {
            if (TableDataDAOControl.getInstance().hasSetTableDataSync()) {
                int n;
                this.addDepartOrPostAll();
                TableData tableData = DatasourceManager.getProviderInstance().getTableData(TableDataDAOControl.getInstance().getDsName());
                if (tableData == null) {
                    return;
                }
                int n2 = TableDataDAOControl.getInstance().getUserNameIndex();
                int n3 = TableDataDAOControl.getInstance().getPasswordIndex();
                int n4 = TableDataDAOControl.getInstance().getDepartmentIndex();
                int n5 = TableDataDAOControl.getInstance().getPostIndex();
                int n6 = TableDataDAOControl.getInstance().getRoleIndex();
                int n7 = TableDataDAOControl.getInstance().getNameIndex();
                int n8 = TableDataDAOControl.getInstance().getEmailIndex();
                int n9 = TableDataDAOControl.getInstance().getMobileIndex();
                boolean bl = n3 > -1;
                boolean bl2 = n7 > -1;
                boolean bl3 = n8 > -1;
                boolean bl4 = n9 > -1;
                boolean bl5 = n6 > -1;
                boolean bl6 = n5 > -1;
                boolean bl7 = n4 > -1;
                int n10 = TableDataDAOControl.getInstance().getTimeout();
                DataModel dataModel = tableData.createDataModelWithTimeout(Calculator.createCalculator(), n10);
                boolean bl8 = this.prepareForTreeTableData(tableData, dataModel, bl7, bl6, n = dataModel.getRowCount(), n4);
                if (!bl8) {
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    this.updateEachRow(tableData, n2, n3, n4, n5, n6, n7, n8, n9, bl, bl2, bl3, bl4, bl5, bl6, bl7, dataModel, i);
                }
                this.tableDataSync();
            }
        }
        catch (Throwable throwable) {
            FRContext.getLogger().error(throwable.getMessage(), throwable);
        }
    }

    private boolean prepareForTreeTableData(TableData tableData, DataModel dataModel, boolean bl, boolean bl2, int n, int n2) throws Exception {
        boolean bl3;
        boolean bl4 = tableData instanceof RecursionTableData;
        boolean bl5 = bl3 = bl && bl2;
        if (bl4 && bl3) {
            Object object;
            String string;
            RecursionDataModel recursionDataModel = (RecursionDataModel)dataModel;
            int n3 = recursionDataModel.getMarkField();
            int n4 = recursionDataModel.getParentMarkField();
            for (int i = 0; i < n; ++i) {
                Map.Entry<String, String> entry = GeneralUtils.objectToString((Object)dataModel.getValueAt(i, n3));
                string = n4 < 0 ? recursionDataModel.getParentValue(i) : GeneralUtils.objectToString((Object)recursionDataModel.getValueAt(i, n4));
                if (this.isAllDigit((String)((Object)entry))) {
                    try {
                        long l = Long.parseLong((String)((Object)entry));
                        this.special.add(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                object = GeneralUtils.objectToString((Object)dataModel.getValueAt(i, n2));
                String string2 = this.markDepartment.get(entry);
                if (string2 == null) {
                    this.markDepartment.put((String)((Object)entry), (String)object);
                } else if (!ComparatorUtils.equals((String)string2, (String)object)) {
                    FRContext.getLogger().error("Table data synchronization failed!Tree mark " + (String)((Object)entry) + " consists of two department name " + string2 + " ," + object + "!");
                    return false;
                }
                if (this.markDepAndParentDep.containsKey(entry)) continue;
                this.markDepAndParentDep.put((String)((Object)entry), string);
            }
            for (Map.Entry<String, String> entry : this.markDepartment.entrySet()) {
                string = this.getFullParentName((String)entry.getKey());
                if (string == null) {
                    FRContext.getLogger().error("Tree Table Data exists department circle");
                    return false;
                }
                object = DepartmentControl.getInstance().findDepartmentByNameAndParentName((String)entry.getValue(), string);
                if (object == null) continue;
                this.excludeId.add(object.getId());
                this.departIdMap.put((String)entry.getKey(), object.getId());
            }
        }
        return true;
    }

    private boolean isAllDigit(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (StableUtils.isNum((char)string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void tableDataSync() throws Exception {
        boolean bl = this.departmentSync();
        if (!bl) {
            return;
        }
        this.postSync();
        this.customRoleSync();
        this.companyRoleSync();
        this.userSync();
        this.deleteDepartmentAndPost();
    }

    private void customRoleSync() throws Exception {
        boolean bl = false;
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        if (list.size() == 0) {
            bl = true;
        }
        for (Map.Entry<String, CustomRole> entry : this.customRoleNameListMap.entrySet()) {
            if (bl) {
                CustomRoleControl.getInstance().addCustomRole(entry.getValue());
                continue;
            }
            CustomRole customRole = CustomRoleControl.getInstance().findByCustomRoleName(entry.getKey());
            if (customRole != null) continue;
            CustomRoleControl.getInstance().addCustomRole(entry.getValue());
        }
    }

    private void companyRoleSync() throws Exception {
        for (Map.Entry<Long, TableDataJRole> entry : this.companyRoleIDListMap.entrySet()) {
            List<CompanyRole> list = CompanyRoleControl.getInstance().getAllCompanyRole();
            TableDataJRole tableDataJRole = entry.getValue();
            boolean bl = false;
            for (CompanyRole companyRole : list) {
                String string;
                Department department = DepartmentControl.getInstance().getDepartment(companyRole.getDepartmentId());
                if (department == null || (string = PostControl.getInstance().getPostName(companyRole.getPostId())) == null || !this.isTheSameCompanyRole(department, string, tableDataJRole)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            CompanyRole companyRole = new CompanyRole();
            companyRole.setDepartmentId(DepartmentControl.getInstance().findDepartmentByName(tableDataJRole.getDpName() + tableDataJRole.getParentId()).getId());
            companyRole.setPostId(PostControl.getInstance().getPostByName(tableDataJRole.getPostName()).getId());
            companyRole.setDescription(tableDataJRole.getDescription());
            CompanyRoleControl.getInstance().addCompanyRole(companyRole);
        }
    }

    private boolean isTheSameCompanyRole(Department department, String string, TableDataJRole tableDataJRole) {
        return ComparatorUtils.equals((Object)department.getPid(), (Object)tableDataJRole.getParentId()) && ComparatorUtils.equals((String)department.getName(), (String)tableDataJRole.getDpName()) && ComparatorUtils.equals((String)string, (String)tableDataJRole.getPostName());
    }

    private boolean buildDepartmentTree(Department department, Map<Long, Department> map, LinkedHashMap<Long, Department> linkedHashMap) {
        if (linkedHashMap.containsKey(department.getId())) {
            return true;
        }
        LinkedList<Department> linkedList = new LinkedList<Department>();
        if (linkedHashMap.containsKey(department.getPid())) {
            linkedHashMap.put(department.getId(), department);
            return true;
        }
        linkedList.add(department);
        Department department2 = map.get(department.getPid());
        while (department2 != null) {
            if (linkedHashMap.containsKey(department2.getPid())) {
                linkedList.add(department2);
                break;
            }
            for (Department department3 : linkedList) {
                if (!ComparatorUtils.equals((String)department3.getName(), (String)department2.getName()) || !ComparatorUtils.equals((Object)department3.getPid(), (Object)department2.getPid())) continue;
                return false;
            }
            long l = department2.getPid();
            linkedList.add(department2);
            department2 = map.get(l);
            if (department2 != null || ComparatorUtils.equals((Object)l, (Object)-1)) continue;
            FRContext.getLogger().error("Tree Table Data has no root department");
            return false;
        }
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            linkedHashMap.put(((Department)((Object)linkedList.get(i))).getId(), (Department)((Object)linkedList.get(i)));
        }
        return true;
    }

    private boolean departmentSync() throws Exception {
        LinkedHashMap<Long, Department> linkedHashMap = null;
        if (this.isTreeTableDataCollection) {
            linkedHashMap = new LinkedHashMap<Long, Department>();
            for (Department object : this.dp_nameMap.values()) {
                boolean bl = this.buildDepartmentTree(object, this.dp_idMap, linkedHashMap);
                if (bl) continue;
                FRContext.getLogger().error("Tree TableData Department Configuration Error");
                return false;
            }
        }
        if (this.isTreeTableDataCollection) {
            for (Department department : linkedHashMap.values()) {
                Department department2 = DepartmentControl.getInstance().findDepartmentByName(department.getName() + department.getPid());
                if (department2 != null) continue;
                DepartmentControl.getInstance().addDepartment(department);
            }
        } else {
            for (Map.Entry entry : this.dp_nameMap.entrySet()) {
                Department department = DepartmentControl.getInstance().findDepartmentByName((String)entry.getKey());
                if (department != null) continue;
                DepartmentControl.getInstance().addDepartment((Department)((Object)entry.getValue()));
            }
        }
        return true;
    }

    private void deleteDepartmentAndPost() throws Exception {
        Object object;
        List<CompanyRole> list = CompanyRoleControl.getInstance().getAllCompanyRole();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (CompanyRole companyRole : list) {
            boolean bl = false;
            for (Object object2 : this.companyRoleIDListMap.values()) {
                Post post;
                Department department = DepartmentControl.getInstance().findDepartmentByName(object2.getDpName() + object2.getParentId());
                if (department == null || (post = PostControl.getInstance().getPostByName(object2.getPostName())) == null || !ComparatorUtils.equals((Object)department.getId(), (Object)companyRole.getDepartmentId()) || !ComparatorUtils.equals((Object)post.getId(), (Object)companyRole.getPostId())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(companyRole.getId());
        }
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            long l = (Long)((Object)object3.next());
            CompanyRoleControl.getInstance().deleteCompanyRole(l);
        }
        object3 = CustomRoleControl.getInstance().getAllCustomRole();
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            CustomRole customRole = (CustomRole)((Object)object4.next());
            if (this.customRoleNameListMap.containsKey(customRole.getRolename()) || customRole.getId() > -1000L) continue;
            CustomRoleControl.getInstance().deleteCustomRole(customRole.getId());
        }
        object4 = DepartmentControl.getInstance().getAllDepartment();
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object = (Department)((Object)object5.next());
            if (this.dp_nameMap.containsKey(((Department)((Object)object)).getName() + ((Department)((Object)object)).getPid())) continue;
            DepartmentControl.getInstance().deleteDepartment(object.getId());
        }
        object5 = PostControl.getInstance().getAllPost();
        object = object5.iterator();
        while (object.hasNext()) {
            Object object2;
            object2 = (Post)((Object)object.next());
            if (this.postSet.contains(((Post)((Object)object2)).getPostname())) continue;
            PostControl.getInstance().deletePost(object2.getId());
        }
    }

    private void postSync() throws Exception {
        for (String string : this.postSet) {
            Post post = PostControl.getInstance().getPostByName(string);
            if (post != null) continue;
            Post post2 = new Post();
            post2.setPostname(string);
            PostControl.getInstance().addPost(post2);
        }
    }

    private void userSync() throws Exception {
        User user;
        for (Map.Entry<String, TableDataUser> object2 : this.tdUser_NameListMap.entrySet()) {
            user = UserControl.getInstance().getByUserName(object2.getKey());
            TableDataUser tableDataUser = object2.getValue();
            if (ComparatorUtils.equals((String)PrivilegeManager.getProviderInstance().getRootManagerName(), (String)tableDataUser.getUserName())) continue;
            if (user == null) {
                this.tableDataAddUser(tableDataUser);
                continue;
            }
            boolean bl = this.compareUserInfo(tableDataUser, user);
            boolean bl2 = this.compareUserCustomRoleInfo(tableDataUser, user);
            boolean bl3 = this.compareUserCompanyRoleInfo(tableDataUser, user);
            boolean bl4 = bl && bl3 && bl2;
            if (bl4) continue;
            if (!bl) {
                UserControl.getInstance().update(user.getId(), tableDataUser.getUserName(), tableDataUser.getPassword(), tableDataUser.getName(), tableDataUser.getMobile(), tableDataUser.getEmail());
            }
            User user2 = UserControl.getInstance().getByUserName(user.getUsername());
            this.updateUserCompanyRole(bl3, tableDataUser, user, user2);
            this.updateUserCustomRole(bl2, tableDataUser, user, user2);
        }
        List list = UserControl.getInstance().findAllUser();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            user = (User)((Object)iterator.next());
            if (this.tdUser_NameListMap.containsKey(user.getUsername())) continue;
            UserControl.getInstance().deleteUser(user.getId());
        }
    }

    private void updateUserCustomRole(boolean bl, TableDataUser tableDataUser, User user, User user2) throws Exception {
        if (!bl) {
            Set set = UserControl.getInstance().getUserRoleSetByUserId(user.getId());
            for (String object2 : tableDataUser.getCustomRoleSet()) {
                boolean bl2 = false;
                for (Object object : set) {
                    CustomRole customRole = CustomRoleControl.getInstance().getCustomRole((Long)object.getValue(CustomRole.class));
                    if (customRole == null || !ComparatorUtils.equals((String)object2, (String)customRole.getRolename())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                Object object = CustomRoleControl.getInstance().findByCustomRoleName(object2);
                UserControl.getInstance().addSRole(user2.getId(), object.getId());
            }
            Set set2 = UserControl.getInstance().getUserRoleSetByUserId(user.getId());
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                RelationObject relationObject = (RelationObject)iterator.next();
                if ((Long)relationObject.getValue(CustomRole.class) > -1000L) continue;
                boolean bl3 = false;
                for (String string : tableDataUser.getCustomRoleSet()) {
                    CustomRole customRole = CustomRoleControl.getInstance().findByCustomRoleName(string);
                    if (customRole == null || !ComparatorUtils.equals((Object)customRole.getId(), (Object)((Long)relationObject.getValue(CustomRole.class)))) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                UserControl.getInstance().deleteSroleFromUser(user2.getId(), (Long)relationObject.getValue(CustomRole.class));
            }
        }
    }

    private void updateUserCompanyRole(boolean bl, TableDataUser tableDataUser, User user, User user2) throws Exception {
        if (!bl) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            Set set = UserControl.getInstance().getUserJobSetByUserId(user.getId());
            for (DepartmentNameAndPostName object2 : tableDataUser.getCompanyRoleSet()) {
                boolean bl2 = false;
                Department bl3 = DepartmentControl.getInstance().findDepartmentByName(object2.getDepartmentName());
                if (bl3 == null) {
                    FRContext.getLogger().error("department " + object2.getDepartmentName() + "sync error");
                    continue;
                }
                Post i = PostControl.getInstance().getPostByName(object2.getPostName());
                if (i == null) {
                    FRContext.getLogger().error("post " + object2.getPostName() + "sync error");
                    continue;
                }
                arrayList.add(bl3.getId());
                arrayList2.add(i.getId());
                for (RelationObject relationObject : set) {
                    if (!ComparatorUtils.equals((Object)((Long)relationObject.getValue(Department.class)), (Object)bl3.getId()) || !ComparatorUtils.equals((Object)((Long)relationObject.getValue(Post.class)), (Object)i.getId())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                UserControl.getInstance().addDepartmentAndPost2User(user2.getId(), bl3.getId(), i.getId());
            }
            Set set2 = UserControl.getInstance().getUserJobSetByUserId(user.getId());
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                RelationObject relationObject = (RelationObject)iterator.next();
                boolean bl3 = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!ComparatorUtils.equals((Object)((Long)relationObject.getValue(Department.class)), arrayList.get(i)) || !ComparatorUtils.equals((Object)((Long)relationObject.getValue(Post.class)), arrayList2.get(i))) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                UserControl.getInstance().deleteDepartmentAndPostFromUser(user2.getId(), (Long)relationObject.getValue(Department.class), (Long)relationObject.getValue(Post.class));
            }
        }
    }

    private void tableDataAddUser(TableDataUser tableDataUser) throws Exception {
        DAOBean dAOBean;
        User user = new User();
        user.setEmail(tableDataUser.getEmail());
        user.setUsername(tableDataUser.getUserName());
        user.setPassword(tableDataUser.getPassword());
        user.setRealname(tableDataUser.getName());
        user.setMobile(tableDataUser.getMobile());
        UserControl.getInstance().addUser(user);
        User user2 = UserControl.getInstance().getByUserName(user.getUsername());
        for (DepartmentNameAndPostName object : tableDataUser.getCompanyRoleSet()) {
            dAOBean = DepartmentControl.getInstance().findDepartmentByName(object.getDepartmentName());
            Post post = PostControl.getInstance().getPostByName(object.getPostName());
            if (dAOBean == null || post == null) continue;
            UserControl.getInstance().addDepartmentAndPost2User(user2.getId(), dAOBean.getId(), post.getId());
        }
        for (String string : tableDataUser.getCustomRoleSet()) {
            dAOBean = CustomRoleControl.getInstance().findByCustomRoleName(string);
            if (dAOBean == null) continue;
            UserControl.getInstance().addSRole(user2.getId(), dAOBean.getId());
        }
    }

    private boolean compareUserInfo(TableDataUser tableDataUser, User user) throws Exception {
        boolean bl = ComparatorUtils.equals((String)tableDataUser.getUserName(), (String)user.getUsername()) || this.compareNullAndEmptyString(tableDataUser.getUserName(), user.getUsername());
        boolean bl2 = ComparatorUtils.equals((String)tableDataUser.getPassword(), (String)user.getPassword()) || this.compareNullAndEmptyString(tableDataUser.getPassword(), user.getPassword());
        boolean bl3 = ComparatorUtils.equals((String)tableDataUser.getEmail(), (String)user.getEmail()) || this.compareNullAndEmptyString(tableDataUser.getEmail(), user.getEmail());
        boolean bl4 = ComparatorUtils.equals((String)tableDataUser.getName(), (String)user.getRealname()) || this.compareNullAndEmptyString(tableDataUser.getName(), user.getRealname());
        boolean bl5 = ComparatorUtils.equals((String)tableDataUser.getMobile(), (String)user.getMobile()) || this.compareNullAndEmptyString(tableDataUser.getMobile(), user.getMobile());
        return bl && bl2 && bl3 && bl5 && bl4;
    }

    private boolean compareNullAndEmptyString(String string, String string2) {
        if (string == null && ComparatorUtils.equals((String)"", (String)string2)) {
            return true;
        }
        return string2 == null && ComparatorUtils.equals((String)"", (String)string);
    }

    private boolean compareUserCustomRoleInfo(TableDataUser tableDataUser, User user) throws Exception {
        Set set = UserControl.getInstance().getUserRoleSetByUserId(user.getId());
        Set<String> set2 = tableDataUser.getCustomRoleSet();
        if (set == null) {
            return set2.size() == 0;
        }
        if (set2.size() != set.size()) {
            return false;
        }
        for (RelationObject relationObject : set) {
            CustomRole customRole = CustomRoleControl.getInstance().getCustomRole((Long)relationObject.getValue(CustomRole.class));
            if (set2.contains(customRole.getRolename())) {
                set2.remove(customRole.getRolename());
                continue;
            }
            return false;
        }
        return set2.size() == 0;
    }

    private boolean compareUserCompanyRoleInfo(TableDataUser tableDataUser, User user) throws Exception {
        Set set = UserControl.getInstance().getUserJobSetByUserId(user.getId());
        Set<DepartmentNameAndPostName> set2 = tableDataUser.getCompanyRoleSet();
        if (set2.size() != set.size()) {
            return false;
        }
        HashSet<RelationObject> hashSet = new HashSet<RelationObject>();
        for (DepartmentNameAndPostName departmentNameAndPostName : set2) {
            long l = DepartmentControl.getInstance().findDepartmentByName(departmentNameAndPostName.getDepartmentName()).getId();
            long l2 = PostControl.getInstance().getPostByName(departmentNameAndPostName.getPostName()).getId();
            for (RelationObject relationObject : set) {
                if (!ComparatorUtils.equals((Object)((Long)relationObject.getValue(Department.class)), (Object)l) || !ComparatorUtils.equals((Object)((Long)relationObject.getValue(Post.class)), (Object)l2)) continue;
                hashSet.add(relationObject);
            }
        }
        for (RelationObject relationObject : hashSet) {
            set.remove(relationObject);
        }
        return set.size() == 0;
    }

    private void updateEachRow(TableData tableData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, DataModel dataModel, int n9) throws Exception {
        Object object;
        Object object2;
        String string = "";
        String string2 = GeneralUtils.objectToString((Object)dataModel.getValueAt(n9, n));
        if (bl) {
            object2 = dataModel.getValueAt(n9, n2);
            string = object2 != null ? GeneralUtils.objectToString((Object)object2) : "";
        }
        object2 = null;
        if (StringUtils.isNotEmpty((String)string2)) {
            object2 = new TableDataUser(-1L, string2, string);
        }
        if (bl2) {
            object = dataModel.getValueAt(n9, n6);
            if (object2 != null) {
                ((TableDataUser)object2).setName(object != null ? GeneralUtils.objectToString((Object)object) : "");
            }
        }
        if (bl3) {
            object = dataModel.getValueAt(n9, n7);
            if (object2 != null) {
                ((TableDataUser)object2).setEmail(object != null ? GeneralUtils.objectToString((Object)object) : "");
            }
        }
        if (bl4) {
            object = dataModel.getValueAt(n9, n8);
            if (object2 != null) {
                ((TableDataUser)object2).setMobile(object != null ? GeneralUtils.objectToString((Object)object) : "");
            }
        }
        if (bl7 && bl6) {
            object = dataModel.getValueAt(n9, n3);
            Object object3 = dataModel.getValueAt(n9, n4);
            this.initCompanyRoleUser(n9, tableData, dataModel, object, object3, (TableDataUser)object2);
        }
        if (bl5) {
            object = dataModel.getValueAt(n9, n5);
            this.initCustomRoleUser(object, (TableDataUser)object2);
        }
        if (object2 != null) {
            this.dealWithDuplicateUser(bl7, bl5, (TableDataUser)object2);
        }
    }

    private void dealWithDuplicateUser(boolean bl, boolean bl2, TableDataUser tableDataUser) throws Exception {
        String string = tableDataUser.getUserName();
        TableDataUser tableDataUser2 = this.tdUser_NameListMap.get(string);
        if (tableDataUser2 == null) {
            this.tdUser_NameListMap.put(string, tableDataUser);
        } else {
            TableDataUser tableDataUser3 = this.tdUser_NameListMap.get(tableDataUser.getUserName());
            if (bl) {
                for (DepartmentNameAndPostName departmentNameAndPostName : tableDataUser.getCompanyRoleSet()) {
                    tableDataUser3.addCompanyRole(departmentNameAndPostName.getDepartmentName(), departmentNameAndPostName.getPostName());
                }
            }
            if (bl2 && tableDataUser.getRoleValue() != null) {
                tableDataUser3.addCustomRole(tableDataUser.getRoleValue());
            }
            this.tdUser_NameListMap.put(tableDataUser.getUserName(), tableDataUser3);
        }
    }

    private void initCompanyRoleUser(int n, TableData tableData, DataModel dataModel, Object object, Object object2, TableDataUser tableDataUser) throws Exception {
        boolean bl;
        this.isTreeTableDataCollection = bl = tableData instanceof RecursionTableData;
        if (object != null && object2 != null) {
            String string = GeneralUtils.objectToString((Object)object);
            String string2 = GeneralUtils.objectToString((Object)object2);
            Department department = new Department(string, "", -1L);
            String string3 = string;
            if (bl) {
                int n2 = ((RecursionTableData)tableData).getMarkFieldIndex();
                string3 = GeneralUtils.objectToString((Object)dataModel.getValueAt(n, n2));
                this.initRecursionTableDataDepartment(department, (RecursionDataModel)dataModel, n);
                this.dp_nameMap.put(department.getName() + department.getPid(), department);
                this.dp_idMap.put(department.getId(), department);
                this.saveDepartmentPost(department, string3, FSConstants.COMPANYROLE.POST_ALL_NAME, department.getPid());
            } else if (!this.dp_nameMap.containsKey(string + department.getPid())) {
                department.setParentName("");
                this.dp_nameMap.put(string + department.getPid(), department);
                this.saveDepartmentPost(department, string3, FSConstants.COMPANYROLE.POST_ALL_NAME, department.getPid());
            } else {
                department = this.dp_nameMap.get(string + department.getPid());
            }
            if (!this.postSet.contains(string2)) {
                this.postSet.add(string2);
                this.saveDepartmentPost(ALL_DEPARTMENT, FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, string2, ALL_DEPARTMENT.getPid());
            }
            this.saveDepartmentPost(department, string3, string2, department.getPid());
            if (tableDataUser != null) {
                tableDataUser.setDepartmentValue(string);
                tableDataUser.setDepartmentPid(department.getPid());
                tableDataUser.setPostValue(string2);
                tableDataUser.addCompanyRole(string + department.getPid(), string2);
            }
        }
    }

    private void initCustomRoleUser(Object object, TableDataUser tableDataUser) throws Exception {
        if (object != null && StringUtils.isNotBlank((String)GeneralUtils.objectToString((Object)object))) {
            String string = GeneralUtils.objectToString((Object)object);
            CustomRole customRole = new CustomRole(string, null);
            if (!this.customRoleNameListMap.containsKey(string)) {
                this.customRoleNameListMap.put(string, customRole);
            }
            if (tableDataUser != null) {
                tableDataUser.setRoleValue(string);
                tableDataUser.addCustomRole(string);
            }
        }
    }

    private void addDepartOrPostAll() {
        this.dp_nameMap.put(ALL_DEPARTMENT.getName() + ALL_DEPARTMENT.getPid(), ALL_DEPARTMENT);
        this.dp_idMap.put(ALL_DEPARTMENT.getId(), ALL_DEPARTMENT);
        this.postSet.add(FSConstants.COMPANYROLE.POST_ALL_NAME);
        this.saveDepartmentPost(ALL_DEPARTMENT, ALL_DEPARTMENT.getName(), FSConstants.COMPANYROLE.POST_ALL_NAME, ALL_DEPARTMENT.getPid());
    }

    private void saveDepartmentPost(Department department, String string, String string2, long l) {
        TableDataJRole tableDataJRole = new TableDataJRole(0L);
        tableDataJRole.setDpName(department.getName());
        tableDataJRole.setDpMarkValue(string);
        tableDataJRole.setDpId(department.getId());
        tableDataJRole.setPostName(string2);
        tableDataJRole.setParentId(l);
        if (this.companyRoleIDListMap.containsValue(tableDataJRole)) {
            return;
        }
        tableDataJRole.setId(comRoleId++);
        this.companyRoleIDListMap.put(tableDataJRole.getId(), tableDataJRole);
    }

    public void initRecursionTableDataDepartment(Department department, RecursionDataModel recursionDataModel, int n) throws Exception {
        int n2 = recursionDataModel.getMarkField();
        int n3 = recursionDataModel.getParentMarkField();
        if (n3 < 0) {
            String string = GeneralUtils.objectToString((Object)recursionDataModel.getValueAt(n, n2));
            String string2 = recursionDataModel.getParentValue(n);
            if (StringUtils.isEmpty((String)string2)) {
                string2 = DEFAULTPARENTIDSTRINGTYPE;
                department.setParentName("");
            } else {
                department.setParentName(this.markDepartment.get(string2));
            }
            department.setId(this.genIdFromString(string));
            department.setPid(this.genIdFromString(string2));
        } else {
            String string;
            String string3 = GeneralUtils.objectToString((Object)recursionDataModel.getValueAt(n, n2));
            Object object = recursionDataModel.getValueAt(n, n3);
            String string4 = string = object == null ? DEFAULTPARENTIDSTRINGTYPE : GeneralUtils.objectToString((Object)object);
            if (StringUtils.isEmpty((String)string)) {
                string = DEFAULTPARENTIDSTRINGTYPE;
                department.setParentName("");
            } else {
                department.setParentName(this.markDepartment.get(string));
            }
            department.setId(this.genIdFromString(string3));
            department.setPid(this.genIdFromString(string));
        }
    }

    private long genIdFromString(String string) throws Exception {
        try {
            long l = Long.parseLong(string);
            if (!this.excludeId.contains(l)) {
                this.departIdMap.put(string, l);
            }
            return l;
        }
        catch (Exception exception) {
            String string2 = this.markDepartment.get(string);
            String string3 = this.getFullParentName(string);
            Department department = DepartmentControl.getInstance().findDepartmentByNameAndParentName(string2, string3);
            if (department != null) {
                long l = department.getId();
                this.excludeId.add(l);
                this.departIdMap.put(string, l);
                return l;
            }
            Long l = this.departIdMap.get(string);
            if (l != null) {
                return l;
            }
            long l2 = this.departIdMap.size() + 1;
            while (this.departIdMap.containsValue(l2) || this.special.contains(l2)) {
                ++l2;
            }
            this.excludeId.add(l2);
            this.departIdMap.put(string, l2);
            return l2;
        }
    }

    private String getFullParentName(String string) {
        String string2 = this.markDepAndParentDep.get(string);
        if (string2 == null || ComparatorUtils.equals((String)"", (String)string2)) {
            return "";
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = this.markDepartment.get(string2);
        stringBuilder.append(string3);
        string2 = this.markDepAndParentDep.get(string2);
        while (string2 != null && !ComparatorUtils.equals((String)"", (String)string2)) {
            string3 = this.markDepartment.get(string2);
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            if (hashSet.contains(string2)) {
                return null;
            }
            hashSet.add(string2);
            string2 = this.markDepAndParentDep.get(string2);
        }
        return stringBuilder.toString();
    }
}

