/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.UserCache;
import com.fr.fs.cache.UserCacheProvider;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCacheImpl
implements UserCacheProvider {
    private static UserCacheProvider userCacheProvider;

    public static UserCacheProvider getInstance() {
        if (userCacheProvider == null) {
            UserCacheImpl.initCacheImpl();
        }
        return userCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                userCacheProvider = new UserCacheImpl();
                RPC.registerSkeleton((Object)userCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                userCacheProvider = (UserCacheProvider)RPC.getProxy(UserCacheImpl.class, (String)string);
                break;
            }
            default: {
                userCacheProvider = new UserCacheImpl();
            }
        }
    }

    @Override
    public void addToHistory(long l, UserCache.IDText iDText) {
        UserCache.addToHistory(l, iDText);
    }

    @Override
    public int getHistoryCount(long l) {
        return UserCache.getHistoryCount(l);
    }

    @Override
    public UserCache.IDText getHistory(long l, int n) {
        return UserCache.getHistory(l, n);
    }

    @Override
    public void removeHistory(long l, UserCache.IDText iDText) {
        UserCache.removeHistory(l, iDText);
    }

    @Override
    public boolean checkHistory(long l, UserCache.IDText iDText) {
        return UserCache.checkHistory(l, iDText);
    }

    @Override
    public void cache(long l) throws Exception {
        UserCache.cache(l);
    }

    @Override
    public void cache(String string) throws Exception {
        UserCache.cache(string);
    }

    @Override
    public void cacheJob(long l, long l2, long l3) throws Exception {
        UserCache.cacheJob(l, l2, l3);
    }

    @Override
    public boolean refreshCacheInfo(long l, String string, String string2, String string3, String string4, String string5) throws Exception {
        return UserCache.refreshCacheInfo(l, string, string2, string3, string4, string5);
    }

    @Override
    public void refreshCacheJob(long l) throws Exception {
        UserCache.refreshCacheJob(l);
    }

    @Override
    public void cacheSRole(long l, CustomRole customRole) {
        UserCache.cacheSRole(l, customRole);
    }

    @Override
    public void refreshAfterAddSRole(long[] lArray, long l) {
        UserCache.refreshAfterAddSRole(lArray, l);
    }

    @Override
    public void refreshAfterDelSRoleUser(long[] lArray, long l) throws Exception {
        UserCache.refreshAfterDelSRoleUser(lArray, l);
    }

    @Override
    public void removeCacheSRole(long l, CustomRole customRole) throws Exception {
        UserCache.removeCacheSRole(l, customRole);
    }

    @Override
    public void addNoRoleUser(long l) {
        UserCache.addNoRoleUser(l);
    }

    @Override
    public void removeNoRoleUser(long l) {
        UserCache.removeNoRoleUser(l);
    }

    @Override
    public void checkAndAddNoRoleUser(long l) throws Exception {
        UserCache.checkAndAddNoRoleUser(l);
    }

    @Override
    public Set<User> getNoRoleUsers() throws Exception {
        return UserCache.getNoRoleUsers();
    }

    @Override
    public void removeAllCache() {
        UserCache.removeAllCache();
    }

    @Override
    public void removeCache(long l) {
        UserCache.removeCache(l);
    }

    @Override
    public User getUserById(long l) throws Exception {
        return UserCache.getUserById(l);
    }

    @Override
    public User getUserByName(String string) throws Exception {
        return UserCache.getUserByName(string);
    }

    @Override
    public Set<CustomRole> getSRoles(long l) throws Exception {
        return UserCache.getSRoles(l);
    }

    @Override
    public Set<Long> getAllCompanyRoleIDs(long l) {
        return UserCache.getAllCompanyRoleIDs(l);
    }

    @Override
    public Set<String> getAllCompanyRoleNames(long l) {
        return UserCache.getAllCompanyRoleNames(l);
    }

    @Override
    public Set<EntryTypeAndID> getAllEntryPrivileges(long l) throws Exception {
        return UserCache.getAllEntryPrivileges(l);
    }

    @Override
    public Set getAllTemplatePrivileges(long l) throws Exception {
        return UserCache.getAllTemplatePrivileges(l);
    }

    @Override
    public Set<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) throws Exception {
        return UserCache.getAllDepAndCRolePrivileges(l);
    }

    @Override
    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) throws Exception {
        return UserCache.getAllDataConnectionPrivileges(l);
    }

    @Override
    public Set<RoleModulePrivilege> getAllModulePrivileges(long l) throws Exception {
        return UserCache.getAllModulePrivileges(l);
    }

    @Override
    public boolean containModulePrivilege(long l, long l2) {
        return UserCache.containModulePrivilege(l, l2);
    }

    @Override
    public Set<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) throws Exception {
        return UserCache.getAllHomePagePrivileges(l);
    }

    @Override
    public boolean containHomePagePrivilege(long l, long l2) {
        return UserCache.containHomePagePrivilege(l, l2);
    }

    @Override
    public boolean containPlatePrivilege(long l, long l2, String string) {
        return UserCache.containPlatePrivilege(l, l2, string);
    }

    @Override
    public boolean containEntryPrivilege(long l, int n, long l2) {
        return UserCache.containEntryPrivilege(l, n, l2);
    }

    @Override
    public void refreshAfterDelDepartment(long l) {
        UserCache.refreshAfterDelDepartment(l);
    }

    @Override
    public void refreshAfterDelPost(long l) {
        UserCache.refreshAfterDelPost(l);
    }

    @Override
    public void refreshAfterDeleteCompanyRole(long l) {
        UserCache.refreshAfterDeleteCompanyRole(l);
    }

    @Override
    public void refreshAfterUpdateJRole(CompanyRole companyRole) {
        UserCache.refreshAfterUpdateJRole(companyRole);
    }

    @Override
    public void refreshAfterDelSRole(long l) {
        UserCache.refreshAfterDelSRole(l);
    }

    @Override
    public List getDuplicatedUsers() {
        return UserCache.getDuplicatedUsers();
    }

    @Override
    public void setDuplicatedUsers(List list) {
        UserCache.setDuplicatedUsers(list);
    }

    public Set getUsersByJob(long l) {
        return UserCache.getUsersByJob(l);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                UserCacheImpl.userCacheProvider = null;
            }
        });
    }
}

