/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.IDLockCreator;
import com.fr.general.FRLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCache {
    private static Map<Long, Post> postMap = new ConcurrentHashMap<Long, Post>();
    private static final IDLockCreator DIDLOCKCREATER = new IDLockCreator();
    private static Map<String, Post> postNameMap = new ConcurrentHashMap<String, Post>();

    public static void initCacheTree() {
        if (postMap.isEmpty()) {
            try {
                List list = FSConfig.getProviderInstance().getControl().getPostDAO().findAll();
                for (Object e : list) {
                    Post post = (Post)((Object)e);
                    postMap.put(post.getId(), post);
                    postNameMap.put(post.getPostname(), post);
                }
            }
            catch (Exception exception) {
                postMap.clear();
                postNameMap.clear();
            }
        }
    }

    public static void reInit() {
        postMap.clear();
        postNameMap.clear();
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            FRLogger.getLogger().info(exception.getMessage());
        }
    }

    public static void clearCache() throws Exception {
        postMap.clear();
        postNameMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(Post post) {
        if (post == null || post.getId() < 0L) {
            return;
        }
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = DIDLOCKCREATER.getIDLock(post.getId());
        try {
            Object object2 = object;
            synchronized (object2) {
                block11: {
                    if (!postMap.containsKey(post.getId())) break block11;
                    return;
                }
                postMap.put(post.getId(), post);
                postNameMap.put(post.getPostname(), post);
            }
        }
        finally {
            DIDLOCKCREATER.releaseIDLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheNewName(long l, String string) {
        if (l < 0L) {
            return;
        }
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = DIDLOCKCREATER.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                Post post = postMap.get(l);
                if (post != null) {
                    postNameMap.remove(post.getPostname());
                    post.setPostname(string);
                    postNameMap.put(string, post);
                }
            }
        }
        finally {
            DIDLOCKCREATER.releaseIDLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeCache(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = DIDLOCKCREATER.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                block11: {
                    Post post = postMap.get(l);
                    if (post == null) break block11;
                    postNameMap.remove(post.getPostname());
                    postMap.remove(l);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            DIDLOCKCREATER.releaseIDLock();
        }
        return false;
    }

    public static Post getPost(long l) {
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return postMap.get(l);
    }

    public static Post getPostByName(String string) {
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return postNameMap.get(string);
    }

    public static String getPostName(long l) {
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Post post = postMap.get(l);
        return post == null ? null : post.getPostname();
    }

    public static List<Post> getAllPost() throws Exception {
        try {
            PostCache.initCacheTree();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator<Map.Entry<Long, Post>> iterator = postMap.entrySet().iterator();
        ArrayList<Post> arrayList = new ArrayList<Post>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getValue());
        }
        return arrayList;
    }
}

