/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.cache.EntryCache;
import com.fr.fs.cache.EntryCacheProvider;
import com.fr.fs.cache.EntryTreeFolderNode;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;

public class EntryCacheImpl
implements EntryCacheProvider {
    private static EntryCacheProvider entryCacheProvider;

    public EntryTreeFolderNode getRootNode() {
        return EntryCache.getRootNode();
    }

    public void initCacheTree() throws Exception {
        EntryCache.initCacheTree();
    }

    public EntryTreeFolderNode getFolderTreeNode(long l) {
        return EntryCache.getFolderTreeNode(l);
    }

    public void removeCache(int n, long l) {
        EntryCache.removeCache(n, l);
    }

    public boolean cache(Entry entry) {
        return EntryCache.cache(entry);
    }

    public Entry getCacheEntry(int n, long l) {
        return EntryCache.getCacheEntry(n, l);
    }

    public static EntryCacheProvider getInstance() {
        if (entryCacheProvider == null) {
            EntryCacheImpl.initCache();
        }
        return entryCacheProvider;
    }

    private static synchronized void initCache() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                entryCacheProvider = new EntryCacheImpl();
                RPC.registerSkeleton((Object)entryCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                entryCacheProvider = (EntryCacheProvider)RPC.getProxy(EntryCacheImpl.class, (String)string);
                break;
            }
            default: {
                entryCacheProvider = new EntryCacheImpl();
            }
        }
    }

    public void reInit() throws Exception {
        EntryCache.reInit();
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                EntryCacheImpl.entryCacheProvider = null;
            }
        });
    }
}

