/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.IssueControl;
import com.fr.web.core.process.reportprocess.ProcessElement;
import com.fr.web.core.process.reportprocess.ProcessManager;
import com.fr.web.core.process.reportprocess.ProcessNode;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import com.fr.web.core.process.reportprocess.ReportControl;
import com.fr.web.core.process.reportprocess.ReportProcess;
import com.fr.web.core.process.reportprocess.dao.ProcessNodeDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplDAO;
import com.fr.web.core.process.reportprocess.dao.ReportProcessDAO;
import com.fr.web.core.process.reportprocess.operator.ProcessOperator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTask
implements ProcessElement {
    public static final String PARENT_ID = "parentId";
    public static final String PROCESS_ID = "processId";
    public static final String ISSUE_CONTROL = "issueControl";
    public static final String DEADLINEDATE = "deadLineDate";
    public static final String DEADLINETYPE = "deadLineType";
    public static final String REMIND_CONTROL = "remindControl";
    public static final String ISSUE_OVER = "issueOver";
    public static final String ADMIN = "admin";
    public static final String LEAPFROG_BACK = "leapfrogBack";
    private static final int SERIAL_NUM = 99999;
    private static final int MIN_INDEX = 1;
    private long id = -1L;
    private String name;
    private long processId;
    private long parentId = -1L;
    private long creatorId;
    private String creatorName;
    private Date createTime = new Date();
    private String issueControl;
    private int deadLineDate;
    private String deadLineType;
    private String remindControl;
    private boolean issueOver;
    private boolean leapfrogBack;
    private ReportProcess process;
    public static final ObjectTableMapper TABLE_MAPPER = new ObjectTableMapper(ProcessTask.class, new Table("FR_REPORT_PROCESS_TASK"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", -5, new ColumnSize(8)), new CommonFieldColumnMapper("name", 12, new ColumnSize(1024), false), new CommonFieldColumnMapper("processId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("creatorId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("issueControl", 12, new ColumnSize(1024), true), new CommonFieldColumnMapper("deadLineDate", 4, new ColumnSize(4), true), new CommonFieldColumnMapper("deadLineType", 1, new ColumnSize(1), true), new CommonFieldColumnMapper("remindControl", 12, new ColumnSize(255), true), new CommonFieldColumnMapper("createTime", 93, new ColumnSize(10), false), new CommonFieldColumnMapper("issueOver", 16, new ColumnSize(1), false), new CommonFieldColumnMapper("parentId", -5, new ColumnSize(8), true), new CommonFieldColumnMapper("creatorName", 12, new ColumnSize(1024), false), new CommonFieldColumnMapper("leapfrogBack", 16, new ColumnSize(1), false)}, 0);

    public ProcessTask() {
    }

    public ProcessTask(String string, long l2, String string2, long l3, long l4, String string3, int n2, String string4, String string5, boolean bl) {
        this.name = string;
        this.creatorId = l2;
        this.creatorName = string2;
        this.processId = l3;
        this.parentId = l4;
        this.issueControl = string3;
        this.deadLineDate = n2;
        this.deadLineType = string4;
        this.leapfrogBack = bl;
        this.remindControl = string5;
    }

    public ProcessTask(JSONObject jSONObject) {
        this.parseJSON(jSONObject);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getProcessId() {
        return this.processId;
    }

    public boolean isLeapfrogBack() {
        return this.leapfrogBack;
    }

    public void setLeapfrogBack(boolean bl) {
        this.leapfrogBack = bl;
    }

    public void setProcessId(long l2) {
        this.processId = l2;
    }

    @Override
    public long getCreatorId() {
        if (ComparatorUtils.equals((String)this.creatorName, (String)ADMIN)) {
            return -999L;
        }
        return ProcessUtils.getUserIdFromStr(this.creatorName);
    }

    public void setCreatorId(long l2) {
        this.creatorId = l2;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long l2) {
        this.parentId = l2;
    }

    public String getIssueControl() {
        return this.issueControl;
    }

    public void setIssueControl(String string) {
        this.issueControl = string;
    }

    public String getRemindControl() {
        return this.remindControl;
    }

    public void setRemindControl(String string) {
        this.remindControl = string;
    }

    public void setIssueOver(boolean bl) {
        this.issueOver = bl;
    }

    public void setCreateTime(Date date) {
        this.createTime = date;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isIssueOver() {
        return this.issueOver;
    }

    public int getDeadLineDate() {
        return this.deadLineDate;
    }

    public void setDeadLineDate(int n2) {
        this.deadLineDate = n2;
    }

    public String getDeadLineType() {
        return this.deadLineType;
    }

    public void setDeadLineType(String string) {
        this.deadLineType = string;
    }

    public ReportProcess getProcess() {
        return this.process;
    }

    @Override
    public JSONObject createJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.id);
        jSONObject.put("name", (Object)this.name);
        jSONObject.put("creatorId", this.getCreatorId());
        jSONObject.put("creatorName", (Object)this.creatorName);
        jSONObject.put("department", (Object)ProcessUtils.getUserDepartmentName(this.getCreatorId()));
        jSONObject.put("createTime", (Object)DateUtils.getDate2Str((String)"yyyy-MM-dd HH:mm:ss", (Date)this.createTime));
        return jSONObject;
    }

    public JSONObject createDetailedJSONObject() throws Exception {
        JSONObject jSONObject = this.createJSONObject();
        jSONObject.put(ISSUE_CONTROL, (Object)this.issueControl);
        jSONObject.put(REMIND_CONTROL, (Object)this.remindControl);
        jSONObject.put(LEAPFROG_BACK, this.leapfrogBack);
        if (this.deadLineDate != -1) {
            jSONObject.put(DEADLINEDATE, this.deadLineDate);
        }
        if (this.deadLineType != null) {
            jSONObject.put(DEADLINETYPE, (Object)this.deadLineType);
        }
        try {
            if (this.process == null) {
                this.process = (ReportProcess)ReportProcessDAO.getInstance().findByID(this.processId);
            }
            if (this.process != null) {
                jSONObject.put("process", (Object)this.process.createJSONObject());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) {
        if (jSONObject.has("name")) {
            this.name = jSONObject.optString("name");
        }
        if (jSONObject.has(PROCESS_ID)) {
            this.processId = jSONObject.optInt(PROCESS_ID);
        }
        if (jSONObject.has(ISSUE_CONTROL)) {
            this.issueControl = jSONObject.optString(ISSUE_CONTROL);
        }
        if (jSONObject.has(DEADLINEDATE)) {
            this.deadLineDate = jSONObject.optInt(DEADLINEDATE);
        }
        if (jSONObject.has(DEADLINETYPE)) {
            this.deadLineType = jSONObject.optString(DEADLINETYPE);
        }
        if (jSONObject.has(REMIND_CONTROL)) {
            this.remindControl = jSONObject.optString(REMIND_CONTROL);
        }
    }

    private String[] getNodesArrFromProcess() throws Exception {
        if (this.process == null) {
            this.process = (ReportProcess)ReportProcessDAO.getInstance().findByID(this.processId);
        }
        if (this.process != null) {
            return this.process.getNodesArr();
        }
        return new String[0];
    }

    public void issue() throws Exception {
        block2: {
            int n2;
            block3: {
                String[] stringArray = this.getNodesArrFromProcess();
                int n3 = stringArray.length;
                JSONArray jSONArray = new JSONArray();
                JSONObject jSONObject = new JSONObject();
                if (n3 <= 0) break block2;
                ProcessNode processNode = (ProcessNode)ProcessNodeDAO.getInstance().findByID(ProcessUtils.getIdFromStr(stringArray[0]));
                String string = processNode.getReportControl();
                JSONArray jSONArray2 = new JSONArray(string);
                n2 = jSONArray2.length();
                if (n2 <= 1) break block3;
                int[] nArray = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    ReportControl reportControl = new ReportControl(jSONArray2.getString(i2));
                    ProcessOperator processOperator = reportControl.getOperator();
                    if (processOperator == null) continue;
                    int n4 = processOperator.getOperatorCount();
                    JSONObject jSONObject2 = processOperator.getOperateJSON();
                    nArray[i2] = n4;
                    this.putCompleteState(jSONArray, jSONObject2, jSONObject, reportControl, processOperator, n2, 0);
                }
                break block2;
            }
            if (n2 != 1) break block2;
            List<ProcessTaskImpl> list = this.getAllProcessTaskImpl(0);
            String string = String.valueOf((long)(Math.random() * 99999.0));
            for (ProcessTaskImpl processTaskImpl : list) {
                processTaskImpl.setFrTaskId(Long.parseLong(processTaskImpl.getTaskId() + string));
                this.issueTask(processTaskImpl);
            }
        }
    }

    public ProcessOperator getAllProcessOperator(int n2) throws Exception {
        String[] stringArray = this.getNodesArrFromProcess();
        long l2 = ProcessUtils.getIdFromStr(stringArray.length > n2 ? stringArray[n2] : "");
        ProcessNode processNode = (ProcessNode)ProcessNodeDAO.getInstance().findByID(l2);
        String string = processNode.getReportControl();
        JSONArray jSONArray = new JSONArray(string);
        ReportControl reportControl = new ReportControl(jSONArray.getString(0));
        return reportControl.getOperator();
    }

    public List<ProcessTaskImpl> getAllProcessTaskImpl(int n2) throws Exception {
        String[] stringArray = this.getNodesArrFromProcess();
        long l2 = ProcessUtils.getIdFromStr(stringArray.length > n2 ? stringArray[n2] : "");
        ProcessNode processNode = (ProcessNode)ProcessNodeDAO.getInstance().findByID(l2);
        String string = processNode.getReportControl();
        JSONArray jSONArray = new JSONArray(string);
        ReportControl reportControl = new ReportControl(jSONArray.getString(0));
        ArrayList<ProcessTaskImpl> arrayList = new ArrayList<ProcessTaskImpl>();
        ProcessOperator processOperator = reportControl.getOperator();
        if (processOperator != null) {
            String[] stringArray2 = processOperator.getIds();
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                Object object;
                JSONObject jSONObject = new JSONObject();
                JSONObject jSONObject2 = new JSONObject();
                JSONObject jSONObject3 = processOperator.getOperateJSON();
                String string2 = "{}";
                if (jSONObject3.has(stringArray2[i2])) {
                    string2 = jSONObject3.getJSONObject(stringArray2[i2]).toString();
                }
                jSONObject.put(stringArray2[i2], ProcessTaskImpl.NOT_COMPLETE);
                jSONObject2.put(reportControl.getReportPath(), (Object)jSONObject);
                boolean bl = processNode.isNeedAllComplete();
                if (stringArray2.length == 1 && n2 > 0) {
                    object = (ProcessNode)ProcessNodeDAO.getInstance().findByID(ProcessUtils.getIdFromStr(stringArray[--n2]));
                    bl = ((ProcessNode)object).isNeedAllComplete();
                }
                object = new ProcessTaskImpl(this, string2, -1, -1, bl);
                this.dealFirtNodeTaskId(n2, (ProcessTaskImpl)object, bl, String.valueOf(ProcessUtils.getUserIdFromStr(stringArray2[i2])));
                ((ProcessTaskImpl)object).setNodeRoute(this.rebuidNodeRoute(ProcessUtils.getUserNameById(stringArray2[i2])).toString());
                ((ProcessTaskImpl)object).initCompleteState(jSONObject2.toString());
                ((ProcessTaskImpl)object).setUseDataSource(processOperator.isUseDataSource());
                arrayList.add((ProcessTaskImpl)object);
            }
        }
        return arrayList;
    }

    private void dealFirtNodeTaskId(int n2, ProcessTaskImpl processTaskImpl, boolean bl, String string) {
        if (n2 < 1 && !bl) {
            String string2 = String.valueOf(processTaskImpl.getTaskId());
            string2 = string2 + "00000" + string;
            processTaskImpl.setTaskId(Long.parseLong(string2));
        }
    }

    private JSONArray rebuidNodeRoute(String string) {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(String.valueOf(0), (Object)string);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
        jSONArray.put((Object)jSONObject);
        return jSONArray;
    }

    public List<ProcessTaskImpl> getAllProcessTaskImpl(long l2) throws Exception {
        return ProcessTaskImplDAO.getInstance().listByFieldValue("taskId", l2, 0);
    }

    public List<ProcessTaskImpl> getProcessTaskImplByUsername(String string, int n2) throws Exception {
        List<ProcessTaskImpl> list = this.getAllTaskImpl();
        ArrayList<ProcessTaskImpl> arrayList = new ArrayList<ProcessTaskImpl>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            try {
                String string2 = list.get(i2).getCompleteState();
                JSONObject jSONObject = new JSONObject(string2);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string3 = Utils.objectToString(iterator.next());
                    JSONObject jSONObject2 = jSONObject.getJSONObject(string3);
                    Iterator iterator2 = jSONObject2.keys();
                    while (iterator2.hasNext()) {
                        int n3;
                        String string4 = Utils.objectToString(iterator2.next());
                        if (!ComparatorUtils.equals((String)string4, (String)string)) continue;
                        for (n3 = list.get(i2).getCurrentNodeIdx(); n3 != n2 && n3 < n2; ++n3) {
                        }
                        if (n3 != n2) continue;
                        list.get(i2).setCurrentNodeIdx(n3);
                        arrayList.add(jSONObject2.getInt(string4) == ProcessTaskImpl.COMPLETE ? list.get(i2) : null);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(null);
        }
        return arrayList;
    }

    public List<ProcessTaskImpl> getProcessTaskImplByRole(String string, int n2) {
        List<ProcessTaskImpl> list = this.getAllTaskImpl();
        ArrayList<ProcessTaskImpl> arrayList = new ArrayList<ProcessTaskImpl>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            try {
                String string2 = list.get(i2).getCompleteState();
                JSONObject jSONObject = new JSONObject(string2);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string3 = Utils.objectToString(iterator.next());
                    JSONObject jSONObject2 = jSONObject.getJSONObject(string3);
                    Iterator iterator2 = jSONObject2.keys();
                    while (iterator2.hasNext()) {
                        String string4 = Utils.objectToString(iterator2.next());
                        if (!ComparatorUtils.equals((String)string4, (String)string) || list.get(i2).getCurrentNodeIdx() != n2) continue;
                        arrayList.add(jSONObject2.getInt(string4) == ProcessTaskImpl.COMPLETE ? list.get(i2) : null);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(null);
        }
        return arrayList;
    }

    public void issueTask(ProcessTaskImpl processTaskImpl) throws Exception {
        long l2 = ProcessTaskImplDAO.getInstance().save(processTaskImpl);
        if (l2 >= 0L) {
            processTaskImpl.setId(l2);
            ProcessManager.addTask(processTaskImpl);
            processTaskImpl.onIssue();
        }
    }

    private void putCompleteState(JSONArray jSONArray, JSONObject jSONObject, JSONObject jSONObject2, ReportControl reportControl, ProcessOperator processOperator, int n2, int n3) throws Exception {
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            boolean bl;
            if (reportControl == null) {
                return;
            }
            JSONObject jSONObject3 = new JSONObject();
            JSONObject jSONObject4 = new JSONObject();
            JSONObject jSONObject5 = new JSONObject();
            String string = Utils.objectToString(iterator.next());
            String string2 = jSONObject.getString(string);
            String[] stringArray = string2.split("##");
            boolean bl2 = bl = n2 > 1;
            if (jSONObject2.has(reportControl.getReportPath()) && bl) {
                jSONObject3 = jSONObject2.getJSONObject(reportControl.getReportPath());
            }
            Object[] objectArray = processOperator.getIds();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!ArrayUtils.contains((Object[])objectArray, (Object)stringArray[i2])) continue;
                jSONObject3.put(stringArray[i2], ProcessTaskImpl.NOT_COMPLETE);
            }
            jSONObject2.put(reportControl.getReportPath(), (Object)jSONObject3);
            jSONObject4.put(reportControl.getReportPath(), (Object)jSONObject3);
            jSONObject5.put(String.valueOf(n3), (Object)(bl ? jSONObject2 : jSONObject4));
            String string3 = jSONObject5.toString();
            jSONArray.put((Object)string3);
        }
    }

    public void onResume() {
        if (this.issueOver) {
            return;
        }
        if (this.issueControl == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.issueControl);
            IssueControl issueControl = new IssueControl(jSONObject);
            issueControl.issueTask(this);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void makeIssueOver() {
        this.issueOver = true;
        ProcessManager.clearIssue(this.id);
        try {
            ProcessTaskDAO.getInstance().updateIssueOver(this.id, true);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public List<ProcessTaskImpl> getAllTaskImpl() {
        try {
            List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldValue("taskId", this.id);
            if (list.isEmpty()) {
                this.findTagedTaskImpl(list);
            }
            return list;
        }
        catch (Exception exception) {
            return new ArrayList<ProcessTaskImpl>();
        }
    }

    private void findTagedTaskImpl(List<ProcessTaskImpl> list) throws Exception {
        List list2 = ProcessTaskImplDAO.getInstance().findAll();
        int n2 = list2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ProcessTaskImpl processTaskImpl = (ProcessTaskImpl)list2.get(i2);
            long l2 = processTaskImpl.getTaskId();
            if (!String.valueOf(l2).contains("123456789") || ProcessUtils.getTreatedTaskId(l2) != this.id) continue;
            list.add(processTaskImpl);
        }
    }

    public void clear() {
        try {
            JSONObject jSONObject = new JSONObject(this.issueControl);
            Boolean bl = jSONObject.getBoolean("onlyOnce");
            if (this.issueControl != null && !bl.booleanValue()) {
                ProcessManager.clearIssue(this.id);
            }
            ProcessTaskDAO.getInstance().deleteByID(this.id);
            List<ProcessTaskImpl> list = this.getAllTaskImpl();
            for (ProcessTaskImpl processTaskImpl : list) {
                processTaskImpl.clear();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

