/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.sheet;

import com.fr.cache.list.IntList;
import com.fr.main.impl.WorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.parser.SheetIntervalLiteral;
import com.fr.privilege.PrivilegeManager;
import com.fr.report.core.A.J;
import com.fr.report.core.sheet.SequenceExecutor;
import com.fr.report.core.sheet.SheetExecutor;
import com.fr.report.core.sheet.WorkBookExecutor;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.report.ResultReport;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.fun.Actor;
import com.fr.report.worksheet.WorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.ListMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetSequenceExecutor
extends SequenceExecutor {
    private WorkBook workbook;
    private WorkBookExecutor bookExecutor;

    public SheetSequenceExecutor(WorkBook workBook, Map<String, Object> map) {
        if (workBook != null) {
            int n2 = workBook.getReportCount();
            this.nameListMap = new ListMap(n2);
            this.executed_mark = new IntList(n2);
            this.executor_list = new ArrayList(n2);
            this.exe_info_list = new ArrayList(n2);
            this.exe_start_time_list = new ArrayList(workBook.getReportCount());
            for (int i2 = 0; i2 < n2; ++i2) {
                TemplateReport templateReport = workBook.getTemplateReport(i2);
                this.nameListMap.put((Object)workBook.getReportName(i2), (Object)templateReport);
                this.executed_mark.add(0);
                this.executor_list.add(null);
                this.exe_info_list.add(new int[n2]);
                this.exe_start_time_list.add(null);
            }
        }
        this.workbook = workBook;
        this.parameterMap = map;
    }

    public ResultWorkBook execute(Actor actor) {
        if (this.workbook == null) {
            return null;
        }
        this.bookExecutor = actor.createWorkBookExecutor(this.workbook, this.parameterMap);
        this._execute();
        try {
            ResultWorkBook resultWorkBook = this.bookExecutor.result();
            return resultWorkBook;
        }
        finally {
            this.bookExecutor = null;
        }
    }

    protected void _execute() {
        int n2 = this.nameListMap.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateReport templateReport = (TemplateReport)this.nameListMap.getByIndex(i2);
            this.current_index = i2;
            ResultReport resultReport = null;
            if (!templateReport.isElementCaseReport()) {
                String[] stringArray = PrivilegeManager.getRoleFromCalculator((Calculator)Calculator.createCalculator());
                if (templateReport.getWorkSheetPrivilegeControl().checkInvisible(stringArray)) {
                    this.executed_mark.set(this.current_index, 1);
                } else {
                    resultReport = this.bookExecutor.execute(this.current_index, templateReport);
                }
            } else {
                this.stuffExecutor(this.bookExecutor.getExeType(), templateReport);
            }
            if (null == resultReport) continue;
            this.executed_mark.set(this.current_index, 1);
        }
        while (this.next()) {
            SheetExecutor sheetExecutor = this.getExecutor();
            this.execute(sheetExecutor);
        }
    }

    @Override
    protected long execute4Expand(SheetExecutor sheetExecutor) {
        return sheetExecutor == null ? 0L : sheetExecutor.execute4Expand(this.bookExecutor.getExeType());
    }

    @Override
    protected void addExecutor4Result(SheetExecutor sheetExecutor, long l2) {
        this.bookExecutor.addResult(this.current_index, sheetExecutor.execute4ECReport(this.bookExecutor.getExeType(), l2));
    }

    @Override
    protected void addExecutor4Result(int n2) {
        this.bookExecutor.addResult(n2, ((SheetExecutor)this.executor_list.get(n2)).execute4ECReport(this.bookExecutor.getExeType(), (Long)this.exe_start_time_list.get(n2)));
    }

    @Override
    protected String getLiteralName(List list, int n2) {
        SheetIntervalLiteral sheetIntervalLiteral = (SheetIntervalLiteral)list.get(n2);
        return sheetIntervalLiteral.getSheetName();
    }

    @Override
    public TemplateElementCase getTemplateByIndex(int n2) {
        TemplateReport templateReport = (TemplateReport)this.nameListMap.getByIndex(n2);
        if (templateReport.isElementCaseReport()) {
            return (TemplateElementCase)((Object)templateReport);
        }
        return null;
    }

    @Override
    public ResultElementCase getResultByIndex(int n2) {
        if (this.bookExecutor != null) {
            return this.bookExecutor.getResultByIndex(n2);
        }
        return null;
    }

    protected void stuffExecutor(Actor actor, TemplateReport templateReport) {
        try {
            templateReport = (WorkSheet)templateReport.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap();
        }
        if (!actor.canCalculateOnDemand() || ((WorkSheet)templateReport).getLayerReportAttr() == null) {
            J j2 = new J((WorkSheet)templateReport, (Map<String, Object>)this.parameterMap, this, templateReport.getTableDataSource());
            this.executor_list.set(this.current_index, j2);
        }
    }
}

