/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.range;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.script.CalculatorProvider;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class MinAndMaxValue
implements Cloneable,
Serializable {
    private Formula minValue = new Formula("0");
    private Formula maxValue = new Formula("0");
    private static final int DEFAULT_MAX = 100;
    private boolean isCustomMin = false;
    private boolean isCustomMax = false;

    public MinAndMaxValue(Formula formula, Formula formula2) {
        this.minValue = formula;
        this.maxValue = formula2;
    }

    public Formula getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Formula formula) {
        this.minValue = formula;
    }

    public Formula getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Formula formula) {
        this.maxValue = formula;
    }

    public boolean isCustomMin() {
        return this.isCustomMin;
    }

    public void setCustomMin(boolean bl) {
        this.isCustomMin = bl;
    }

    public boolean isCustomMax() {
        return this.isCustomMax;
    }

    public void setCustomMax(boolean bl) {
        this.isCustomMax = bl;
    }

    public double getMaxNum() {
        Number number = ChartBaseUtils.formula2Number((Formula)this.maxValue);
        if (number != null) {
            return number.doubleValue();
        }
        return 100.0;
    }

    public double getMinNum() {
        Number number = ChartBaseUtils.formula2Number((Formula)this.minValue);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private double dealStringOrDate2Value(Object object) {
        if (object != null) {
            Number number = Utils.string2Number((String)Utils.objectToString((Object)object));
            if (number != null) {
                return number.doubleValue();
            }
            if (object instanceof Date) {
                return ((Date)object).getTime();
            }
            String string = Pattern.compile("=").matcher(Utils.objectToString((Object)object)).replaceAll("");
            string = Pattern.compile("\"").matcher(string).replaceAll("");
            Date date = DateUtils.string2Date((String)string, (boolean)true);
            if (date != null) {
                return ChartBaseUtils.date2Int((Date)date, (int)6);
            }
        }
        return 0.0;
    }

    public Object clone() throws CloneNotSupportedException {
        MinAndMaxValue minAndMaxValue = (MinAndMaxValue)super.clone();
        minAndMaxValue.setCustomMin(this.isCustomMin());
        minAndMaxValue.setCustomMax(this.isCustomMax());
        minAndMaxValue.setMinValue((Formula)this.getMinValue().clone());
        minAndMaxValue.setMaxValue((Formula)this.getMaxValue().clone());
        return minAndMaxValue;
    }

    public boolean equals(Object object) {
        return object instanceof MinAndMaxValue && ((MinAndMaxValue)object).isCustomMin() == this.isCustomMin() && ((MinAndMaxValue)object).isCustomMax() == this.isCustomMax() && ComparatorUtils.equals((Object)((MinAndMaxValue)object).getMinValue(), (Object)this.getMinValue()) && ComparatorUtils.equals((Object)((MinAndMaxValue)object).getMaxValue(), (Object)this.getMaxValue());
    }

    public void dealFormula(Calculator calculator) {
        if (this.minValue != null) {
            Utils.dealFormulaValue((Object)this.minValue, (Calculator)calculator);
        }
        if (this.maxValue != null) {
            Utils.dealFormulaValue((Object)this.maxValue, (Calculator)calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.minValue != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.minValue, (List)list, (CalculatorProvider)calculator);
        }
        if (this.maxValue != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.maxValue, (List)list, (CalculatorProvider)calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.minValue != null) {
            mOD_COLUMN_ROW.mod_object((Object)this.minValue);
        }
        if (this.maxValue != null) {
            mOD_COLUMN_ROW.mod_object((Object)this.maxValue);
        }
    }
}

