/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.pie;

import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.ChartRoseType;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartPieLegendItemIcon;
import com.fr.plugin.chart.glyph.VanChartPlotGlyph;
import com.fr.plugin.chart.glyph.VanChartPlotGlyphInterface;
import com.fr.plugin.chart.pie.RoseTopDownShadeStyle;
import com.fr.plugin.chart.pie.VanChartPieDataPoint;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class VanChartPiePlotGlyph
extends VanChartPlotGlyph
implements VanChartPlotGlyphInterface {
    private static final long serialVersionUID = 895972529922603488L;
    private static final int ANGLE = 360;
    protected transient double radius = 0.0;
    private transient ArrayList leftUp = new ArrayList();
    private transient ArrayList rightUp = new ArrayList();
    private transient ArrayList leftDown = new ArrayList();
    private transient ArrayList rightDown = new ArrayList();
    protected double radiusPercent = 0.9;
    public static final double START_ANGLE = 90.0;
    protected static final double FIRST_QUA = 90.0;
    protected static final double SECOND_QUA = 180.0;
    protected static final double THRID_QUA = 270.0;
    private static final double FOUTH_QUA = 360.0;
    private static final double BEST_RAD = 0.9;
    protected static final double WHEN_MORE_RAD = 0.8;
    protected static final double MOVE_GAP = 0.1;
    protected static final double RADIO_PERCENT = 1.2;
    private static final double RADIUS_PERCENT_DIFF = 0.05;
    private static final double RADIUS_MIN_PERCENR = 0.5;
    private ChartRoseType roseType;
    private double innerRadiusPercent;
    private double startAngle;
    private double endAngle;
    private boolean supportRotation;

    public void setEndAngle(double d) {
        this.endAngle = d;
    }

    public void setInnerRadiusPercent(double d) {
        this.innerRadiusPercent = d;
    }

    public void setRoseType(ChartRoseType chartRoseType) {
        this.roseType = chartRoseType;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
    }

    public ChartRoseType getRoseType() {
        return this.roseType;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getInnerRadiusPercent() {
        return this.innerRadiusPercent;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setSupportRotation(boolean bl) {
        this.supportRotation = bl;
    }

    public boolean isSupportRotation() {
        return this.supportRotation;
    }

    @Override
    protected LineMarkerIcon getLegendMarkerIcon(VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        VanChartPieLegendItemIcon vanChartPieLegendItemIcon = new VanChartPieLegendItemIcon(this.innerRadiusPercent);
        this.dealMarkerIconCondition(vanChartPieLegendItemIcon, vanChartDataSeries, colorArray);
        return vanChartPieLegendItemIcon;
    }

    @Override
    public void layoutDataSeriesGlyph(int n) {
        super.layoutDataSeriesGlyph(n);
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.deal4EachCategory(i, n);
        }
    }

    private void deal4EachCategory(int n, int n2) {
        this.initLabelData(n);
        this.dealWithDataSeries(n, n2);
    }

    private void initLabelData(int n) {
        this.radius = this.getPieDimension(n) / 2.0;
        this.getSeriesCountWithQuadrant(n);
    }

    private double getPieDimension(int n) {
        Rectangle2D rectangle2D = this.getBounds();
        double d = rectangle2D.getWidth() / (double)this.getCategoryCount();
        double d2 = 0.0;
        d2 = d > rectangle2D.getHeight() ? rectangle2D.getHeight() / 1.2 : d / 1.2;
        d2 = this.deal4BestRad(d2, n);
        return d2;
    }

    private double getSeriesStartAngle(int n, int n2) {
        double d = 90.0 - this.getStartAngle();
        double d2 = this.getWholeAngle();
        for (int i = 0; i < n2; ++i) {
            d -= this.getPercent(i, n) * d2;
        }
        return d;
    }

    private double getHalfAngle(double d, int n, int n2) {
        return (d - this.getPercent(n, n2) * this.getWholeAngle() / 2.0 + 720.0) % 360.0;
    }

    private double getPercent(int n, int n2) {
        if (ComparatorUtils.equals((Object)((Object)this.roseType), (Object)((Object)ChartRoseType.PIE_SAME_ARC))) {
            return 1.0 / (double)this.getSeriesSize();
        }
        double d = this.getTotalValue(n2);
        if (d <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n);
        DataPoint dataPoint = dataSeries.getDataPoint(n2);
        return Math.abs(dataPoint.getValue()) / d;
    }

    private double getTotalValue(int n) {
        double d = 0.0;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint dataPoint = dataSeries.getDataPoint(n);
            d += Math.abs(dataPoint.getValue());
        }
        return d;
    }

    private double getWholeAngle() {
        double d = (this.endAngle - this.startAngle + 360.0) % 360.0;
        return d == 0.0 ? 360.0 : d;
    }

    private Shape getDataPointShape(Point2D point2D, double d, double d2, int n, int n2) {
        double d3 = this.getInnerRadius();
        double d4 = this.getOuterRadius(d2, n2, this.getSeries(n).getDataPoint(n2));
        GeneralPath generalPath = new GeneralPath();
        double d5 = this.getPercent(n, n2) * this.getWholeAngle();
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() - d4, point2D.getY() - d4, 2.0 * d4, 2.0 * d4, d - d5, d5, 0);
        Arc2D.Double double_2 = new Arc2D.Double(point2D.getX() - d3, point2D.getY() - d3, 2.0 * d3, 2.0 * d3, d, -d5, 0);
        generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
        generalPath.append(double_, true);
        if (Math.floor(Math.abs(d5 / 360.0)) >= 1.0) {
            generalPath.moveTo((float)double_2.getStartPoint().getX(), (float)double_2.getStartPoint().getY());
        } else {
            generalPath.lineTo((float)double_2.getStartPoint().getX(), (float)double_2.getStartPoint().getY());
        }
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    private double getInnerRadius() {
        return this.radius * this.getInnerRadiusPercent() / 100.0;
    }

    private double getOuterRadius(double d, int n, DataPoint dataPoint) {
        if (ComparatorUtils.equals((Object)((Object)this.roseType), (Object)((Object)ChartRoseType.PIE))) {
            return d;
        }
        return this.getInnerRadius() + (d - this.getInnerRadius()) / this.getMaxValue(n) * dataPoint.getValue();
    }

    private double getMaxValue(int n) {
        double d = 0.0;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            VanChartPieDataPoint vanChartPieDataPoint = (VanChartPieDataPoint)dataSeries.getDataPoint(n);
            d = Math.max(Math.abs(vanChartPieDataPoint.getValue()), d);
        }
        return d;
    }

    private ShapeGlyph calculateShapeGlyph4DifferentSub(VanChartPieDataPoint vanChartPieDataPoint) {
        Shape shape = this.getArc2D(vanChartPieDataPoint);
        ShapeGlyph shapeGlyph = new ShapeGlyph(shape);
        this.changeInfoWithCondition(shapeGlyph.getGeneralInfo(), vanChartPieDataPoint);
        return shapeGlyph;
    }

    private Shape getArc2D(DataPoint dataPoint) {
        int n = dataPoint.getSeriesIndex();
        int n2 = dataPoint.getCategoryIndex();
        double d = this.getSeriesStartAngle(n2, n) % 360.0;
        Point2D point2D = this.getCenterPoint(n2);
        return this.getDataPointShape(point2D, d, this.radius, n, n2);
    }

    private Point2D getCenterPoint(int n) {
        double d = this.getBounds().getWidth() / (double)this.getCategoryCount();
        double d2 = (double)n * d + d / 2.0;
        return new Point2D.Double(d2, this.getBounds().getHeight() / 2.0);
    }

    private boolean isOutsideLabel(int n, int n2) {
        AttrLabel attrLabel = (AttrLabel)this.getConditionCollection().getDataSeriesCondition(AttrLabel.class, (Result)this.getSeries(n).getDataPoint(n2));
        if (attrLabel == null) {
            return false;
        }
        return attrLabel.getPosition() == 6 || attrLabel.isShowGuidLine();
    }

    private boolean isGuideLineShow(DataPoint dataPoint) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return false;
        }
        AttrLabel attrLabel = (AttrLabel)this.getConditionCollection().getDataSeriesCondition(AttrLabel.class, (Result)dataPoint);
        String string = textGlyph.getText();
        return string != null && attrLabel.isShowGuidLine() && textGlyph.getBounds() != null;
    }

    private Dimension2D getLabelDim(DataPoint dataPoint, int n) {
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty((String)dataPoint.getDataLabel().getText())) {
            return new Dimension(0, 0);
        }
        AttrLabel attrLabel = (AttrLabel)this.getConditionCollection().getDataSeriesCondition(AttrLabel.class, (Result)dataPoint, null);
        TextAttr textAttr = attrLabel.getTextAttr();
        if (!attrLabel.isCustom()) {
            textAttr.setFRFont(VanChartAttrHelper.DEFAULT_LABEL_FONT);
        }
        return GlyphUtils.calculateTextDimensionWithNoRotation((String)dataPoint.getDataLabel().getText(), (TextAttr)textAttr, (int)n);
    }

    private boolean isSmallerThan(PointAndAngle pointAndAngle, PointAndAngle pointAndAngle2) {
        return this.getExtend(pointAndAngle.pieDataPoint) < this.getExtend(pointAndAngle2.pieDataPoint);
    }

    private double getExtend(DataPoint dataPoint) {
        return this.getPercent(dataPoint.getSeriesIndex(), dataPoint.getCategoryIndex()) * this.getWholeAngle();
    }

    private void dealInsideLabelBounds(DataPoint dataPoint, int n) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n2 = dataPoint.getSeriesIndex();
        int n3 = dataPoint.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n3);
        double d = this.getLabelDim(dataPoint, n).getHeight();
        double d2 = this.getLabelDim(dataPoint, n).getWidth();
        double d3 = 0.5;
        double d4 = this.getOuterRadius(this.radius, n3, dataPoint);
        double d5 = this.getInnerRadius();
        TextGlyph textGlyph = dataPoint.getDataLabel();
        double d6 = this.getSeriesStartAngle(n3, n2) % 360.0;
        double d7 = this.getHalfAngle(d6, n2, n3) % 360.0;
        double d8 = (d4 - d5) * Math.cos(Math.PI * d7 / 180.0);
        double d9 = (d4 - d5) * Math.sin(Math.PI * d7 / 180.0);
        double d10 = point2D.getX() + d5 * Math.cos(Math.PI * d7 / 180.0);
        double d11 = point2D.getY() - d5 * Math.sin(Math.PI * d7 / 180.0);
        double d12 = d10 + d8 * d3;
        double d13 = d11 - d9 * d3;
        double d14 = d12 - d2 / 2.0;
        double d15 = d13 - d / 2.0;
        ((Rectangle2D)double_).setRect(d14, d15, d2, d);
        textGlyph.setBounds((RectangularShape)double_);
    }

    private void getSeriesCountWithQuadrant(int n) {
        this.clearList();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            if (this.getSeries(i).getDataPoint(n).isValueIsNull() || !this.isOutsideLabel(i, n)) continue;
            DataSeries dataSeries = this.getSeries(i);
            VanChartPieDataPoint vanChartPieDataPoint = (VanChartPieDataPoint)dataSeries.getDataPoint(n);
            double d = this.getHalfAngle(this.getSeriesStartAngle(n, i), i, n) % 360.0;
            DecimalFormat decimalFormat = new DecimalFormat("######0.00");
            if ((d = Double.valueOf(decimalFormat.format(d)).doubleValue()) >= 90.0 && d <= 180.0) {
                this.leftUp.add(new PointAndAngle(vanChartPieDataPoint, d));
                continue;
            }
            if (d > 180.0 && d <= 270.0) {
                this.leftDown.add(new PointAndAngle(vanChartPieDataPoint, d));
                continue;
            }
            if (d > 270.0 && d <= 360.0) {
                this.rightDown.add(new PointAndAngle(vanChartPieDataPoint, d));
                continue;
            }
            this.rightUp.add(new PointAndAngle(vanChartPieDataPoint, d));
        }
        this.sortList();
    }

    private void clearList() {
        this.leftUp.clear();
        this.leftDown.clear();
        this.rightUp.clear();
        this.rightDown.clear();
    }

    private void sortList() {
        this.bubbleSort(this.leftUp);
        this.bubbleSort(this.leftDown);
        this.bubbleSort(this.rightUp);
        this.bubbleSort(this.rightDown);
    }

    private void bubbleSort(ArrayList arrayList) {
        PointAndAngle[] pointAndAngleArray = arrayList.toArray(new PointAndAngle[0]);
        int n = pointAndAngleArray.length - 1;
        for (int i = 0; i < n; ++i) {
            PointAndAngle pointAndAngle;
            int n2;
            for (n2 = i; n2 < n; ++n2) {
                if (!(pointAndAngleArray[n2].centerAngle > pointAndAngleArray[n2 + 1].centerAngle)) continue;
                pointAndAngle = pointAndAngleArray[n2];
                pointAndAngleArray[n2] = pointAndAngleArray[n2 + 1];
                pointAndAngleArray[n2 + 1] = pointAndAngle;
            }
            for (n2 = --n; n2 > i; --n2) {
                if (!(pointAndAngleArray[n2].centerAngle < pointAndAngleArray[n2 - 1].centerAngle)) continue;
                pointAndAngle = pointAndAngleArray[n2];
                pointAndAngleArray[n2] = pointAndAngleArray[n2 - 1];
                pointAndAngleArray[n2 - 1] = pointAndAngle;
            }
        }
        arrayList.clear();
        for (PointAndAngle pointAndAngle : pointAndAngleArray) {
            arrayList.add(pointAndAngle);
        }
    }

    private void dealWithDataSeries(int n, int n2) {
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            VanChartPieDataPoint vanChartPieDataPoint = (VanChartPieDataPoint)dataSeries.getDataPoint(n);
            if (vanChartPieDataPoint.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(vanChartPieDataPoint);
            vanChartPieDataPoint.setDrawImpl((Glyph)shapeGlyph);
            if (this.getSubType() != 1) continue;
            this.dealPlotStyle(this.plotStyle, vanChartPieDataPoint);
        }
        this.dealWithCategoryLabels(n, n2);
    }

    private int getSubType() {
        return 1;
    }

    private boolean isExistOuterLabels() {
        return !this.leftUp.isEmpty() || !this.leftDown.isEmpty() || !this.rightUp.isEmpty() || !this.rightDown.isEmpty();
    }

    private void dealWithCategoryLabels(int n, int n2) {
        if (this.isExistOuterLabels()) {
            this.dealOutSideLabels(n, n2);
            this.dealLabelBoundsOverLay(this.leftUp, n2, 0, 90.0, 180.0, true);
            this.dealLabelBoundsOverLay(this.leftDown, n2, 0, 180.0, 270.0, true);
            this.dealLabelBoundsOverLay(this.rightUp, n2, 0, 0.0, 90.0, false);
            this.dealLabelBoundsOverLay(this.rightDown, n2, 0, 270.0, 360.0, false);
        }
        this.dealInsideLabels(n, n2);
    }

    private void dealInsideLabels(int n, int n2) {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            TextGlyph textGlyph;
            DataSeries dataSeries = this.getSeries(i);
            VanChartPieDataPoint vanChartPieDataPoint = (VanChartPieDataPoint)dataSeries.getDataPoint(n);
            if (vanChartPieDataPoint.isValueIsNull() || this.isOutsideLabel(i, n) || (textGlyph = vanChartPieDataPoint.getDataLabel()) == null || !StringUtils.isNotEmpty((String)textGlyph.getText())) continue;
            this.dealInsideLabelBounds(vanChartPieDataPoint, n2);
        }
    }

    private void dealOutSideLabels(int n, int n2) {
        double d = 0.0;
        d = Math.max(d, this.dealEachArea(this.leftUp, n2));
        d = Math.max(d, this.dealEachArea(this.leftDown, n2));
        d = Math.max(d, this.dealEachArea(this.rightUp, n2));
        if ((d = Math.max(d, this.dealEachArea(this.rightDown, n2))) == 0.0) {
            return;
        }
        this.radiusPercent -= 0.05;
        if (this.radiusPercent >= 0.5) {
            this.deal4EachCategory(n, n2);
        }
    }

    private double dealEachArea(ArrayList arrayList, int n) {
        double d = this.getBounds().getX() + this.getBounds().getWidth();
        double d2 = this.getBounds().getX();
        double d3 = 0.0;
        this.checkPointsShowLabel(arrayList, n);
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i);
            if (pointAndAngle.pieDataPoint.getDataLabel() == null) continue;
            this.dealOutsideLabelBoundsWhenNormal(double_, pointAndAngle, n);
            if (((RectangularShape)double_).getX() < d2) {
                d3 = d2 - ((RectangularShape)double_).getX();
            }
            if (!(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() > d)) continue;
            d3 = ((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() - d;
        }
        return d3;
    }

    private void dealOutsideLabelBoundsWhenNormal(Rectangle2D rectangle2D, PointAndAngle pointAndAngle, int n) {
        Point2D point2D = this.calculateLabelBoundsWithAngle(pointAndAngle.centerAngle, pointAndAngle, n, rectangle2D);
        pointAndAngle.pieDataPoint.getDataLabel().setBounds((RectangularShape)rectangle2D);
        if (this.isGuideLineShow(pointAndAngle.pieDataPoint)) {
            this.dealWidthLine(point2D, pointAndAngle);
        }
    }

    private Point2D calculateLabelBoundsWithAngle(double d, PointAndAngle pointAndAngle, int n, Rectangle2D rectangle2D) {
        int n2 = pointAndAngle.pieDataPoint.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n2);
        Dimension2D dimension2D = this.getLabelDim(pointAndAngle.pieDataPoint, n);
        double d2 = dimension2D.getHeight();
        double d3 = dimension2D.getWidth();
        double d4 = this.plotStyle != 1 ? this.radius * 1.2 : this.radius;
        double d5 = point2D.getX() + d4 * Math.cos(Math.PI * d / 180.0);
        double d6 = point2D.getY() - d4 * Math.sin(Math.PI * d / 180.0);
        double d7 = (this.plotStyle != 1 ? this.radius : this.radius / 1.2) * 0.1 + 2.0;
        if (pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0) {
            rectangle2D.setRect(d5 - d7 - d3, d6 - d2 / 2.0, d3, d2);
        } else {
            rectangle2D.setRect(d5 + d7, d6 - d2 / 2.0, d3, d2);
        }
        return point2D;
    }

    private void checkPointsShowLabel(ArrayList arrayList, int n) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i);
            TextGlyph textGlyph = pointAndAngle.pieDataPoint.getDataLabel();
            if (textGlyph == null || !StringUtils.isNotEmpty((String)textGlyph.getText())) continue;
            d += this.getLabelDim(pointAndAngle.pieDataPoint, n).getHeight();
        }
        if (d > this.radius) {
            this.removeAngleExtendMinPoint(arrayList);
            this.checkPointsShowLabel(arrayList, n);
        }
    }

    private void removeAngleExtendMinPoint(ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            PointAndAngle pointAndAngle2 = (PointAndAngle)arrayList.get(i);
            if (!this.isSmallerThan(pointAndAngle2, pointAndAngle)) continue;
            pointAndAngle = pointAndAngle2;
        }
        arrayList.remove(pointAndAngle);
    }

    private void dealLabelBoundsOverLay(ArrayList arrayList, int n, int n2, double d, double d2, boolean bl) {
        if (n2 >= 2) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        boolean bl2 = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            PointAndAngle pointAndAngle = (PointAndAngle)arrayList.get(i);
            if (pointAndAngle.pieDataPoint.getDataLabel() == null || StringUtils.isEmpty((String)pointAndAngle.pieDataPoint.getDataLabel().getText())) continue;
            Rectangle2D rectangle2D = pointAndAngle.pieDataPoint.getDataLabel().getBounds();
            if (generalPath.intersects(rectangle2D)) {
                if (this.adjustLabelBoundsY(generalPath, pointAndAngle, n, d, d2, bl)) continue;
                bl2 = false;
                break;
            }
            generalPath.append(rectangle2D, false);
        }
        if (bl2) {
            return;
        }
        this.dealLabelBoundsOverLay(arrayList, n, n2 + 1, d, d2, !bl);
    }

    private boolean adjustLabelBoundsY(GeneralPath generalPath, PointAndAngle pointAndAngle, int n, double d, double d2, boolean bl) {
        Rectangle2D rectangle2D = pointAndAngle.pieDataPoint.getDataLabel().getBounds();
        double d3 = pointAndAngle.centerAngle;
        while (generalPath.intersects(rectangle2D)) {
            d3 = bl ? (d3 += 1.0) : (d3 -= 1.0);
            this.calculateLabelBoundsWithAngle(d3, pointAndAngle, n, rectangle2D);
        }
        pointAndAngle.pieDataPoint.getDataLabel().setBounds((RectangularShape)rectangle2D);
        generalPath.append(rectangle2D, false);
        if (d3 < d || d3 > d2) {
            return false;
        }
        if (!this.isGuideLineShow(pointAndAngle.pieDataPoint)) {
            return true;
        }
        GeneralPath generalPath2 = new GeneralPath();
        double d4 = 0.0;
        double d5 = 0.0;
        d4 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? rectangle2D.getX() + rectangle2D.getWidth() + 2.0 : rectangle2D.getX() - 2.0;
        d5 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        generalPath2.moveTo(d4, d5);
        d4 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d4 += 0.1 * this.radius) : (d4 -= 0.1 * this.radius);
        generalPath2.lineTo(d4, d5);
        Point2D point2D = this.getCenterPoint(pointAndAngle.pieDataPoint.getCategoryIndex());
        double d6 = this.radius + 2.0;
        d4 = point2D.getX() + d6 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        d5 = point2D.getY() - d6 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath2.lineTo(d4, d5);
        pointAndAngle.pieDataPoint.setLeadLine(generalPath2);
        return true;
    }

    private double deal4BestRad(double d, int n) {
        AttrLabel attrLabel = (AttrLabel)this.getConditionCollection().getDataSeriesCondition(AttrLabel.class, (Result)this.getSeries(0).getDataPoint(n));
        if (attrLabel != null && attrLabel.getPosition() == 6) {
            d *= this.radiusPercent;
            if (this.getCategoryCount() > 1) {
                d *= 0.8;
            }
        }
        return d;
    }

    private void dealWidthLine(Point2D point2D, PointAndAngle pointAndAngle) {
        GeneralPath generalPath = new GeneralPath();
        double d = this.getOuterRadius(this.radius, pointAndAngle.pieDataPoint.getCategoryIndex(), pointAndAngle.pieDataPoint);
        double d2 = point2D.getX() + (d + 2.0) * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        double d3 = point2D.getY() - (d + 2.0) * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath.moveTo(d2, d3);
        double d4 = this.radius * 1.2;
        d2 = point2D.getX() + d4 * Math.cos(Math.PI * pointAndAngle.centerAngle / 180.0);
        d3 = point2D.getY() - d4 * Math.sin(Math.PI * pointAndAngle.centerAngle / 180.0);
        generalPath.lineTo(d2, d3);
        d2 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d2 -= this.radius * 0.1) : (d2 += this.radius * 0.1);
        generalPath.lineTo(d2, d3);
        pointAndAngle.pieDataPoint.setLeadLine(generalPath);
    }

    private void dealPlotStyle(int n, VanChartPieDataPoint vanChartPieDataPoint) {
        ShapeGlyph shapeGlyph = (ShapeGlyph)vanChartPieDataPoint.getDrawImpl();
        Shape shape = vanChartPieDataPoint.getShape();
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            double d = this.getInnerRadius();
            double d2 = this.getOuterRadius(this.radius, vanChartPieDataPoint.getCategoryIndex(), vanChartPieDataPoint);
            Point2D point2D = this.getCenterPoint(vanChartPieDataPoint.getCategoryIndex());
            RoseTopDownShadeStyle roseTopDownShadeStyle = null;
            if (n == 4) {
                roseTopDownShadeStyle = new RoseTopDownShadeStyle(d, d2, point2D, color, shape, true);
            }
            if (roseTopDownShadeStyle != null) {
                if (this.getAttrAlpha(vanChartPieDataPoint) != null) {
                    roseTopDownShadeStyle.setAlpha(shapeGlyph.getAlpha());
                }
                if (this.getAttrBorder(vanChartPieDataPoint) != null) {
                    roseTopDownShadeStyle.setBorderWidth(VanChartAttrHelper.getAxisLineStyle(shapeGlyph.getBorderStyle()));
                    roseTopDownShadeStyle.setBorderColor(shapeGlyph.getBorderColor() == null ? new Color(0, 0, 0, 0) : shapeGlyph.getBorderColor());
                }
                vanChartPieDataPoint.setDataPointStyle((ChartStyle)roseTopDownShadeStyle);
            }
        }
    }

    public boolean isExistAttrByResult(Result result, Class clazz) {
        return this.getConditionCollection() != null && this.getConditionCollection().getAttrByResult(result, clazz) != null;
    }

    public void calculateDataPointPercentValue() {
        int n = this.getSeriesSize();
        if (n > 0) {
            int n2 = this.getSeries(0).getDataPointCount();
            for (int i = 0; i < n2; ++i) {
                int n3;
                double d = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    d += Math.abs(this.getSeries(n3).getDataPoint(i).getValue());
                }
                for (n3 = 0; n3 < n; ++n3) {
                    DataPoint dataPoint = this.getSeries(n3).getDataPoint(i);
                    double d2 = Math.abs(dataPoint.getValue());
                    if (d == 0.0) continue;
                    dataPoint.setPercentValue(d2 / d);
                }
            }
        }
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        if (!ComparatorUtils.equals((Object)((Object)this.getRoseType()), (Object)((Object)ChartRoseType.PIE))) {
            jSONObject.put("roseType", (Object)this.getRoseType().getRoseType());
        }
        jSONObject.put("innerRadius", (Object)(this.getInnerRadiusPercent() + "%"));
        jSONObject.put("startAngle", this.getStartAngle());
        jSONObject.put("endAngle", this.getEndAngle());
        jSONObject.put("rotatable", this.isSupportRotation());
        return jSONObject;
    }

    public String getChartType() {
        return "pie";
    }

    @Override
    public void addNotNullSeriesJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        this.addSeriesJSONWithCate2Series(jSONObject, repository);
    }

    private class PointAndAngle {
        public double centerAngle;
        public VanChartPieDataPoint pieDataPoint;

        public PointAndAngle(VanChartPieDataPoint vanChartPieDataPoint, double d) {
            this.pieDataPoint = vanChartPieDataPoint;
            this.centerAngle = d;
        }
    }
}

