/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class VanChartAlertValueGlyph
extends ChartAlertValueGlyph {
    private static final long serialVersionUID = 202681693668095575L;
    private VanChartBaseAxisGlyph vanChartBaseAxisGlyph;

    public void setAxisGlyph(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        this.vanChartBaseAxisGlyph = vanChartBaseAxisGlyph;
    }

    public VanChartBaseAxisGlyph getAxisGlyph() {
        return this.vanChartBaseAxisGlyph;
    }

    public void dealWithAlertLine() {
        double d = this.getAlertValue();
        if (d <= this.vanChartBaseAxisGlyph.getMaxValue() && d >= this.vanChartBaseAxisGlyph.getMinValue()) {
            this.lines = this.vanChartBaseAxisGlyph.getGridLine(d);
        }
    }

    public double getAlertValue() {
        Object object = this.vanChartBaseAxisGlyph.getObjectFromFormula(this.getAlertValueFormula());
        double d = this.vanChartBaseAxisGlyph.getObjectValue(object);
        if (this.vanChartBaseAxisGlyph.isDrawBetweenTick()) {
            d += 0.5;
        }
        return d;
    }

    public void drawAlertValueLabel(Graphics graphics, int n) {
        TextAttr textAttr = new TextAttr();
        textAttr.setFRFont(this.getAlertFont());
        String string = this.getAlertContent();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)string, (TextAttr)textAttr, (int)n);
        for (Line2D line2D : this.lines) {
            double d = 0.0;
            double d2 = 0.0;
            switch (this.getAlertPosition()) {
                case 1: {
                    d = line2D.getX1() - dimension2D.getWidth();
                    d2 = Math.min(line2D.getY1(), line2D.getY2());
                    break;
                }
                case 3: {
                    d = line2D.getX1() - dimension2D.getWidth();
                    d2 = Math.max(line2D.getY1(), line2D.getY2()) - dimension2D.getHeight();
                    break;
                }
                case 2: {
                    d = Math.min(line2D.getX1(), line2D.getX2());
                    d2 = line2D.getY1() - dimension2D.getHeight();
                    break;
                }
                case 4: {
                    d = Math.max(line2D.getX1(), line2D.getX2()) - dimension2D.getWidth();
                    d2 = line2D.getY1() - dimension2D.getHeight();
                }
            }
            this.labelBounds = new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
        }
        GlyphUtils.drawStrings((Graphics)graphics, (String)string, (TextAttr)textAttr, (Rectangle2D)this.labelBounds, (int)n);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("color", (Object)StableUtils.javaColorToCSSColor((Color)this.getLineColor().getSeriesColor()));
        VanChartAttrHelper.addDashLineStyleJSON(jSONObject, this.getLineStyle().getLineStyle());
        if (this.getAlertValueFormula() != null && this.getAlertValueFormula().getResult() != null) {
            jSONObject.put("value", this.getAlertValueFormula().getResult());
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("align", (Object)ChartUtils.getPositionString((int)this.getAlertPosition()));
        jSONObject2.put("text", (Object)this.getAlertContent());
        jSONObject2.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.getAlertFont()));
        jSONObject.put("label", (Object)jSONObject2);
        return jSONObject;
    }
}

