/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.GraphHelper;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.FRFont;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GaugeGlyphHelper {
    private static final double HEIGHT_GAP = 0.5;
    public static final double WIDTH_GAP = 10.0;

    public static Dimension2D calculateTextDimension(String string, FRFont fRFont, int n) {
        String[] stringArray;
        if (StringUtils.isEmpty((String)string)) {
            return new Dimension(0, 0);
        }
        if (fRFont == null) {
            fRFont = FRFont.getInstance();
        }
        Font font = GlyphUtils.getFont4StringInSystem((Font)fRFont.applyResolutionNP(n), (String)string);
        double d = 0.0;
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)10, (int)10, (int)6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        String string2 = GlyphUtils.changeAllReline2Normal((String)string);
        for (String string3 : stringArray = string2.split(AttrContents.RelineSeparation)) {
            d = Math.max(d, GraphHelper.stringWidth((String)string3, (Font)font, (FontRenderContext)fontRenderContext));
        }
        double d2 = GaugeGlyphHelper.calculateOneLineHeight(fRFont);
        double d3 = d2 * (double)stringArray.length + d2 * 0.5 * (double)(stringArray.length - 1);
        return new DoubleDimension2D(d, d3);
    }

    public static double calculateOneLineHeight(FRFont fRFont) {
        FontMetrics fontMetrics = GraphHelper.getFontMetrics((Font)fRFont);
        return fontMetrics.getHeight();
    }

    public static void drawMultiLineText(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        String string2 = GlyphUtils.changeAllReline2Normal((String)string);
        String[] stringArray = string2.split(AttrContents.RelineSeparation);
        for (int i = 0; i < stringArray.length; ++i) {
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)stringArray[i], (TextAttr)textAttr, (int)n);
            double d = Math.max((rectangle2D.getWidth() - dimension2D.getWidth() - 2.0) / 2.0, 0.0);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d - 1.0, dimension2D.getHeight() * (double)i, dimension2D.getWidth() + 2.0, dimension2D.getHeight());
            GaugeGlyphHelper.drawStrings(graphics2D, stringArray[i], textAttr, double_, n);
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    public static void drawStrings(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D, int n) {
        double d = GaugeGlyphHelper.isNumeric(string) ? 0.0 : 10.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + d, rectangle2D.getHeight());
        GlyphUtils.drawStrings((Graphics)graphics, (String)string, (TextAttr)textAttr, (Rectangle2D)double_, (int)n);
    }

    private static boolean isNumeric(String string) {
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]+");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static String value2String(double d, Format format) {
        String string = format != null ? format.format(new Double(d)) : ChartBaseUtils.generalFormat((double)d);
        return string;
    }

    public static Color getColor(Color color) {
        return color == null ? new Color(255, 255, 255, 0) : color;
    }

    protected static void drawCircle(Graphics2D graphics2D, Point2D point2D, double d, Color color) {
        GaugeGlyphHelper.drawArc(graphics2D, point2D, d, 0.0, 360.0, color);
    }

    protected static void drawArc(Graphics2D graphics2D, Point2D point2D, double d, double d2, double d3, Color color) {
        GaugeGlyphHelper.drawArc(graphics2D, point2D, d, d2, d3, color, 2);
    }

    protected static void drawArc(Graphics2D graphics2D, Point2D point2D, double d, double d2, double d3, Color color, int n) {
        if (d <= 0.0) {
            return;
        }
        graphics2D.setColor(GaugeGlyphHelper.getColor(color));
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() - d, point2D.getY() - d, 2.0 * d, 2.0 * d, d2, d3, n);
        graphics2D.fill(double_);
    }

    protected static void drawCircleStroke(Graphics2D graphics2D, Point2D point2D, double d, double d2, Color color) {
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        graphics2D.setColor(color);
        GeneralPath generalPath = GaugeGlyphHelper.getArcPath(point2D, d, d2);
        graphics2D.fill(generalPath);
    }

    protected static void drawArcStroke(Graphics2D graphics2D, Point2D point2D, double d, double d2, double d3, double d4, Color color) {
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        graphics2D.setColor(color);
        GeneralPath generalPath = GaugeGlyphHelper.getArcPath(point2D, d, d2, d3, d4);
        graphics2D.fill(generalPath);
    }

    protected static void drawCircleShadeStroke(Graphics2D graphics2D, Point2D point2D, double d, double d2, Color color, Color color2) {
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        GeneralPath generalPath = GaugeGlyphHelper.getArcPath(point2D, d, d2);
        float[] fArray = new float[]{(float)(d / d2), 1.0f};
        Color[] colorArray = new Color[]{color2, color};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)point2D.getX(), (float)point2D.getY(), (float)d2, fArray, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setPaint(paint);
    }

    public static GeneralPath getArcPath(Point2D point2D, double d, double d2) {
        return GaugeGlyphHelper.getArcPath(point2D, d, d2, 0.0, 360.0);
    }

    public static GeneralPath getArcPath(Point2D point2D, double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        if (d <= 0.0 || d2 <= 0.0) {
            return generalPath;
        }
        Arc2D.Double double_ = new Arc2D.Double(point2D.getX() - d2, point2D.getY() - d2, 2.0 * d2, 2.0 * d2, d3, d4, 0);
        Arc2D.Double double_2 = new Arc2D.Double(point2D.getX() - d, point2D.getY() - d, 2.0 * d, 2.0 * d, d3 + d4, -d4, 0);
        generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
        generalPath.append(double_, true);
        generalPath.lineTo((float)double_2.getStartPoint().getX(), (float)double_2.getStartPoint().getY());
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    public static GeneralPath getDiamondPath(double d, double d2, double d3) {
        double[] dArray = new double[]{d - d3, d, d + d3, d};
        double[] dArray2 = new double[]{d2, d2 - d3, d2, d2 + d3};
        GeneralPath generalPath = new GeneralPath(1, dArray.length);
        generalPath.moveTo((float)dArray[dArray.length - 1], (float)dArray2[dArray.length - 1]);
        for (int i = 0; i < dArray.length; ++i) {
            generalPath.lineTo((float)dArray[i], (float)dArray2[i]);
        }
        return generalPath;
    }

    public static GeneralPath getTrianglePath(double d, double d2, double d3) {
        double[] dArray = new double[]{d - d3, d + d3, d};
        double[] dArray2 = new double[]{d2 + d3, d2 + d3, d2 - d3};
        GeneralPath generalPath = new GeneralPath(1, dArray.length);
        generalPath.moveTo((float)dArray[dArray.length - 1], (float)dArray2[dArray.length - 1]);
        for (int i = 0; i < dArray.length; ++i) {
            generalPath.lineTo((float)dArray[i], (float)dArray2[i]);
        }
        return generalPath;
    }
}

