/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.series;

import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.gui.frpane.UICorrelationComboBoxPane;
import com.fr.design.gui.frpane.UINumberDragPane;
import com.fr.design.gui.imenutable.UIMenuNameableCreator;
import com.fr.design.mainframe.chart.gui.ChartStylePane;
import com.fr.design.mainframe.chart.gui.style.series.AbstractPlotSeriesPane;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.plot.VanChartRectanglePlot;
import com.fr.plugin.chart.base.AttrAreaSeriesFillColorBackground;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.base.VanChartAttrTrendLine;
import com.fr.plugin.chart.column.VanChartCustomStackAndAxisConditionPane;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartAreaSeriesFillColorPane;
import com.fr.plugin.chart.designer.component.VanChartBeautyPane;
import com.fr.plugin.chart.designer.component.VanChartLineTypePane;
import com.fr.plugin.chart.designer.component.VanChartMarkerPane;
import com.fr.plugin.chart.designer.component.VanChartTrendLinePane;
import com.fr.plugin.chart.designer.component.VanChartUIMenuNameableCreator;
import com.fr.plugin.chart.designer.component.border.VanChartBorderPane;
import com.fr.stable.FCloneable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class VanChartAbstractPlotSeriesPane
extends AbstractPlotSeriesPane {
    private static final long serialVersionUID = -3909265296019479690L;
    private VanChartBeautyPane stylePane;
    private VanChartTrendLinePane trendLinePane;
    private VanChartLineTypePane lineTypePane;
    protected VanChartMarkerPane markerPane;
    private VanChartAreaSeriesFillColorPane areaSeriesFillColorPane;
    private VanChartBorderPane borderPane;
    private UINumberDragPane transparent;
    private UICorrelationComboBoxPane stackAndAxisPane;
    private JPanel stackAndAxisWholePane;
    protected JSeparator jSeparator;
    protected JPanel contentPane;

    public VanChartAbstractPlotSeriesPane(ChartStylePane chartStylePane, Plot plot) {
        super(chartStylePane, plot);
    }

    protected VanChartBeautyPane createStylePane() {
        this.stylePane = new VanChartBeautyPane();
        return this.stylePane;
    }

    protected JPanel createTrendLinePane() {
        this.trendLinePane = new VanChartTrendLinePane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Trend_Line"), (Component)((Object)this.trendLinePane));
    }

    protected JPanel createLineTypePane() {
        this.lineTypePane = this.getLineTypePane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Line"), (Component)((Object)this.lineTypePane));
    }

    protected VanChartLineTypePane getLineTypePane() {
        return new VanChartLineTypePane();
    }

    protected JPanel createMarkerPane() {
        this.markerPane = new VanChartMarkerPane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Marker"), (Component)((Object)this.markerPane));
    }

    protected JPanel createAreaFillColorPane() {
        this.areaSeriesFillColorPane = new VanChartAreaSeriesFillColorPane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_FillColor"), (Component)((Object)this.areaSeriesFillColorPane));
    }

    protected VanChartBorderPane createBorderPane() {
        this.borderPane = this.createDiffBorderPane();
        return this.borderPane;
    }

    protected VanChartBorderPane createDiffBorderPane() {
        return new VanChartBorderPane();
    }

    protected JPanel createAlphaPane() {
        this.transparent = new UINumberDragPane(0.0, 100.0);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Alpha"), (Component)this.transparent);
    }

    protected JPanel createStackedAndAxisPane() {
        this.stackAndAxisPane = new UICorrelationComboBoxPane();
        this.stackAndAxisWholePane = TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_StackAndSeries"), (Component)this.stackAndAxisPane);
        return this.stackAndAxisWholePane;
    }

    protected void removeStackWholePane() {
        this.contentPane.remove(this.stackAndAxisWholePane);
        this.contentPane.remove(this.jSeparator);
        this.contentPane.repaint();
    }

    public void populateBean(Plot plot) {
        if (plot == null) {
            return;
        }
        super.populateBean(plot);
        if (this.stylePane != null) {
            this.stylePane.populateBean(plot.getPlotStyle());
        }
        if (this.stackAndAxisPane != null && plot instanceof VanChartRectanglePlot) {
            VanChartRectanglePlot vanChartRectanglePlot = (VanChartRectanglePlot)plot;
            if (vanChartRectanglePlot.isCustomChart()) {
                this.populateStackAndAxis(vanChartRectanglePlot);
            } else {
                this.removeStackWholePane();
            }
        }
        this.populateCondition(plot.getConditionCollection().getDefaultAttr());
    }

    public void updateBean(Plot plot) {
        VanChartRectanglePlot vanChartRectanglePlot;
        if (plot == null) {
            return;
        }
        super.updateBean(plot);
        if (this.stylePane != null) {
            plot.setPlotStyle(this.stylePane.updateBean().intValue());
        }
        if (this.stackAndAxisPane != null && plot instanceof VanChartRectanglePlot && (vanChartRectanglePlot = (VanChartRectanglePlot)plot).isCustomChart()) {
            this.updateStackAndAxis(vanChartRectanglePlot);
        }
        this.updateCondition(plot.getConditionCollection().getDefaultAttr());
    }

    private void populateStackAndAxis(VanChartRectanglePlot vanChartRectanglePlot) {
        List<VanChartAxis> list = vanChartRectanglePlot.getXAxisList();
        List<VanChartAxis> list2 = vanChartRectanglePlot.getYAxisList();
        String[] stringArray = VanChartAttrHelper.getAxisNames(list);
        String[] stringArray2 = VanChartAttrHelper.getAxisNames(list2);
        ArrayList<VanChartUIMenuNameableCreator> arrayList = new ArrayList<VanChartUIMenuNameableCreator>();
        ConditionAttr conditionAttr = new ConditionAttr();
        AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
        attrSeriesStackAndAxis.setXAxisNamesArray(stringArray);
        attrSeriesStackAndAxis.setYAxisNameArray(stringArray2);
        conditionAttr.addDataSeriesCondition((DataSeriesCondition)attrSeriesStackAndAxis);
        arrayList.add(new VanChartUIMenuNameableCreator(Inter.getLocText((String)"Plugin-ChartF_StackAndSeries"), (FCloneable)conditionAttr, this.getStackAndAxisPaneClass()));
        this.stackAndAxisPane.refreshMenuAndAddMenuAction(arrayList);
        ArrayList<VanChartUIMenuNameableCreator> arrayList2 = new ArrayList<VanChartUIMenuNameableCreator>();
        ConditionCollection conditionCollection = vanChartRectanglePlot.getStackAndAxisCondition();
        int n = conditionCollection.getConditionAttrSize();
        for (int i = 0; i < n; ++i) {
            ConditionAttr conditionAttr2 = conditionCollection.getConditionAttr(i);
            AttrSeriesStackAndAxis attrSeriesStackAndAxis2 = (AttrSeriesStackAndAxis)conditionAttr2.getExisted(AttrSeriesStackAndAxis.class);
            attrSeriesStackAndAxis2.setXAxisNamesArray(stringArray);
            attrSeriesStackAndAxis2.setYAxisNameArray(stringArray2);
            arrayList2.add(new VanChartUIMenuNameableCreator(conditionAttr2.getName(), (FCloneable)conditionAttr2, this.getStackAndAxisPaneClass()));
        }
        this.stackAndAxisPane.populateBean(arrayList2);
        this.stackAndAxisPane.doLayout();
    }

    protected Class<? extends BasicBeanPane> getStackAndAxisPaneClass() {
        return VanChartCustomStackAndAxisConditionPane.class;
    }

    private void updateStackAndAxis(VanChartRectanglePlot vanChartRectanglePlot) {
        ConditionCollection conditionCollection = vanChartRectanglePlot.getStackAndAxisCondition();
        conditionCollection.clearConditionAttr();
        List list = this.stackAndAxisPane.updateBean();
        for (UIMenuNameableCreator uIMenuNameableCreator : list) {
            ConditionAttr conditionAttr = (ConditionAttr)uIMenuNameableCreator.getObj();
            conditionAttr.setName(uIMenuNameableCreator.getName());
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = (AttrSeriesStackAndAxis)conditionAttr.getExisted(AttrSeriesStackAndAxis.class);
            attrSeriesStackAndAxis.setStackID(uIMenuNameableCreator.getName());
            conditionCollection.addConditionAttr(conditionAttr);
        }
    }

    protected void populateCondition(ConditionAttr conditionAttr) {
        DataSeriesCondition dataSeriesCondition;
        if (this.trendLinePane != null) {
            dataSeriesCondition = (VanChartAttrTrendLine)conditionAttr.getExisted(VanChartAttrTrendLine.class);
            this.trendLinePane.populate((VanChartAttrTrendLine)dataSeriesCondition);
        }
        if (this.lineTypePane != null) {
            dataSeriesCondition = (VanChartAttrLine)conditionAttr.getExisted(VanChartAttrLine.class);
            this.lineTypePane.populate((VanChartAttrLine)dataSeriesCondition);
        }
        if (this.markerPane != null) {
            dataSeriesCondition = (VanChartAttrMarker)conditionAttr.getExisted(VanChartAttrMarker.class);
            this.markerPane.populate((VanChartAttrMarker)dataSeriesCondition);
        }
        if (this.areaSeriesFillColorPane != null) {
            dataSeriesCondition = (AttrAreaSeriesFillColorBackground)conditionAttr.getExisted(AttrAreaSeriesFillColorBackground.class);
            this.areaSeriesFillColorPane.populate((AttrAreaSeriesFillColorBackground)dataSeriesCondition);
        }
        if (this.borderPane != null && (dataSeriesCondition = (AttrBorder)conditionAttr.getExisted(AttrBorder.class)) != null) {
            this.borderPane.populate((AttrBorder)dataSeriesCondition);
        }
        if (this.transparent != null) {
            dataSeriesCondition = (AttrAlpha)conditionAttr.getExisted(AttrAlpha.class);
            if (dataSeriesCondition != null) {
                this.transparent.populateBean(Double.valueOf((double)dataSeriesCondition.getAlpha() * 100.0));
            } else {
                this.transparent.populateBean(Double.valueOf(100.0));
            }
        }
    }

    protected void updateCondition(ConditionAttr conditionAttr) {
        DataSeriesCondition dataSeriesCondition;
        DataSeriesCondition dataSeriesCondition2;
        if (this.trendLinePane != null) {
            dataSeriesCondition2 = this.trendLinePane.update();
            dataSeriesCondition = (VanChartAttrTrendLine)conditionAttr.getExisted(VanChartAttrTrendLine.class);
            conditionAttr.remove(dataSeriesCondition);
            conditionAttr.addDataSeriesCondition(dataSeriesCondition2);
        }
        if (this.lineTypePane != null) {
            dataSeriesCondition2 = (VanChartAttrLine)conditionAttr.getExisted(VanChartAttrLine.class);
            conditionAttr.remove(dataSeriesCondition2);
            conditionAttr.addDataSeriesCondition((DataSeriesCondition)this.lineTypePane.update());
        }
        if (this.markerPane != null) {
            dataSeriesCondition2 = this.markerPane.update();
            dataSeriesCondition = (VanChartAttrMarker)conditionAttr.getExisted(VanChartAttrMarker.class);
            conditionAttr.remove(dataSeriesCondition);
            conditionAttr.addDataSeriesCondition(dataSeriesCondition2);
        }
        if (this.areaSeriesFillColorPane != null) {
            dataSeriesCondition2 = this.areaSeriesFillColorPane.update();
            dataSeriesCondition = (AttrAreaSeriesFillColorBackground)conditionAttr.getExisted(AttrAreaSeriesFillColorBackground.class);
            if (dataSeriesCondition != null) {
                conditionAttr.remove(dataSeriesCondition);
            }
            conditionAttr.addDataSeriesCondition(dataSeriesCondition2);
        }
        if (this.borderPane != null) {
            dataSeriesCondition2 = (AttrBorder)conditionAttr.getExisted(AttrBorder.class);
            if (dataSeriesCondition2 == null) {
                dataSeriesCondition2 = new AttrBorder();
                conditionAttr.addDataSeriesCondition(dataSeriesCondition2);
            }
            this.borderPane.update((AttrBorder)dataSeriesCondition2);
        }
        if (this.transparent != null) {
            dataSeriesCondition2 = (AttrAlpha)conditionAttr.getExisted(AttrAlpha.class);
            if (dataSeriesCondition2 == null) {
                dataSeriesCondition2 = new AttrAlpha();
                conditionAttr.addDataSeriesCondition(dataSeriesCondition2);
            }
            dataSeriesCondition2.setAlpha((float)(this.transparent.updateBean() / 100.0));
        }
    }
}

