/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.axis;

import com.fr.base.BaseUtils;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartattr.Title;
import com.fr.design.beans.FurtherBasicBeanPane;
import com.fr.design.formula.TinyFormulaPane;
import com.fr.design.gui.frpane.UINumberDragPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.icombobox.LineComboBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.gui.itextfield.UITextField;
import com.fr.design.gui.style.FormatPane;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.PaneTitleConstants;
import com.fr.design.mainframe.chart.gui.style.ChartTextAttrPane;
import com.fr.design.style.color.ColorSelectBox;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.AxisTickLineType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartHtmlLabelPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.stable.CoreConstants;
import com.fr.stable.StableUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartBaseAxisPane
extends FurtherBasicBeanPane<VanChartAxis> {
    private static final long serialVersionUID = -5717246802333308973L;
    private static final double ROTATION_MAX = 90.0;
    protected TinyFormulaPane titleContent;
    protected UIButtonGroup<Integer> titleAlignPane;
    protected UIToggleButton titleUseHtml;
    protected ChartTextAttrPane titleTextAttrPane;
    protected UINumberDragPane titleTextRotation;
    protected UIButtonGroup showLabel;
    protected ChartTextAttrPane labelTextAttrPane;
    protected UINumberDragPane labelTextRotation;
    protected UIButtonGroup<Integer> labelGapStyle;
    protected UITextField labelGapValue;
    protected LineComboBox axisLineStyle;
    protected ColorSelectBox axisLineColor;
    protected UIButtonGroup<AxisTickLineType> mainTick;
    protected UIButtonGroup<AxisTickLineType> secondTick;
    protected UIButtonGroup<Integer> position;
    protected UIToggleButton reversed;
    protected UIButtonGroup<Integer> axisLimitSize;
    protected UISpinner maxProportion;
    protected UIButtonGroup valueFormatStyle;
    protected FormatPane valueFormat;
    protected JPanel centerPane;
    private VanChartHtmlLabelPane htmlLabelPane;
    private VanChartStylePane parent;

    public VanChartBaseAxisPane() {
        this(true);
    }

    public VanChartBaseAxisPane(boolean bl) {
        this.setLayout(new BorderLayout());
        this.add(this.createContentPane(bl), "Center");
    }

    public void setParent(VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
    }

    protected void reLayoutPane(boolean bl) {
        this.removeAll();
        this.add(this.createContentPane(bl), "Center");
    }

    protected JPanel createContentPane(boolean bl) {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{new JSeparator(), null}, {this.createTitlePane(new double[]{d, d, d, d, d}, dArray, bl), null}, {new JSeparator(), null}, {this.createLabelPane(new double[]{d, d, d}, dArray), null}, {new JSeparator(), null}, {this.createLineStylePane(new double[]{d, d, d, d}, dArray), null}, {new JSeparator(), null}, {this.createAxisPositionPane(new double[]{d, d}, dArray, bl), null}, {new JSeparator(), null}, {this.createDisplayStrategy(new double[]{d, d}, dArray), null}, {new JSeparator(), null}, {this.createValueStylePane(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    protected JPanel createTitlePane(double[] dArray, double[] dArray2, boolean bl) {
        this.titleAlignPane = bl ? this.getXAxisTitleAlignPane() : this.getYAxisTitleAlignPane();
        this.titleAlignPane.setSelectedItem((Object)0);
        this.titleContent = new TinyFormulaPane();
        this.titleUseHtml = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_Html"));
        this.titleTextAttrPane = new ChartTextAttrPane();
        this.titleTextRotation = new UINumberDragPane(-90.0, 90.0);
        if (bl) {
            this.titleTextRotation.populateBean(Double.valueOf(0.0));
        } else {
            this.titleTextRotation.populateBean(Double.valueOf(-90.0));
        }
        Component[][] componentArray = new Component[][]{{this.titleContent, null}, {this.titleAlignPane, null}, {this.titleUseHtml, null}, {this.titleTextAttrPane, null}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_TextRotation")), this.titleTextRotation}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(PaneTitleConstants.CHART_STYLE_TITLE_TITLE, jPanel);
    }

    private UIButtonGroup<Integer> getXAxisTitleAlignPane() {
        Icon[] iconArray = new Icon[]{BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/h_left_normal.png"), BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/h_center_normal.png"), BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/h_right_normal.png")};
        Object[] objectArray = new Integer[]{2, 0, 4};
        return new UIButtonGroup(iconArray, objectArray);
    }

    private UIButtonGroup<Integer> getYAxisTitleAlignPane() {
        Icon[] iconArray = new Icon[]{BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/v_top_normal.png"), BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/v_center_normal.png"), BaseUtils.readIcon((String)"/com/fr/design/images/m_format/cellstyle/v_down_normal.png")};
        Object[] objectArray = new Integer[]{1, 0, 3};
        return new UIButtonGroup(iconArray, objectArray);
    }

    protected JPanel createLabelPane(double[] dArray, double[] dArray2) {
        this.showLabel = new UIButtonGroup(new String[]{Inter.getLocText((String)"Chart-Use_Show"), Inter.getLocText((String)"Plugin-ChartF_Hidden")});
        this.labelTextAttrPane = new ChartTextAttrPane();
        this.labelTextRotation = new UINumberDragPane(-90.0, 90.0);
        this.labelGapStyle = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Automatic"), Inter.getLocText((String)"Plugin-ChartF_Fixed")});
        this.labelGapValue = new UITextField();
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_TextRotation")), this.labelTextRotation}, {new UILabel(Inter.getLocText((String)"ChartF-Label_Interval")), this.labelGapStyle}, {new UILabel(Inter.getLocText((String)"FR-Chart-Axis_labelInterval")), this.labelGapValue}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        Component[][] componentArray2 = new Component[][]{{this.showLabel, null}, {this.labelTextAttrPane, null}, {jPanel, null}};
        JPanel jPanel2 = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray2, (double[])dArray, (double[])dArray2);
        this.showLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartBaseAxisPane.this.checkLabelPane();
            }
        });
        this.labelGapStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartBaseAxisPane.this.checkLabelGapValuePane();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(PaneTitleConstants.CHART_STYLE_LABEL_TITLE, jPanel2);
    }

    protected JPanel createLineStylePane(double[] dArray, double[] dArray2) {
        this.axisLineStyle = new LineComboBox(CoreConstants.LINE_STYLE_ARRAY_4_AXIS);
        this.axisLineColor = new ColorSelectBox(100);
        String[] stringArray = new String[]{Inter.getLocText((String)"Plugin-ChartF_Open"), Inter.getLocText((String)"Plugin-ChartF_Close")};
        AxisTickLineType[] axisTickLineTypeArray = new AxisTickLineType[]{AxisTickLineType.TICK_LINE_OUTSIDE, AxisTickLineType.TICK_LINE_NONE};
        this.mainTick = new UIButtonGroup(stringArray, (Object[])axisTickLineTypeArray);
        this.secondTick = new UIButtonGroup(stringArray, (Object[])axisTickLineTypeArray);
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])this.getLineStylePaneComponents(), (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_AxisLineStyle"), jPanel);
    }

    protected Component[][] getLineStylePaneComponents() {
        return new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_type")), this.axisLineStyle}, {new UILabel(Inter.getLocText((String)"FR-Chart-Color_Color")), this.axisLineColor}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_MainGraduationLine")), this.mainTick}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_SecondGraduationLine")), this.secondTick}};
    }

    protected JPanel createAxisPositionPane(double[] dArray, double[] dArray2, boolean bl) {
        this.position = new UIButtonGroup(this.getAxisPositionNameArray(bl), (Object[])this.getAxisPositionValueArray(bl));
        this.reversed = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_OpenAxisReversed"));
        Component[][] componentArray = new Component[][]{{this.position, null}, {this.reversed, null}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Layout_Position"), jPanel);
    }

    private String[] getAxisPositionNameArray(boolean bl) {
        if (bl) {
            return new String[]{Inter.getLocText((String)"Plugin-ChartF_AxisTop"), Inter.getLocText((String)"Plugin-ChartF_AxisBottom"), Inter.getLocText((String)"Plugin-ChartF_AxisVerticalZero")};
        }
        return new String[]{Inter.getLocText((String)"Chart-Layout_Left"), Inter.getLocText((String)"Chart-Layout_Right"), Inter.getLocText((String)"Plugin-ChartF_AxisVerticalZero")};
    }

    private Integer[] getAxisPositionValueArray(boolean bl) {
        if (bl) {
            return new Integer[]{1, 3, 5};
        }
        return new Integer[]{2, 4, 5};
    }

    protected JPanel createDisplayStrategy(double[] dArray, double[] dArray2) {
        this.maxProportion = new UISpinner(0.0, 100.0, 1.0, 30.0);
        this.axisLimitSize = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_LimitAreaSize"), Inter.getLocText((String)"Plugin-ChartF_NotLimitAreaSize")});
        Component[][] componentArray = new Component[][]{{this.axisLimitSize, null}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_AxisProportion") + ":"), this.maxProportion}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        this.axisLimitSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartBaseAxisPane.this.checkMaxProPortionUse();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_DisplayStrategy"), jPanel);
    }

    protected JPanel createValueStylePane() {
        this.valueFormatStyle = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Common"), Inter.getLocText((String)"Plugin-ChartF_Custom")});
        this.valueFormat = new FormatPane();
        this.checkFormatType();
        this.htmlLabelPane = new VanChartHtmlLabelPane();
        this.centerPane = new JPanel(new CardLayout());
        this.centerPane.add((Component)this.valueFormat, Inter.getLocText((String)"Plugin-ChartF_Common"));
        this.centerPane.add((Component)this.htmlLabelPane, Inter.getLocText((String)"Plugin-ChartF_Custom"));
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)this.valueFormatStyle, "North");
        jPanel.add((Component)this.centerPane, "Center");
        this.valueFormatStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartBaseAxisPane.this.checkCardPane();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Use_Format"), jPanel);
    }

    protected void checkFormatType() {
    }

    protected void checkAllUse() {
        this.checkCardPane();
        this.checkLabelPane();
        this.checkMaxProPortionUse();
    }

    protected void checkCardPane() {
        if (this.centerPane != null && this.valueFormatStyle != null) {
            CardLayout cardLayout = (CardLayout)this.centerPane.getLayout();
            if (this.valueFormatStyle.getSelectedIndex() == 1) {
                cardLayout.show(this.centerPane, Inter.getLocText((String)"Plugin-ChartF_Custom"));
            } else {
                cardLayout.show(this.centerPane, Inter.getLocText((String)"Plugin-ChartF_Common"));
            }
        }
    }

    protected void checkLabelPane() {
        if (this.showLabel != null) {
            boolean bl;
            boolean bl2 = bl = this.showLabel.getSelectedIndex() == 0;
            if (this.labelTextAttrPane != null) {
                this.labelTextAttrPane.setEnabled(bl);
            }
            if (this.labelTextRotation != null) {
                this.labelTextRotation.setEnabled(bl);
            }
            if (this.labelGapValue != null) {
                this.labelGapValue.setEnabled(bl);
            }
            if (this.labelGapStyle != null) {
                this.labelGapStyle.setEnabled(bl);
            }
            if (bl) {
                this.checkLabelGapValuePane();
            }
        }
    }

    private void checkLabelGapValuePane() {
        if (this.labelGapValue != null && this.labelGapStyle != null) {
            this.labelGapValue.setEnabled(this.labelGapStyle.getSelectedIndex() == 1);
        }
    }

    private void checkMaxProPortionUse() {
        if (this.maxProportion != null && this.axisLimitSize != null) {
            this.maxProportion.setEnabled(this.axisLimitSize.getSelectedIndex() == 0 && this.axisLimitSize.isEnabled());
        }
    }

    public boolean accept(Object object) {
        return false;
    }

    public String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-ChartF_CategoryAxis");
    }

    public void reset() {
    }

    public void populateBean(VanChartAxis vanChartAxis) {
        if (this.parent != null) {
            this.reLayoutPane(VanChartAttrHelper.isXAxis(vanChartAxis.getAxisName()));
            this.parent.initAllListeners();
        }
        this.populateTitle(vanChartAxis);
        this.populateLabel(vanChartAxis);
        this.populateLineStyle(vanChartAxis);
        this.populatePosition(vanChartAxis);
        this.populateDisplayStrategy(vanChartAxis);
        this.populateFormat(vanChartAxis);
        this.checkAllUse();
    }

    private void populateTitle(VanChartAxis vanChartAxis) {
        Title title = vanChartAxis.getTitle();
        if (title != null) {
            if (title.getTextObject() instanceof Formula && this.titleContent != null) {
                this.titleContent.populateBean(((Formula)title.getTextObject()).getContent());
            } else if (this.titleContent != null) {
                this.titleContent.populateBean(Utils.objectToString((Object)title.getTextObject()));
            }
            if (this.titleAlignPane != null) {
                this.titleAlignPane.setSelectedItem((Object)title.getPosition());
            }
            if (this.titleTextAttrPane != null) {
                this.titleTextAttrPane.populate(title.getTextAttr());
            }
            if (this.titleUseHtml != null) {
                this.titleUseHtml.setSelected(vanChartAxis.isTitleUseHtml());
            }
            if (this.titleTextRotation != null) {
                this.titleTextRotation.populateBean(Double.valueOf(title.getTextAttr().getRotation()));
            }
        }
    }

    private void populateLabel(VanChartAxis vanChartAxis) {
        if (this.showLabel != null) {
            this.showLabel.setSelectedIndex(vanChartAxis.isShowAxisLabel() ? 0 : 1);
        }
        TextAttr textAttr = vanChartAxis.getTextAttr();
        if (this.labelTextAttrPane != null) {
            this.labelTextAttrPane.populate(textAttr);
        }
        if (this.labelTextRotation != null) {
            this.labelTextRotation.populateBean(Double.valueOf(textAttr.getRotation()));
        }
        if (this.labelGapStyle != null) {
            this.labelGapStyle.setSelectedIndex(vanChartAxis.isAutoLabelGap() ? 0 : 1);
        }
        if (this.labelGapValue != null) {
            this.labelGapValue.setText(vanChartAxis.getLabelNumber().getContent());
        }
    }

    private void populateLineStyle(VanChartAxis vanChartAxis) {
        if (this.axisLineStyle != null) {
            this.axisLineStyle.setSelectedLineStyle(vanChartAxis.getAxisStyle());
        }
        if (this.axisLineColor != null) {
            this.axisLineColor.setSelectObject(vanChartAxis.getAxisColor());
        }
        if (this.mainTick != null) {
            this.mainTick.setSelectedItem((Object)vanChartAxis.getMainTickLine());
        }
        if (this.secondTick != null) {
            this.secondTick.setSelectedItem((Object)vanChartAxis.getSecTickLine());
        }
    }

    private void populatePosition(VanChartAxis vanChartAxis) {
        if (this.position != null) {
            this.position.setSelectedItem((Object)vanChartAxis.getPosition());
            if (this.position.getSelectedItem() == null) {
                this.position.setSelectedIndex(1);
            }
        }
        if (this.reversed != null) {
            this.reversed.setSelected(vanChartAxis.hasAxisReversed());
        }
    }

    private void populateDisplayStrategy(VanChartAxis vanChartAxis) {
        if (this.axisLimitSize != null) {
            this.axisLimitSize.setSelectedIndex(vanChartAxis.isLimitSize() ? 0 : 1);
        }
        if (this.maxProportion != null) {
            this.maxProportion.setValue(vanChartAxis.getMaxHeight());
        }
    }

    protected void populateFormat(VanChartAxis vanChartAxis) {
        if (this.valueFormatStyle != null) {
            this.valueFormatStyle.setSelectedIndex(vanChartAxis.isCommonValueFormat() ? 0 : 1);
        }
        if (this.valueFormat != null) {
            this.valueFormat.populateBean(vanChartAxis.getFormat());
        }
        if (this.htmlLabelPane != null) {
            this.htmlLabelPane.populate(vanChartAxis.getHtmlLabel());
        }
    }

    public void updateBean(VanChartAxis vanChartAxis) {
        this.updateTitle(vanChartAxis);
        this.updateLabel(vanChartAxis);
        this.updateLineStyle(vanChartAxis);
        this.updatePosition(vanChartAxis);
        this.updateDisplayStrategy(vanChartAxis);
        this.updateFormat(vanChartAxis);
    }

    private void updateTitle(VanChartAxis vanChartAxis) {
        String string;
        Title title = vanChartAxis.getTitle();
        if (title == null) {
            title = new Title();
            vanChartAxis.setTitle(title);
        }
        if (this.titleContent != null) {
            string = this.titleContent.updateBean();
            String string2 = StableUtils.maybeFormula((String)string) ? new Formula(string) : string;
            title.setTextObject((Object)string2);
        }
        if (this.titleAlignPane != null) {
            title.setPosition(((Integer)this.titleAlignPane.getSelectedItem()).intValue());
        }
        string = title.getTextAttr();
        if (this.titleTextAttrPane != null) {
            this.titleTextAttrPane.update((TextAttr)string);
        }
        if (this.titleUseHtml != null) {
            vanChartAxis.setTitleUseHtml(this.titleUseHtml.isSelected());
        }
        if (this.titleTextRotation != null) {
            string.setRotation(this.titleTextRotation.updateBean().intValue());
        }
    }

    private void updateLabel(VanChartAxis vanChartAxis) {
        if (this.showLabel != null) {
            vanChartAxis.setShowAxisLabel(this.showLabel.getSelectedIndex() == 0);
        }
        TextAttr textAttr = vanChartAxis.getTextAttr();
        if (this.labelTextAttrPane != null) {
            this.labelTextAttrPane.update(textAttr);
        }
        if (this.labelTextRotation != null) {
            textAttr.setRotation(this.labelTextRotation.updateBean().intValue());
        }
        if (this.labelGapStyle != null) {
            vanChartAxis.setAutoLabelGap(this.labelGapStyle.getSelectedIndex() == 0);
        }
        if (this.labelGapValue != null) {
            if (!vanChartAxis.isAutoLabelGap()) {
                vanChartAxis.setLabelIntervalNumber(new Formula(this.labelGapValue.getText()));
            } else {
                vanChartAxis.setLabelIntervalNumber(new Formula("0"));
            }
        }
    }

    private void updateLineStyle(VanChartAxis vanChartAxis) {
        if (this.axisLineStyle != null) {
            vanChartAxis.setAxisStyle(this.axisLineStyle.getSelectedLineStyle());
        }
        if (this.axisLineColor != null) {
            vanChartAxis.setAxisColor(this.axisLineColor.getSelectObject());
        }
        if (this.mainTick != null) {
            vanChartAxis.setMainTickLine((AxisTickLineType)((Object)this.mainTick.getSelectedItem()));
        }
        if (this.secondTick != null) {
            vanChartAxis.setSecTickLine((AxisTickLineType)((Object)this.secondTick.getSelectedItem()));
        }
    }

    private void updatePosition(VanChartAxis vanChartAxis) {
        if (this.position != null) {
            vanChartAxis.setPosition((Integer)this.position.getSelectedItem());
        }
        if (this.reversed != null) {
            vanChartAxis.setAxisReversed(this.reversed.isSelected());
        }
    }

    private void updateDisplayStrategy(VanChartAxis vanChartAxis) {
        if (this.axisLimitSize != null) {
            vanChartAxis.setLimitSize(this.axisLimitSize.getSelectedIndex() == 0);
        }
        if (this.maxProportion != null) {
            vanChartAxis.setMaxHeight(this.maxProportion.getValue());
        }
    }

    protected void updateFormat(VanChartAxis vanChartAxis) {
        if (this.valueFormatStyle != null) {
            vanChartAxis.setCommonValueFormat(this.valueFormatStyle.getSelectedIndex() == 0);
        }
        if (this.valueFormat != null) {
            vanChartAxis.setFormat(this.valueFormat.update());
        }
        if (this.htmlLabelPane != null) {
            this.htmlLabelPane.update(vanChartAxis.getHtmlLabel());
        }
    }

    public VanChartAxis updateBean(String string, int n) {
        VanChartAxis vanChartAxis = new VanChartAxis(string, n);
        this.updateBean(vanChartAxis);
        return vanChartAxis;
    }

    public VanChartAxis updateBean() {
        return null;
    }
}

