/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl;

import java.util.HashMap;
import java.util.Map;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartReplayLogEventHandler
implements SimulationEventHandler {
    private static Logger log = LoggerFactory.getLogger((String)StartReplayLogEventHandler.class.getName());
    public static final String PROCESS_INSTANCE_ID = "_replay.processInstanceId";
    public static final String SIMULATION_RUN_ID = "_replay.simulationRunId";
    private final String processInstanceId;
    private final String processToStartIdKey;
    private final String businessKey;
    private final String variablesKey;

    public StartReplayLogEventHandler(String processInstanceId, String processToStartIdKey, String businessKey, String variablesKey) {
        this.processInstanceId = processInstanceId;
        this.processToStartIdKey = processToStartIdKey;
        this.businessKey = businessKey;
        this.variablesKey = variablesKey;
    }

    @Override
    public void init() {
    }

    @Override
    public void handle(SimulationEvent event) {
        String processDefinitionId = (String)event.getProperty(this.processToStartIdKey);
        String eventBusinessKey = (String)event.getProperty(this.businessKey);
        HashMap<String, String> variables = new HashMap<String, String>();
        Map processVariables = (Map)event.getProperty(this.variablesKey);
        if (processVariables != null) {
            variables.putAll(processVariables);
        }
        variables.put(PROCESS_INSTANCE_ID, this.processInstanceId);
        variables.put(SIMULATION_RUN_ID, SimulationRunContext.getSimulationRunId());
        String startBusinessKey = null;
        startBusinessKey = eventBusinessKey != null ? eventBusinessKey : this.businessKey;
        log.debug("Starting new processDefId[{}] businessKey[{}] with variables[{}]", new Object[]{processDefinitionId, startBusinessKey, variables});
        SimulationRunContext.getRuntimeService().startProcessInstanceById(processDefinitionId, startBusinessKey, variables);
    }
}

