/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.fun;

import com.fr.base.Utils;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.general.ComparatorUtils;
import com.fr.stable.fun.impl.AbstractAttachmentDownloader;
import com.fr.web.Browser;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class DefaultAttachmentDownloader
extends AbstractAttachmentDownloader {
    public static DefaultAttachmentDownloader instance = null;

    public static synchronized DefaultAttachmentDownloader getInstance() {
        if (instance == null) {
            instance = new DefaultAttachmentDownloader();
        }
        return instance;
    }

    private DefaultAttachmentDownloader() {
    }

    public String createDownloadScript(String string) {
        return "window.open('" + string + "')";
    }

    public void download(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String[] stringArray) throws Exception {
        if (stringArray.length == 1) {
            this.downloadFile(httpServletRequest, httpServletResponse, string);
        } else if (stringArray.length > 1) {
            this.downloadFileArr(httpServletRequest, httpServletResponse, stringArray);
        }
    }

    private void downloadFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Attachment attachment = AttachmentSource.getAttachment(string);
        if (attachment != null) {
            byte[] byArray = attachment.getBytes();
            httpServletResponse.setHeader("Pragma", "No-cache");
            httpServletResponse.setHeader("Cache-Control", "max-age=180");
            String string2 = attachment.getFilename();
            string2 = string2.trim();
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + Browser.resolve(httpServletRequest).getEncodedFileName4Download(string2));
            string2 = string2.toLowerCase();
            if (string2.endsWith(".pdf")) {
                httpServletResponse.setContentType("application/pdf");
                httpServletResponse.setHeader("extension", "pdf");
            } else if (string2.endsWith(".xls")) {
                httpServletResponse.setContentType("application/x-excel");
                httpServletResponse.setHeader("extension", "xls");
            } else if (string2.endsWith(".doc")) {
                httpServletResponse.setContentType("application/msword");
                httpServletResponse.setHeader("extension", "doc");
            } else if (string2.endsWith(".svg")) {
                httpServletResponse.setContentType("image/svg+xml");
                httpServletResponse.setHeader("extension", "svg");
            } else if (string2.endsWith(".csv")) {
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setHeader("extension", "csv");
            } else if (string2.endsWith(".txt")) {
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setHeader("extension", "txt");
            } else {
                httpServletResponse.setContentType("application/x-msdownload");
            }
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }

    private void downloadFileArr(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String[] stringArray) throws Exception {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "max-age=180");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=total.zip");
        httpServletResponse.setContentType("application/x-msdownload");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)servletOutputStream);
        zipOutputStream.setEncoding("GBK");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Attachment attachment = AttachmentSource.getAttachment(string);
            String string2 = attachment.getFilename();
            int n = 0;
            boolean bl = false;
            String string3 = "";
            for (int j = 0; j < i; ++j) {
                Attachment attachment2 = AttachmentSource.getAttachment(stringArray[j]);
                String string4 = attachment2.getFilename();
                if (!ComparatorUtils.equals(string2, string4)) continue;
                ++n;
                string3 = string4;
                bl = string4.indexOf(40) != -1 && string4.indexOf(41) != -1 && string4.lastIndexOf(40) < string4.lastIndexOf(41) && Utils.isNumeric(string4.substring(string4.lastIndexOf(40), string4.lastIndexOf(41)));
            }
            if (n > 0) {
                string2 = bl ? string3.substring(0, string3.lastIndexOf(40) + 1) + (Integer.parseInt(string3.substring(string3.lastIndexOf(40) + 1, string3.lastIndexOf(41)), 10) + n) + string3.substring(string3.lastIndexOf(41), string3.length()) : string3.substring(0, string3.lastIndexOf(46)) + "(" + n + ")" + string3.substring(string3.lastIndexOf(46), string3.length());
            }
            attachment.setFilename(string2);
            if (attachment == null) continue;
            byte[] byArray = attachment.getBytes();
            zipOutputStream.putNextEntry(new ZipEntry(attachment.getFilename()));
            zipOutputStream.write(byArray);
        }
        zipOutputStream.flush();
        zipOutputStream.close();
    }
}

