/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.MathUtils;
import java.util.Arrays;

public class ShortArray {
    public short[] items;
    public int size;
    public boolean ordered;

    public ShortArray() {
        this(true, 16);
    }

    public ShortArray(int n) {
        this(true, n);
    }

    public ShortArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new short[n];
    }

    public ShortArray(ShortArray shortArray) {
        this.ordered = shortArray.ordered;
        this.size = shortArray.size;
        this.items = new short[this.size];
        System.arraycopy(shortArray.items, 0, this.items, 0, this.size);
    }

    public ShortArray(short[] sArray) {
        this(true, sArray, 0, sArray.length);
    }

    public ShortArray(boolean bl, short[] sArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(sArray, n, this.items, 0, n2);
    }

    public void add(int n) {
        short[] sArray = this.items;
        if (this.size == sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        sArray[this.size++] = (short)n;
    }

    public void add(short s) {
        short[] sArray = this.items;
        if (this.size == sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        sArray[this.size++] = s;
    }

    public void addAll(ShortArray shortArray) {
        this.addAll(shortArray, 0, shortArray.size);
    }

    public void addAll(ShortArray shortArray, int n, int n2) {
        if (n + n2 > shortArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + shortArray.size);
        }
        this.addAll(shortArray.items, n, n2);
    }

    public void addAll(short ... sArray) {
        this.addAll(sArray, 0, sArray.length);
    }

    public void addAll(short[] sArray, int n, int n2) {
        int n3 = this.size + n2;
        short[] sArray2 = this.items;
        if (n3 > sArray2.length) {
            sArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(sArray, n, sArray2, this.size, n2);
        this.size += n2;
    }

    public short get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, short s) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = s;
    }

    public void incr(int n, short s) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = (short)(this.items[n2] + s);
    }

    public void mul(int n, short s) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = (short)(this.items[n2] * s);
    }

    public void insert(int n, short s) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        short[] sArray = this.items;
        if (this.size == sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(sArray, n, sArray, n + 1, this.size - n);
        } else {
            sArray[this.size] = sArray[n];
        }
        ++this.size;
        sArray[n] = s;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        short[] sArray = this.items;
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    public boolean contains(short s) {
        int n = this.size - 1;
        short[] sArray = this.items;
        while (n >= 0) {
            if (sArray[n--] != s) continue;
            return true;
        }
        return false;
    }

    public int indexOf(short s) {
        short[] sArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        short[] sArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (sArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(short s) {
        short[] sArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public short removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        short[] sArray = this.items;
        short s = sArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(sArray, n + 1, sArray, n, this.size - n);
        } else {
            sArray[n] = sArray[this.size];
        }
        return s;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        short[] sArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(sArray, n + n3, sArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                sArray[n + i] = sArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(ShortArray shortArray) {
        int n;
        int n2 = n = this.size;
        short[] sArray = this.items;
        int n3 = shortArray.size;
        block0: for (int i = 0; i < n3; ++i) {
            short s = shortArray.get(i);
            for (int j = 0; j < n; ++j) {
                if (s != sArray[j]) continue;
                this.removeIndex(j);
                --n;
                continue block0;
            }
        }
        return n != n2;
    }

    public short pop() {
        return this.items[--this.size];
    }

    public short peek() {
        return this.items[this.size - 1];
    }

    public short first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public short[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public short[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public short[] setSize(int n) {
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected short[] resize(int n) {
        short[] sArray = new short[n];
        short[] sArray2 = this.items;
        System.arraycopy(sArray2, 0, sArray, 0, Math.min(this.size, sArray.length));
        this.items = sArray;
        return sArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        short[] sArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            short s = sArray[i];
            sArray[i] = sArray[n3];
            sArray[n3] = s;
        }
    }

    public void shuffle() {
        short[] sArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            short s = sArray[i];
            sArray[i] = sArray[n];
            sArray[n] = s;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public short random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public short[] toArray() {
        short[] sArray = new short[this.size];
        System.arraycopy(this.items, 0, sArray, 0, this.size);
        return sArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        short[] sArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + sArray[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ShortArray)) {
            return false;
        }
        ShortArray shortArray = (ShortArray)object;
        if (!shortArray.ordered) {
            return false;
        }
        int n = this.size;
        if (n != shortArray.size) {
            return false;
        }
        short[] sArray = this.items;
        short[] sArray2 = shortArray.items;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] == shortArray.items[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        short[] sArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(sArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(sArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        short[] sArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(sArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(sArray[i]);
        }
        return stringBuilder.toString();
    }

    public static ShortArray with(short ... sArray) {
        return new ShortArray(sArray);
    }
}

