/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.finegrain;

import com.fr.general.ComparatorUtils;
import com.fr.privilege.finegrain.AbstractPrivilegeControl;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetPrivilegeControl
extends AbstractPrivilegeControl {
    private static final String UNUSABLE_TAG = "PrivilegeUnusableRole";
    private static final String UNUSABLE_ATTR = "privilegeUnusableRole";
    private static final String VISIBLE_TAG = "privilegeVisible";
    private static final String VISIBLE_ATTR = "visibleRole";
    private static final String USABLE_TAG = "PrivilegeUsable";
    private static final String USABLE_ATTR = "usableRole";
    private static final String UNUSABLE_ATTR_705 = "privilegeUnusableSet";
    protected HashSet<String> privilegeUnusableSet = new HashSet();
    private HashSet<String> usableSet = new HashSet();
    private HashSet<String> visibleSet = new HashSet();

    private void setPrivilegeUnusableSet(HashSet<String> hashSet) {
        this.privilegeUnusableSet = hashSet;
    }

    public void setUsableSet(HashSet<String> hashSet) {
        this.usableSet = hashSet;
    }

    public void setVisibleSet(HashSet<String> hashSet) {
        this.visibleSet = hashSet;
    }

    public boolean checkUnusable(String string) {
        return this.privilegeUnusableSet.contains(string);
    }

    public boolean checkUnusable(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.privilegeUnusableSet.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean checkUsable(String string) {
        return this.usableSet.contains(string);
    }

    public boolean checkUsable(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.usableSet.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean checkVisiable(String string) {
        return this.visibleSet.contains(string);
    }

    public boolean checkVisiable(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.visibleSet.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getAllEditedRoles() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.privilegeInvisibleSet);
        hashSet.addAll(this.privilegeUnusableSet);
        hashSet.addAll(this.usableSet);
        hashSet.addAll(this.visibleSet);
        return new ArrayList(hashSet).toArray(new String[hashSet.size()]);
    }

    public void removeUnusableRole(String string) {
        this.privilegeUnusableSet.remove(string);
    }

    public void addUnusableRole(String string) {
        this.privilegeUnusableSet.add(string);
    }

    public void removeUsableRole(String string) {
        this.usableSet.remove(string);
    }

    public void addUsableRole(String string) {
        this.usableSet.add(string);
    }

    public void removeVisiableRole(String string) {
        this.visibleSet.remove(string);
    }

    public void addVisiableRole(String string) {
        this.visibleSet.add(string);
    }

    public boolean isInvisible(boolean bl, String[] stringArray) {
        return bl ? this.checkInvisible(stringArray) : !this.checkVisiable(stringArray);
    }

    public boolean isDisable(boolean bl, String[] stringArray) {
        return bl ? this.checkUnusable(stringArray) : !this.checkUsable(stringArray);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.privilegeUnusableSet.isEmpty() && this.usableSet.isEmpty() && this.visibleSet.isEmpty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WidgetPrivilegeControl widgetPrivilegeControl = (WidgetPrivilegeControl)super.clone();
        widgetPrivilegeControl.setPrivilegeUnusableSet(StableUtils.cloneHashSet(this.privilegeUnusableSet));
        widgetPrivilegeControl.setVisibleSet(StableUtils.cloneHashSet(this.visibleSet));
        widgetPrivilegeControl.setUsableSet(StableUtils.cloneHashSet(this.usableSet));
        return widgetPrivilegeControl;
    }

    private void compatiable705(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString(UNUSABLE_ATTR_705, "");
        String[] stringArray = StringUtils.isEmpty(string) ? new String[]{} : string.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!StringUtils.isNotEmpty(stringArray[i])) continue;
            this.addUnusableRole(stringArray[i]);
        }
    }

    @Override
    protected void readSonXMl(XMLableReader xMLableReader, String string) {
        String string2;
        if (StringUtils.isEmpty(string)) {
            this.compatiable705(xMLableReader);
            return;
        }
        if (ComparatorUtils.equals(UNUSABLE_TAG, string)) {
            string2 = xMLableReader.getAttrAsString(UNUSABLE_ATTR, "");
            this.addUnusableRole(string2);
        }
        if (ComparatorUtils.equals(VISIBLE_TAG, string)) {
            string2 = xMLableReader.getAttrAsString(VISIBLE_ATTR, "");
            this.addVisiableRole(string2);
        }
        if (ComparatorUtils.equals(USABLE_TAG, string)) {
            string2 = xMLableReader.getAttrAsString(USABLE_ATTR, "");
            this.addUsableRole(string2);
        }
    }

    @Override
    protected void writeSonXMl(XMLPrintWriter xMLPrintWriter) {
        Iterator<String> iterator = this.privilegeUnusableSet.iterator();
        while (iterator.hasNext()) {
            xMLPrintWriter.startTAG(UNUSABLE_TAG);
            xMLPrintWriter.attr(UNUSABLE_ATTR, iterator.next());
            xMLPrintWriter.end();
        }
        iterator = this.visibleSet.iterator();
        while (iterator.hasNext()) {
            xMLPrintWriter.startTAG(VISIBLE_TAG);
            xMLPrintWriter.attr(VISIBLE_ATTR, iterator.next());
            xMLPrintWriter.end();
        }
        iterator = this.usableSet.iterator();
        while (iterator.hasNext()) {
            xMLPrintWriter.startTAG(USABLE_TAG);
            xMLPrintWriter.attr(USABLE_ATTR, iterator.next());
            xMLPrintWriter.end();
        }
    }
}

