/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.proxy;

import com.fr.base.ClassUtils;
import com.fr.general.FRLogger;
import com.fr.plugin.proxy.CloseableInvocationHandler;
import com.fr.plugin.proxy.PluginInvocationHandler;
import com.fr.plugin.proxy.PluginProxy;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.plugin.closeable.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInstanceProxyFactory {
    private Object oriObj;
    private ClassLoader loader;
    private Set<Class<?>> oriInterfaces = new HashSet();
    private PluginSimplify pluginSimplify;
    private Object proxyObj;

    public PluginInstanceProxyFactory(Object object, PluginSimplify pluginSimplify) {
        this.oriObj = object;
        this.loader = object.getClass().getClassLoader();
        this.oriInterfaces.addAll(ClassUtils.getInterfaces(object.getClass()));
        this.pluginSimplify = pluginSimplify;
    }

    public PluginInstanceProxyFactory(Class<?> clazz, PluginSimplify pluginSimplify) throws IllegalAccessException, InstantiationException {
        this.oriObj = clazz.newInstance();
        this.loader = clazz.getClassLoader();
        this.oriInterfaces.addAll(ClassUtils.getInterfaces(clazz));
        this.pluginSimplify = pluginSimplify;
    }

    public PluginInstanceProxyFactory addProxy(String string) {
        if ("isClosed".equals(string)) {
            try {
                return this.addProxy(Closeable.class, (PluginInvocationHandler)new CloseableInvocationHandler());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FRLogger.getLogger().error(noSuchMethodException.getMessage());
            }
        }
        return this;
    }

    public PluginInstanceProxyFactory addProxy(Class<?> clazz, PluginInvocationHandler pluginInvocationHandler) {
        HashSet hashSet = new HashSet();
        hashSet.add(clazz);
        return this.addProxy(hashSet, pluginInvocationHandler);
    }

    public PluginInstanceProxyFactory addProxy(Set<Class<?>> set, PluginInvocationHandler pluginInvocationHandler) {
        return this.addProxy(set, pluginInvocationHandler, this.loader);
    }

    public PluginInstanceProxyFactory addProxy(Set<Class<?>> set, PluginInvocationHandler pluginInvocationHandler, ClassLoader classLoader) {
        Object object = this.proxyObj == null ? this.oriObj : this.proxyObj;
        pluginInvocationHandler.setOri(object);
        pluginInvocationHandler.setPluginSimplify(this.pluginSimplify);
        HashSet hashSet = new HashSet(this.oriInterfaces);
        hashSet.addAll(set);
        hashSet.add(PluginProxy.class);
        this.proxyObj = Proxy.newProxyInstance(classLoader, hashSet.toArray(new Class[hashSet.size()]), (InvocationHandler)pluginInvocationHandler);
        return this;
    }

    public Object getProxyObj() {
        if (this.proxyObj == null) {
            return this.oriObj;
        }
        return this.proxyObj;
    }
}

