/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.xml;

import com.fr.base.BaseObjectTokenizer;
import com.fr.general.BaseObjectXMLWriterFinder;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.TransferPackageProvider;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.xml.ObjectTokenizer;
import com.fr.stable.xml.ObjectXMLWriter;
import com.fr.stable.xml.ObjectXMLWriterFinder;
import com.fr.stable.xml.XMLEncodeUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.javax.xml.stream.XMLStreamException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;

public class GeneralXMLTools {
    public static ObjectTokenizer Object_Tokenizer = new BaseObjectTokenizer();
    public static ObjectXMLWriterFinder Object_XML_Writer_Finder = new BaseObjectXMLWriterFinder();
    private static final int ZERO = 255;
    private static final int FOUR = 4;
    private static final int EIGHT = 8;
    private static final int SIXTEEN = 16;
    private static final int TWENTYFOUR = 24;
    private static final int RED = 0xFF0000;
    private static final int GREEN = 65280;
    private static final int BLUE = 255;
    private static final int ALPHA = -16777216;

    public static String writeXMLableAsString(XMLWriter xMLWriter) {
        StringWriter stringWriter = new StringWriter();
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(stringWriter, false);
        xMLPrintWriter.startTAG("R");
        String string = xMLWriter.getClass().getName();
        if (StringUtils.isNotBlank(string)) {
            xMLPrintWriter.attr("class", string);
        }
        if (xMLWriter != null) {
            xMLWriter.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public static XMLReadable readStringAsXMLable(String string, XMLReadable xMLReadable) {
        try {
            XMLableReader xMLableReader = XMLableReader.createXMLableReader(string);
            xMLableReader.readXMLObject(xMLReadable);
        }
        catch (XMLStreamException xMLStreamException) {
            FRLogger.getLogger().error(xMLStreamException.getMessage(), xMLStreamException);
        }
        return xMLReadable;
    }

    public static XMLReadable readStringAsXMLable(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        XMLable xMLable = null;
        try {
            XMLableReader xMLableReader = XMLableReader.createXMLableReader(string);
            String string2 = xMLableReader.getAttrAsString("class", "");
            if (StringUtils.isNotBlank(string2)) {
                string2 = GeneralXMLTools.makeCompatibleBecauseOfTransferPackage(string2);
                xMLable = (XMLable)GeneralUtils.classForName(string2).newInstance();
                xMLableReader.readXMLObject(xMLable);
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return xMLable;
    }

    public static void writeXMLable(XMLPrintWriter xMLPrintWriter, XMLable xMLable, String string) {
        if (xMLable == null) {
            return;
        }
        String string2 = xMLable.getClass().getName();
        xMLPrintWriter.startTAG(string).attr("class", string2);
        xMLable.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static XMLable readXMLable(XMLableReader xMLableReader) {
        XMLable xMLable = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                string = GeneralXMLTools.makeCompatibleBecauseOfTransferPackage(string);
                xMLable = (XMLable)GeneralUtils.classForName(string).newInstance();
                xMLableReader.readXMLObject(xMLable);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return xMLable;
    }

    private static String makeCompatibleBecauseOfTransferPackage(String string) {
        if (string != null) {
            Set set;
            if (string.endsWith(".CustomAttr")) {
                return "com.fr.chart.chartglyph.CustomAttr";
            }
            if (string.endsWith(".ConditionAttr")) {
                return "com.fr.chart.chartglyph.ConditionAttr";
            }
            if (string.startsWith("com.fr.chart.plot")) {
                return string.replaceAll("com.fr.chart.plot", "com.fr.chart.chartattr");
            }
            if (string.startsWith("com.fr.chart.condition.Attr")) {
                return string.replaceAll("com.fr.chart.condition", "com.fr.chart.base");
            }
            if (string.startsWith("com.fr.chart.condition")) {
                return string.replaceAll("com.fr.chart.condition", "com.fr.chart.chartglyph");
            }
            if (string.startsWith("com.fr.privilege.filter") && !ComparatorUtils.equals(string, "com.fr.privilege.filter.AuthorityControlFilter")) {
                return string.replaceAll("com.fr.privilege.filter", "com.fr.fs.privilege.auth");
            }
            ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
            if (extraClassManagerProvider != null && (set = extraClassManagerProvider.getArray("TransferPackageProvider")) != null) {
                for (TransferPackageProvider transferPackageProvider : set) {
                    if (!transferPackageProvider.accept(string)) continue;
                    return transferPackageProvider.transfer(string);
                }
            }
        }
        return string;
    }

    public static String elementValue(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        if (string == null) {
            string = "";
        }
        string = string.replaceAll("\\n", "");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image readImage(XMLableReader xMLableReader) {
        byte[] byArray = GeneralXMLTools.readByteArray(xMLableReader);
        try {
            Image image = GeneralXMLTools.imageDecode(byArray);
            Object var5_4 = null;
            byArray = null;
            return image;
        }
        catch (Exception exception) {
            try {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                Image image = null;
                Object var5_5 = null;
                byArray = null;
                return image;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                byArray = null;
                throw throwable;
            }
        }
    }

    public static byte[] imageEncode(Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.writeImage(image, "png", byteArrayOutputStream);
        try {
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image imageDecode(byte[] byArray) {
        BufferedImage bufferedImage = null;
        try {
            BufferedImage bufferedImage2 = bufferedImage = IOUtils.readImage(new ByteArrayInputStream(byArray));
            Object var5_4 = null;
            bufferedImage = null;
            return bufferedImage2;
        }
        catch (IOException iOException) {
            try {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
                Image image = null;
                Object var5_5 = null;
                bufferedImage = null;
                return image;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                bufferedImage = null;
                throw throwable;
            }
        }
    }

    public static Image deprecatedReadImage(XMLableReader xMLableReader) {
        int n = xMLableReader.getAttrAsInt("width", 0);
        int n2 = xMLableReader.getAttrAsInt("height", 0);
        byte[] byArray = GeneralXMLTools.readByteArray(xMLableReader);
        try {
            return GeneralXMLTools.deprecatedDecodeImage(n, n2, byArray);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    private static byte[] deprecatedEncodeImage(Image image) {
        CoreGraphHelper.waitForImage(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = GeneralXMLTools.grabImagePixelsArray(image, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            byteArrayOutputStream.write((byte)((n3 & 0xFF0000) >> 16));
            byteArrayOutputStream.write((byte)((n3 & 0xFF00) >> 8));
            byteArrayOutputStream.write((byte)(n3 & 0xFF));
            byteArrayOutputStream.write((byte)((n3 & 0xFF000000) >> 24));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Image deprecatedDecodeImage(int n, int n2, byte[] byArray) throws Exception {
        if (n * n2 * 4 != byArray.length) {
            throw new Exception(StableUtils.join(new String[]{Inter.getLocText("EX-Image_stored_is_broken"), ":", String.valueOf(n), "*", String.valueOf(n2), "*4=", String.valueOf(n * n2 * 4), "!=", String.valueOf(byArray.length)}));
        }
        int[] nArray = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = byArray[n3++] & 0xFF;
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                int n8 = byArray[n3++] & 0xFF;
                nArray[n4++] = n8 << 24 | n5 << 16 | n6 << 8 | n7;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    private static int[] grabImagePixelsArray(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            FRLogger.getLogger().error(interruptedException.getMessage(), interruptedException);
        }
        return nArray;
    }

    public static byte[] readByteArray(XMLableReader xMLableReader) {
        return XMLEncodeUtils.decodeStringAsBytes(xMLableReader.getElementValue());
    }

    public static void writeImage(XMLPrintWriter xMLPrintWriter, Image image) {
        if (image == null) {
            return;
        }
        xMLPrintWriter.startTAG("IM");
        GeneralXMLTools.writeByteArray(xMLPrintWriter, GeneralXMLTools.imageEncode(image));
        xMLPrintWriter.end();
    }

    public static void writeByteArray(XMLPrintWriter xMLPrintWriter, byte[] byArray) {
        xMLPrintWriter.textNode(XMLEncodeUtils.encodeBytesAsString(byArray));
    }

    public static Object readObject(XMLableReader xMLableReader) {
        return GeneralXMLTools.readObject(xMLableReader, false);
    }

    public static Object readObject(XMLableReader xMLableReader, boolean bl) {
        String string = "String";
        String string2 = xMLableReader.getAttrAsString("t", null);
        if (string2 != null) {
            string = string2;
        }
        return Object_Tokenizer.tokenizerObject(xMLableReader, bl, string, null);
    }

    public static void writeObject(XMLPrintWriter xMLPrintWriter, Object object, String string) {
        if (object == null) {
            return;
        }
        ObjectXMLWriter objectXMLWriter = Object_XML_Writer_Finder.as(object);
        String string2 = objectXMLWriter.type();
        String string3 = objectXMLWriter.className();
        xMLPrintWriter.startTAG(string);
        if (StringUtils.isNotBlank(string2)) {
            xMLPrintWriter.attr("t", string2);
        }
        if (StringUtils.isNotBlank(string3)) {
            xMLPrintWriter.attr("class", string3);
        }
        objectXMLWriter.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeObject(XMLPrintWriter xMLPrintWriter, Object object) {
        GeneralXMLTools.writeObject(xMLPrintWriter, object, "O");
    }
}

