/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.form.data.DataBinding;
import com.fr.form.ui.ButtonGroup;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.DictionaryContainer;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class WriteUnableRepeatEditor
extends FieldEditor
implements DictionaryContainer,
DataControl {
    private boolean removeRepeat = true;
    protected Dictionary model;
    private Map depandenceMap = null;
    private WidgetValue widgetValue;
    private JSONObject joData;

    public boolean isRemoveRepeat() {
        return this.removeRepeat;
    }

    public void setRemoveRepeat(boolean bl) {
        this.removeRepeat = bl;
    }

    public void setDictionary(Dictionary dictionary) {
        this.model = dictionary;
    }

    public Dictionary getDictionary() {
        return this.model;
    }

    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        return this.model == null ? new String[]{} : this.model.dependence(calculatorProvider);
    }

    public Map getDependenceMap() {
        return this.depandenceMap;
    }

    public void setDependenceMap(Map map) {
        this.depandenceMap = map;
    }

    public boolean hasDataOnInit() {
        return true;
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        if (this.widgetValue == null) {
            this.setWidgetValue(new WidgetValue());
        }
        Object object = this.widgetValue.createAttrResult(new WidgetValue.WidgetValueInfo(this.getWidgetName(), this instanceof ButtonGroup, this.isRemoveRepeat()), calculator, jSONObject2);
        try {
            JSONObject jSONObject3 = this.createJSONDataByDefaultValue(object, calculator);
            if (this.widgetName != null) {
                jSONObject.put(this.widgetName.toUpperCase(), jSONObject3);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    protected JSONObject createJSONDataByDefaultValue(Object object, Calculator calculator) throws Exception {
        if (this.joData == null) {
            this.joData = new JSONObject();
        }
        this.joData.put("value", object == null ? "" : object);
        if (this.model == null || this.joData.has("data") && this.dependence(calculator).length == 0) {
            return this.joData;
        }
        JSONArray jSONArray = new JSONArray();
        this.createJSONData(calculator, jSONArray);
        this.joData.put("data", jSONArray);
        return this.joData;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.model == null) {
            return jSONArray;
        }
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute());
        FieldEditor.DependenceNameSpace dependenceNameSpace = new FieldEditor.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence"));
        calculator.pushNameSpace(parameterMapNameSpace);
        calculator.pushNameSpace(dependenceNameSpace);
        this.createJSONData(calculator, jSONArray);
        calculator.removeNameSpace(dependenceNameSpace);
        calculator.removeNameSpace(parameterMapNameSpace);
        return jSONArray;
    }

    public void createJSONData(Calculator calculator, JSONArray jSONArray) throws Exception {
        this.model.reset();
        Iterator iterator = this.model.entrys(calculator);
        ArrayList<Dictionary.MV> arrayList = new ArrayList<Dictionary.MV>();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            String string = FieldEditor.toJSONString(mV.getModel());
            String string2 = FieldEditor.toJSONString(mV.getView());
            if (!StringUtils.isNotEmpty(string2)) continue;
            if (this.isRemoveRepeat()) {
                if (arrayList.contains(mV)) continue;
                jSONArray.put(new JSONObject().put("value", string).put("text", string2));
                arrayList.add(mV);
                continue;
            }
            jSONArray.put(new JSONObject().put("value", string).put("text", string2));
        }
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (this.isRemoveRepeat()) {
            jSONObject.put("norepeat", true);
        }
        Object[] objectArray = this.dependence(calculator);
        if (this.joData != null) {
            jSONObject.put("controlAttr", this.joData);
            jSONObject.put("valueDependence", ArrayUtils.addAll(this.widgetValue.dependence(calculator), objectArray));
        } else if (!ArrayUtils.isEmpty(objectArray)) {
            jSONObject.put("dependence", objectArray);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        String string = xMLableReader.getTagName();
        if (xMLableReader.isCharacters()) {
            if ("noRepeat".equals(string)) {
                this.setRemoveRepeat(Boolean.valueOf(xMLableReader.getContent()));
            }
        } else if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (string.equals("Dictionary")) {
                this.model = DataCoreXmlUtils.readXMLDictionary(xMLableReader);
            } else if ("widgetValue".equals(string2)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            } else if ("text".equals(string2)) {
                this.widgetValue = new WidgetValue(xMLableReader.getElementValue());
            } else if ("databinding".equals(string2)) {
                this.widgetValue = new WidgetValue(DataBinding.String2DataBinding(xMLableReader.getElementValue()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!this.removeRepeat) {
            xMLPrintWriter.startTAG("noRepeat").textNode(String.valueOf(this.removeRepeat)).end();
        }
        if (this.model != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.model, "Dictionary");
        }
        if (this.widgetValue == null) {
            this.widgetValue = new WidgetValue();
        }
        this.widgetValue.writeXML(xMLPrintWriter);
    }

    public boolean equals(Object object) {
        return this.depandenceMap == ((WriteUnableRepeatEditor)object).depandenceMap && super.equals(object) && ComparatorUtils.equals(this.model, ((WriteUnableRepeatEditor)object).model);
    }

    public Object getViewValue(Object object, Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) {
        throw new UnsupportedOperationException();
    }

    public Object getModuleValue(Object object, Calculator calculator, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) {
        throw new UnsupportedOperationException();
    }
}

