/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.Icon;
import com.fr.base.Utils;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetManager;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class Button
extends Widget {
    protected String text;
    protected String iconName;
    protected boolean showIcon = true;
    protected boolean showText = true;
    protected String hotkeys;

    public Button() {
    }

    public Button(String string) {
        this.text = string;
    }

    public Button(String string, String string2) {
        this.text = string;
        this.iconName = string2;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public void setShowIcon(boolean bl) {
        this.showIcon = bl;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
    }

    public String getHotkeys() {
        return this.hotkeys;
    }

    public void setHotkeys(String string) {
        this.hotkeys = string;
    }

    public String getXType() {
        return "button";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "click"};
    }

    public String resolveText(Repository repository) {
        if (StringUtils.isNotBlank(this.text)) {
            if (StringUtils.trim(this.text).charAt(0) == '=') {
                return repository.i18n(this.text);
            }
            return this.getText();
        }
        return "";
    }

    public String getText() {
        return this.text;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setIconName(String string) {
        this.iconName = string;
    }

    protected JSONObject createChildConfig(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("src", repository.i18n(this.text));
        jSONObject.put("iconSrc", WidgetManager.getProviderInstance().getIconManager().getCssInfo(this.getIconName(), repository.getServletURL()));
        jSONObject.put("showIconSrc", this.isShowIcon());
        jSONObject.put("showTextSrc", this.isShowText());
        return jSONObject;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("render", true);
        if (this.text != null && this.isShowText()) {
            jSONObject.put("text", WidgetValue.text2Config(repository.i18n(this.text), repository.getCalculator()));
        }
        if (StringUtils.isNotEmpty(this.hotkeys)) {
            jSONObject.put("hotkeys", this.hotkeys);
        }
        if (this.iconName != null && this.isShowIcon()) {
            jSONObject.put("icon", WidgetManager.getProviderInstance().getIconManager().getCssInfo(this.iconName, repository.getServletURL()));
        }
        return jSONObject;
    }

    public Object value2Config(Object object, CalculatorProvider calculatorProvider) {
        return this.isShowText() && object != null ? WidgetValue.text2Config(Utils.objectToString(object), calculatorProvider) : null;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Text")) {
                String string3 = xMLableReader.getElementValue();
                this.setText(string3 == null ? "" : string3);
            } else if (string2.equals("Hotkeys")) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.setHotkeys(string4);
                }
            } else if (string2.equals("ShowIcon")) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    this.setShowIcon(Boolean.valueOf(string5));
                }
            } else if (string2.equals("ShowText")) {
                String string6 = xMLableReader.getElementValue();
                if (string6 != null) {
                    this.setShowText(Boolean.valueOf(string6));
                }
            } else if (string2.equals("IconName")) {
                String string7 = xMLableReader.getElementValue();
                if (string7 != null) {
                    this.setIconName(string7);
                }
            } else if (Icon.XML_TAG.equals(string2) && (string = xMLableReader.getAttrAsString("name", null)) != null) {
                this.setIconName(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.text != null) {
            xMLPrintWriter.startTAG("Text").textNode(this.text).end();
        }
        if (StringUtils.isNotBlank(this.hotkeys)) {
            xMLPrintWriter.startTAG("Hotkeys").textNode(this.hotkeys).end();
        }
        if (!this.showIcon) {
            xMLPrintWriter.startTAG("ShowIcon").textNode(String.valueOf(this.showIcon)).end();
        }
        if (!this.showText) {
            xMLPrintWriter.startTAG("ShowText").textNode(String.valueOf(this.showText)).end();
        }
        if (this.iconName != null) {
            xMLPrintWriter.startTAG("IconName").textNode(String.valueOf(this.iconName)).end();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Button)) {
            return false;
        }
        Button button = (Button)object;
        return super.equals(object) && ComparatorUtils.equals(this.getText(), button.getText()) && ComparatorUtils.equals(this.getIconName(), button.getIconName()) && this.isShowIcon() == button.isShowIcon() && this.isShowText() == button.isShowText() && ComparatorUtils.equals(this.hotkeys, button.getHotkeys());
    }

    public Object clone() throws CloneNotSupportedException {
        Button button = (Button)super.clone();
        return button;
    }
}

