/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.impl.Connection;
import com.fr.file.DatasourceManager;
import com.fr.file.DatasourceManagerProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameDatabaseConnection
implements Connection,
Serializable {
    private String name = null;
    protected transient Connection _database = null;

    public NameDatabaseConnection() {
    }

    public NameDatabaseConnection(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    protected Connection createDatabase() {
        if (this._database == null) {
            DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
            Connection connection = datasourceManagerProvider.getConnection(this.getName());
            if (connection != null) {
                this._database = connection;
            } else {
                throw new RuntimeException(Inter.getLocText("FR-Engine_Can_not_find_Data_Connection") + ":" + this.name);
            }
        }
        return this._database;
    }

    @Override
    public String getOriginalCharsetName() {
        return this.createDatabase().getOriginalCharsetName();
    }

    @Override
    public void setOriginalCharsetName(String string) {
        this.createDatabase().setOriginalCharsetName(string);
    }

    @Override
    public String getNewCharsetName() {
        return this.createDatabase().getNewCharsetName();
    }

    @Override
    public String getDriver() {
        return this.createDatabase().getDriver();
    }

    @Override
    public void setNewCharsetName(String string) {
        this.createDatabase().setNewCharsetName(string);
    }

    @Override
    public void testConnection() throws Exception {
        this.createDatabase().testConnection();
    }

    @Override
    public java.sql.Connection createConnection() throws Exception {
        return this.createDatabase().createConnection();
    }

    @Override
    public void addConnection(List<String> list, String string, Class<? extends Connection>[] classArray) {
        this._database.addConnection(list, string, classArray);
    }

    @Override
    public String connectMessage(boolean bl) {
        if (bl) {
            return Inter.getLocText("Datasource-Connection_successfully") + "!";
        }
        return Inter.getLocText("Datasource-Connection_failed") + "!";
    }

    @Override
    public String feature() {
        return this.createDatabase().feature();
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        return this._database.toJSONObject();
    }

    @Override
    public boolean hasSchema() {
        return this._database.hasSchema();
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NameDatabaseConnection && ComparatorUtils.equals(this.getName(), ((NameDatabaseConnection)object).getName());
    }

    public String toString() {
        return "[" + this.getName() + " Database]";
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "DatabaseName".equals(xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
            this.name = string;
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getName() != null) {
            xMLPrintWriter.startTAG("DatabaseName").textNode(this.getName()).end();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

