/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.tableObject;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.core.db.tableObject.ModuleTables;
import com.fr.data.core.db.tableObject.TableObject;
import com.fr.general.FRLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractModuleTables
implements ModuleTables {
    protected List<TableObject> tableObjectList = new ArrayList<TableObject>();
    protected List droptableList = new ArrayList();

    public void generatorModuleTables(Connection connection) {
        Dialect dialect = DialectFactory.generateDialect(connection);
        if (!(dialect instanceof SybaseDialect)) {
            try {
                if (connection.getAutoCommit()) {
                    dialect.setAutoCommit(connection, false);
                }
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
        }
        this.initTableObjectList();
        int n = this.tableObjectList.size();
        for (int i = 0; i < n; ++i) {
            this.tableObjectList.get(i).createTable(connection);
        }
    }

    protected abstract void initTableObjectList();

    public void removeModuleTables(Connection connection) {
        if (this.droptableList.size() < 1) {
            this.initTableObjectList();
            this.droptableList = this.tableObjectList;
        }
        int n = this.droptableList.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((TableObject)this.droptableList.get(i)).dropTable(connection);
                continue;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }
}

