/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.RPCSkeletonsService;
import com.fr.general.FRLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class SocketServer {
    public static int DEFAULT_PORT = 51232;
    private ServerSocket server = null;
    private static ExecutorService es = Executors.newFixedThreadPool(10);
    private Map<String, Object> services = new ConcurrentHashMap<String, Object>();
    private RPCSkeletonsService birpcService;
    private int port = -1;
    private STATUS status = STATUS.stop;

    SocketServer() {
    }

    public void stop() {
        if (this.server != null) {
            this.status = STATUS.stop;
            try {
                this.server.close();
                this.server = null;
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage());
            }
        }
    }

    public void setBirpcService(RPCSkeletonsService rPCSkeletonsService) {
        this.birpcService = rPCSkeletonsService;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public int getPort() {
        if (this.port == -1) {
            this.port = DEFAULT_PORT;
        }
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void start() {
        if (this.server == null) {
            try {
                this.server = new ServerSocket(this.getPort());
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage());
            }
            this.status = STATUS.running;
            new Thread(){

                public void run() {
                    try {
                        SocketServer.this.server.setSoTimeout(0);
                        while (!SocketServer.this.server.isClosed()) {
                            Socket socket = SocketServer.this.server.accept();
                            es.execute(new Handler(socket));
                        }
                        SocketServer.this.status = STATUS.stop;
                    }
                    catch (IOException iOException) {
                        FRLogger.getLogger().error(iOException.getMessage());
                    }
                }
            }.start();
        }
    }

    private class Handler
    implements Runnable {
        private Socket socket;

        public Handler(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block28: {
                Exception exception2222;
                ObjectOutputStream objectOutputStream;
                ObjectInputStream objectInputStream;
                block24: {
                    objectInputStream = null;
                    objectOutputStream = null;
                    objectInputStream = new ObjectInputStream(this.socket.getInputStream());
                    objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
                    String string = (String)objectInputStream.readObject();
                    String string2 = (String)objectInputStream.readObject();
                    Serializable[] serializableArray = (Serializable[])objectInputStream.readObject();
                    SocketServer.this.birpcService.dealWith(string, string2, objectOutputStream, serializableArray);
                    Object var7_7 = null;
                    if (objectInputStream == null) break block24;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception2222) {
                        FRLogger.getLogger().error(exception2222.getMessage());
                    }
                }
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception2222) {
                        FRLogger.getLogger().error(exception2222.getMessage());
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception2222) {
                        FRLogger.getLogger().error(exception2222.getMessage());
                    }
                }
                break block28;
                {
                    catch (Throwable throwable) {
                        Exception exception32222;
                        FRLogger.getLogger().error(throwable.getMessage());
                        Object var7_8 = null;
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (Exception exception32222) {
                                FRLogger.getLogger().error(exception32222.getMessage());
                            }
                        }
                        if (objectOutputStream != null) {
                            try {
                                objectOutputStream.close();
                            }
                            catch (Exception exception32222) {
                                FRLogger.getLogger().error(exception32222.getMessage());
                            }
                        }
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (Exception exception32222) {
                                FRLogger.getLogger().error(exception32222.getMessage());
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception exception42222;
                    Object var7_9 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception exception42222) {
                            FRLogger.getLogger().error(exception42222.getMessage());
                        }
                    }
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (Exception exception42222) {
                            FRLogger.getLogger().error(exception42222.getMessage());
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (Exception exception42222) {
                            FRLogger.getLogger().error(exception42222.getMessage());
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STATUS {
        stop,
        running;

    }
}

