/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import org.apache.commons.lang3.StringUtils;

public class StringLengthFieldValidator
extends FieldValidatorSupport {
    private boolean trim = true;
    private int maxLength = -1;
    private int minLength = -1;
    private String maxLengthExpression;
    private String minLengthExpression;
    private String trimExpression;

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxLengthExpression(String maxLengthExpression) {
        this.maxLengthExpression = maxLengthExpression;
    }

    public int getMaxLength() {
        if (StringUtils.isNotEmpty((CharSequence)this.maxLengthExpression)) {
            return (Integer)this.parse(this.maxLengthExpression, Integer.class);
        }
        return this.maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMinLengthExpression(String minLengthExpression) {
        this.minLengthExpression = minLengthExpression;
    }

    public int getMinLength() {
        if (StringUtils.isNotEmpty((CharSequence)this.minLengthExpression)) {
            return (Integer)this.parse(this.minLengthExpression, Integer.class);
        }
        return this.minLength;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setTrimExpression(String trimExpression) {
        this.trimExpression = trimExpression;
    }

    public boolean isTrim() {
        if (StringUtils.isNotEmpty((CharSequence)this.trimExpression)) {
            return (Boolean)this.parse(this.trimExpression, Boolean.class);
        }
        return this.trim;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        String val = (String)this.getFieldValue(fieldName, object);
        if (val == null || val.length() <= 0) {
            return;
        }
        if (this.isTrim() && (val = val.trim()).length() <= 0) {
            return;
        }
        int minLengthToUse = this.getMinLength();
        int maxLengthToUse = this.getMaxLength();
        if (minLengthToUse > -1 && val.length() < minLengthToUse) {
            this.addFieldError(fieldName, object);
        } else if (maxLengthToUse > -1 && val.length() > maxLengthToUse) {
            this.addFieldError(fieldName, object);
        }
    }
}

