/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.ResizableElement;
import com.fr.base.Style;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chart.BaseChartPainter;
import com.fr.form.ui.AbstractBorderStyleWidget;
import com.fr.form.ui.BaseChartEditor;
import com.fr.form.ui.ChartEditorProvider;
import com.fr.form.ui.FormHyperlinkEditor;
import com.fr.form.ui.PaddingMargin;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.Primitive;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class ChartEditor
extends AbstractBorderStyleWidget
implements BaseChartEditor,
FormHyperlinkEditor,
ChartEditorProvider,
ResizableElement {
    private BaseChartCollection chartCollection;
    private JSONObject depJSONObject;

    public ChartEditor() {
        this.margin = new PaddingMargin(0, 0, 0, 0);
        this.chartCollection = (BaseChartCollection)StableFactory.createXmlObject((String)"CC");
    }

    public void addChart(BaseChart baseChart) {
        this.chartCollection.addChart(baseChart);
    }

    public String getXType() {
        return "chartwidget";
    }

    public boolean isEditor() {
        return false;
    }

    public BaseChartCollection getChartCollection() {
        return this.chartCollection;
    }

    public void resetChangeChartCollection(BaseChartCollection baseChartCollection) {
        this.chartCollection = baseChartCollection;
    }

    public String[] supportedEvents() {
        return new String[0];
    }

    public JSONObject createJSONConfig2Show(int n, int n2, Repository repository, Calculator calculator) throws JSONException {
        this.chartCollection.setID(this.getWidgetName());
        BaseChartPainter baseChartPainter = this.chartCollection.createChartPainterJustTableDataAndDealFormual(calculator, n, n2);
        return baseChartPainter.createJSONConfig(repository, n, n2);
    }

    public void resize(double d, double d2, double d3) {
        this.chartCollection.setFontScale(d3);
    }

    public void mixinReturnData(HttpServletRequest httpServletRequest, Calculator calculator, JSONObject jSONObject) throws JSONException {
        String[] stringArray = this.chartCollection.dependence((CalculatorProvider)calculator);
        this.depJSONObject = JSONObject.create();
        JSONObject jSONObject2 = JSONObject.create();
        try {
            this.depJSONObject.put("para", (Object)jSONObject2);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = calculator.eval(stringArray[i]);
                if (object instanceof Date) {
                    object = GeneralUtils.objectToString((Object)object);
                }
                if (ComparatorUtils.equals((Object)object, (Object)Primitive.NULL)) continue;
                jSONObject2.put(stringArray[i].toUpperCase(), object);
            }
            jSONObject.put(this.widgetName.toUpperCase(), (Object)this.depJSONObject);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void toImage(Calculator calculator, Rectangle rectangle, Graphics graphics) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        BaseChartPainter baseChartPainter = this.chartCollection.createChartPainterJustTableDataAndDealFormual(calculator, n, n2);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n, (int)n2, (int)2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        baseChartPainter.paint((Graphics)graphics2D, n, n2, 96, Style.DEFAULT_STYLE);
        graphics2D.dispose();
        graphics.drawImage(bufferedImage, rectangle.x, rectangle.y, null);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("valueDependence", (Object)this.chartCollection.dependence((CalculatorProvider)calculator));
        jSONObject.put("dependPara", (Object)this.depJSONObject);
        jSONObject.put("sessionID", (Object)repository.getSessionID());
        jSONObject.put("plotType", (Object)this.chartCollection.getPlotType());
        if (nodeVisitor != null) {
            nodeVisitor.visit("simplechart", jSONObject);
        }
        return jSONObject;
    }

    public Object clone() throws CloneNotSupportedException {
        ChartEditor chartEditor = (ChartEditor)((Object)super.clone());
        if (this.chartCollection != null) {
            chartEditor.chartCollection = (BaseChartCollection)this.chartCollection.clone();
        }
        if (this.depJSONObject != null) {
            chartEditor.depJSONObject = new JSONObject(this.depJSONObject.toMap());
        }
        return chartEditor;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        this.chartCollection.writeXML(xMLPrintWriter);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        this.chartCollection.readXML(xMLableReader);
    }

    public boolean canCurrentMarginAvailable(PaddingMargin paddingMargin) {
        return true;
    }
}

