/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Base64;
import com.fr.base.BaseUtils;
import com.fr.base.MapXMLHelper;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartEnumDefinitions;
import com.fr.chart.base.ColorSelect4Shape;
import com.fr.chart.base.MapSvgAttr;
import com.fr.chart.base.MapSvgXMLHelper;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.BubblePlotGlyph;
import com.fr.chart.chartglyph.CategoryAxisGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Bubble;
import com.fr.chart.chartglyph.DataPoint4Map;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapShapeValue;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Device;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;

public class MapPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 1111932837975659038L;
    private static final double RADIUSSIZE = 5.0;
    private static final String DEFAULT_PATH = "./map";
    private String mapName = "";
    private MapChartData mapData;
    private boolean isSvgMap = true;
    private boolean isHeatMap = true;
    private int heatIndex = 0;
    private ChartEnumDefinitions.MapType mapType = ChartEnumDefinitions.MapType.Map_Normal;
    private BubblePlotGlyph bubblePlotGlyph;
    private PiePlotGlyph piePlotGlyph;
    private Bar2DPlotGlyph bar2DPlotGlyph;
    private double bubbleMax = -1.0;
    private double columnMax = -1.0;
    private HashMap pathMap = new HashMap();
    private MapHotAreaColor areaColors = new MapHotAreaColor();

    public void layoutAxisGlyph(int n) {
    }

    public void layoutDataSeriesGlyph(int n) {
        if (!this.shouldDrawMap()) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n2 = dataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                Object object;
                Object object2;
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (!ComparatorUtils.equals((String)dataPoint.getSeriesName(), (String)this.mapName)) continue;
                if (dataPoint.isValueIsNull()) {
                    object2 = null;
                    dataPoint.setDrawImpl((Glyph)object2);
                    object = null;
                    dataPoint.setDataLabel((TextGlyph)object);
                    continue;
                }
                if (this.isSvgMap) {
                    if (!this.isHeatMap) continue;
                    object2 = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
                    object = new GeneralPath(((MapSvgAttr)object2).getShapeValue(dataPoint.getCategoryOriginalName()));
                    ((Path2D.Float)object).transform(affineTransform);
                    dataPoint.setDrawImpl(this.createDrawGlyph(dataPoint, (Shape)object));
                    this.recalculateTextGlyphBounds(dataPoint, (Shape)object, n);
                    continue;
                }
                object2 = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
                object = ((MapAttr)object2).getShapeValue(dataPoint.getCategoryOriginalName());
                if (object == null) continue;
                Shape shape = this.createDataPointShape((MapShapeValue)object, (MapAttr)object2, affineTransform);
                dataPoint.setDrawImpl(this.createDrawGlyph(dataPoint, shape));
                this.recalculateTextGlyphBounds(dataPoint, shape, n);
            }
        }
        if (this.isSvgMap) {
            this.layoutShapeForEachDataPoint();
        }
    }

    private void layoutShapeForEachDataPoint() {
        AffineTransform affineTransform = this.getTransform();
        MapSvgAttr mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n = dataSeries.getDataPointCount();
            for (int j = 0; j < n; ++j) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(j);
                if (!ComparatorUtils.equals((String)dataPoint4Map.getSeriesName(), (String)this.mapName) || dataPoint4Map.getCombineGlyph() == null) continue;
                GeneralPath generalPath = new GeneralPath(mapSvgAttr.getShapeValue(dataPoint4Map.getCategoryOriginalName()));
                generalPath.transform(affineTransform);
                Rectangle2D rectangle2D = generalPath.getBounds2D();
                Object t = dataPoint4Map.getCombineGlyph().getPlotGlyph();
                double d = ((PlotGlyph)t).getCombinedSize();
                double d2 = rectangle2D.getCenterX() - d / 2.0;
                double d3 = rectangle2D.getCenterY() - d / 2.0;
                if (this.mapType == ChartEnumDefinitions.MapType.Map_Column) {
                    d3 = rectangle2D.getMaxY() - d;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d, d);
                dataPoint4Map.getCombineGlyph().setBounds(double_);
            }
        }
    }

    public void calculateMapTitlePercentValue() {
        int n;
        int n2;
        MapAreaValue mapAreaValue;
        DataPoint4Map dataPoint4Map;
        int n3;
        int n4;
        DataSeries dataSeries;
        int n5;
        double[] dArray = null;
        int n6 = this.getSeriesSize();
        for (n5 = 0; n5 < n6; ++n5) {
            dataSeries = this.getSeries(n5);
            n4 = dataSeries.getDataPointCount();
            for (n3 = 0; n3 < n4; ++n3) {
                dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(n3);
                if (dataPoint4Map.getAreaValue() == null) continue;
                mapAreaValue = dataPoint4Map.getAreaValue();
                n2 = 0;
                n = mapAreaValue.titleValueSize();
                while (n2 < n) {
                    if (dArray == null) {
                        dArray = new double[mapAreaValue.titleValueSize()];
                    }
                    double d = mapAreaValue.getTitleValueByIndex(n2);
                    int n7 = n2++;
                    dArray[n7] = dArray[n7] + d;
                }
            }
        }
        n6 = this.getSeriesSize();
        for (n5 = 0; n5 < n6; ++n5) {
            dataSeries = this.getSeries(n5);
            n4 = dataSeries.getDataPointCount();
            for (n3 = 0; n3 < n4; ++n3) {
                dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(n3);
                if (dataPoint4Map.getAreaValue() == null) continue;
                mapAreaValue = dataPoint4Map.getAreaValue();
                n = mapAreaValue.titleValueSize();
                for (n2 = 0; n2 < n; ++n2) {
                    MapTitleValue mapTitleValue = mapAreaValue.getTitleValue(n2);
                    mapTitleValue.setPercentValue(mapTitleValue.getValue() / dArray[n2]);
                }
            }
        }
    }

    public void calculateGlyphFromAreaValue() {
        if (this.isSvgMap) {
            for (int i = 0; i < this.getSeriesSize(); ++i) {
                DataSeries dataSeries = this.getSeries(i);
                int n = dataSeries.getDataPointCount();
                for (int j = 0; j < n; ++j) {
                    DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(j);
                    if (dataPoint4Map.getAreaValue() == null) continue;
                    ChartGlyph chartGlyph = this.getChartGlyph4DataPoint(dataPoint4Map);
                    dataPoint4Map.setCombineGlyph(chartGlyph);
                }
            }
            if (this.mapType == ChartEnumDefinitions.MapType.Map_Bubble) {
                this.calculateBubblePercentValue();
            }
        }
    }

    private void calculateBubblePercentValue() {
        int n;
        int n2;
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            n2 = dataSeries.getDataPointCount();
            for (n = 0; n < n2; ++n) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(n);
                ChartGlyph chartGlyph = dataPoint4Map.getCombineGlyph();
                if (chartGlyph == null || chartGlyph.getPlotGlyph() == null) continue;
                arrayList.add(((PlotGlyph)chartGlyph.getPlotGlyph()).getFirstDataPoint());
            }
        }
        double d = 0.0;
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            d += ((DataPoint)arrayList.get(n)).getValue();
        }
        for (n = 0; n < n2; ++n) {
            ((DataPoint)arrayList.get(n)).setPercentValue(((DataPoint)arrayList.get(n)).getValue() / d);
        }
    }

    private ChartGlyph getChartGlyph4DataPoint(DataPoint4Map dataPoint4Map) {
        PlotGlyph plotGlyph = null;
        double d = 50.0;
        switch (this.mapType) {
            case Map_Bubble: {
                plotGlyph = this.getPlotGlyph4Bubble(dataPoint4Map);
                d = this.bubblePlotGlyph.getCombinedSize();
                break;
            }
            case Map_Pie: {
                plotGlyph = this.getPlotGlyph4Pie(dataPoint4Map);
                d = this.piePlotGlyph.getCombinedSize();
                break;
            }
            case Map_Column: {
                plotGlyph = this.getPlotGlyph4Column(dataPoint4Map);
                d = this.bar2DPlotGlyph.getCombinedSize();
            }
        }
        if (plotGlyph != null) {
            plotGlyph.setCombinedSize(d);
            plotGlyph.calculateDataPointPercentValue();
            plotGlyph.setHotTooltipStyle(this.getHotTooltipStyle());
            plotGlyph.setHotHyperLink(this.getHotHyperLink());
            ChartGlyph chartGlyph = new ChartGlyph();
            chartGlyph.setPlotGlyph(plotGlyph);
            return chartGlyph;
        }
        return null;
    }

    private PlotGlyph getPlotGlyph4Bubble(DataPoint4Map dataPoint4Map) {
        int n;
        MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
        int n2 = mapAreaValue.titleValueSize();
        if (this.notEnoughTitleVale(n2)) {
            return null;
        }
        if (this.isHeatMap) {
            for (n = 0; n == this.heatIndex; ++n) {
            }
        }
        double d = this.getMaxValueForIndex(n);
        BubblePlotGlyph bubblePlotGlyph = new BubblePlotGlyph();
        bubblePlotGlyph.setCustomizedMaxValue(d);
        double d2 = mapAreaValue.getTitleValueByIndex(n);
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph();
        this.setEmptyAxisAttrs(valueAxisGlyph, 3, "xAxis");
        valueAxisGlyph.setMinMaxValue(0.0, d2 * 2.0);
        ValueAxisGlyph valueAxisGlyph2 = new ValueAxisGlyph();
        this.setEmptyAxisAttrs(valueAxisGlyph2, 2, "yAxis");
        valueAxisGlyph2.setMinMaxValue(0.0, d2 * 2.0);
        bubblePlotGlyph.setxAxisGlyph(valueAxisGlyph);
        bubblePlotGlyph.setyAxisGlyph(valueAxisGlyph2);
        DataPoint4Bubble dataPoint4Bubble = new DataPoint4Bubble();
        dataPoint4Bubble.setX(mapAreaValue.getTitleValueByIndex(n));
        dataPoint4Bubble.setValue(d2);
        dataPoint4Bubble.setSizeValue(mapAreaValue.getTitleValueByIndex(n));
        this.addSingleSeries(mapAreaValue, 0, n, bubblePlotGlyph, dataPoint4Map, dataPoint4Bubble);
        bubblePlotGlyph.setPlotFillStyle(this.bubblePlotGlyph.getPlotFillStyle());
        bubblePlotGlyph.setShowNegativeBubble(this.bubblePlotGlyph.isShowNegativeBubble());
        bubblePlotGlyph.setSeriesEqualsBubbleType(this.bubblePlotGlyph.getSeriesEqualsBubbleInWidthOrArea());
        bubblePlotGlyph.setMaxBubblePixel(this.bubblePlotGlyph.getMaxBubblePixel());
        return bubblePlotGlyph;
    }

    private PlotGlyph getPlotGlyph4Pie(DataPoint4Map dataPoint4Map) {
        MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
        int n = mapAreaValue.titleValueSize();
        if (this.notEnoughTitleVale(n)) {
            return null;
        }
        PiePlotGlyph piePlotGlyph = new PiePlotGlyph();
        int n2 = 0;
        int n3 = mapAreaValue.titleValueSize();
        for (int i = 0; i < n3; ++i) {
            if (this.isHeatMap && i == this.heatIndex) continue;
            DataPoint4Pie dataPoint4Pie = new DataPoint4Pie();
            this.addSingleSeries(mapAreaValue, n2, i, piePlotGlyph, dataPoint4Map, dataPoint4Pie);
            ++n2;
        }
        piePlotGlyph.setPlotFillStyle(this.piePlotGlyph.getPlotFillStyle());
        piePlotGlyph.setPlotStyle(this.piePlotGlyph.getPlotStyle());
        if (piePlotGlyph.getConditionCollection() != null) {
            ConditionAttr conditionAttr = piePlotGlyph.getConditionCollection().getDefaultAttr();
            conditionAttr.addDataSeriesCondition(new AttrAlpha(0.8f));
        }
        return piePlotGlyph;
    }

    private PlotGlyph getPlotGlyph4Column(DataPoint4Map dataPoint4Map) {
        MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
        int n = mapAreaValue.titleValueSize();
        if (this.notEnoughTitleVale(n)) {
            return null;
        }
        Bar2DPlotGlyph bar2DPlotGlyph = this.getSimplePlotGlyph();
        int n2 = 0;
        int n3 = mapAreaValue.titleValueSize();
        for (int i = 0; i < n3; ++i) {
            if (this.isHeatMap && i == this.heatIndex) continue;
            DataPoint dataPoint = new DataPoint();
            this.addSingleSeries(mapAreaValue, n2, i, bar2DPlotGlyph, dataPoint4Map, dataPoint);
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(dataPoint4Map.getCategoryOriginalName());
        ((CategoryAxisGlyph)bar2DPlotGlyph.getxAxisGlyph()).setCategoryLabelList(arrayList);
        bar2DPlotGlyph.getxAxisGlyph().setMinMaxValue(0.0, arrayList.size());
        bar2DPlotGlyph.setPlotFillStyle(this.bar2DPlotGlyph.getPlotFillStyle());
        bar2DPlotGlyph.setPlotStyle(this.bar2DPlotGlyph.getPlotStyle());
        if (bar2DPlotGlyph.getConditionCollection() != null) {
            ConditionAttr conditionAttr = bar2DPlotGlyph.getConditionCollection().getDefaultAttr();
            conditionAttr.addDataSeriesCondition(new AttrAlpha(0.8f));
        }
        return bar2DPlotGlyph;
    }

    private boolean notEnoughTitleVale(int n) {
        return n <= 0 || this.isHeatMap && n <= 1;
    }

    private void addSingleSeries(MapAreaValue mapAreaValue, int n, int n2, PlotGlyph plotGlyph, DataPoint4Map dataPoint4Map, DataPoint dataPoint) {
        MapTitleValue mapTitleValue = mapAreaValue.getTitleValue(n2);
        DataSeries<DataPoint> dataSeries = new DataSeries<DataPoint>(n);
        dataPoint.setSeriesIndex(n);
        dataPoint.setCategoryIndex(0);
        dataPoint.setCategoryName(dataPoint4Map.getCategoryOriginalName());
        dataPoint.setCategoryOriginalName(dataPoint4Map.getCategoryOriginalName());
        dataPoint.setSeriesName(mapTitleValue.getTitle());
        dataPoint.setValue(mapTitleValue.getValue());
        dataSeries.addDataPoint(dataPoint);
        plotGlyph.addSeries(dataSeries);
    }

    private double getMaxValueForIndex(int n) {
        if (this.bubbleMax > 0.0) {
            return this.bubbleMax;
        }
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n2 = dataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(j);
                if (!ComparatorUtils.equals((String)dataPoint4Map.getSeriesName(), (String)this.mapName) || dataPoint4Map.getAreaValue() == null) continue;
                double d = dataPoint4Map.getAreaValue().getTitleValueByIndex(n);
                this.bubbleMax = Math.max(this.bubbleMax, d);
            }
        }
        return this.bubbleMax;
    }

    private double getMaxValueOfAll() {
        if (this.columnMax > 0.0) {
            return this.columnMax;
        }
        int n = this.isHeatMap ? this.heatIndex : -1;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n2 = dataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(j);
                if (!ComparatorUtils.equals((String)dataPoint4Map.getSeriesName(), (String)this.mapName) || dataPoint4Map.getAreaValue() == null) continue;
                MapAreaValue mapAreaValue = dataPoint4Map.getAreaValue();
                int n3 = mapAreaValue.titleValueSize();
                for (int k = 0; k < n3; ++k) {
                    if (k == n) continue;
                    this.columnMax = Math.max(this.columnMax, mapAreaValue.getTitleValueByIndex(k));
                }
            }
        }
        return this.columnMax;
    }

    private Bar2DPlotGlyph getSimplePlotGlyph() {
        double d = this.getMaxValueOfAll();
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph();
        this.setEmptyAxisAttrs(valueAxisGlyph, 2, "xAxis");
        valueAxisGlyph.setMinMaxValue(0.0, d);
        CategoryAxisGlyph categoryAxisGlyph = new CategoryAxisGlyph();
        this.setEmptyAxisAttrs(categoryAxisGlyph, 3, "yAxis");
        Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
        bar2DPlotGlyph.setxAxisGlyph(categoryAxisGlyph);
        bar2DPlotGlyph.setyAxisGlyph(valueAxisGlyph);
        return bar2DPlotGlyph;
    }

    private void setEmptyAxisAttrs(AxisGlyph axisGlyph, int n, String string) {
        axisGlyph.setAxisType(string);
        axisGlyph.setPosition(n);
        axisGlyph.setShowAxisLabel(false);
        axisGlyph.setLineStyle(0);
        axisGlyph.setTickMarkType(0);
        axisGlyph.setSecTickMarkType(0);
        axisGlyph.setCustomMinValue(true);
        axisGlyph.setCustomMaxValue(true);
        axisGlyph.setCustomMainUnit(true);
        axisGlyph.setCustomSecUnit(true);
        axisGlyph.setMainUnit(new BigDecimal("1"));
        axisGlyph.setSecUnit(0.2);
    }

    private boolean shouldDrawMap() {
        MapAttr mapAttr;
        MapSvgAttr mapSvgAttr;
        return !(this.isSvgMap ? (mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName)) == null || mapSvgAttr.getMapImage() == null : (mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName)) == null || mapAttr.getMapImage() == null);
    }

    private Shape createDataPointShape(MapShapeValue mapShapeValue, MapAttr mapAttr, AffineTransform affineTransform) {
        Image image = mapAttr.getMapImage();
        Point[] pointArray = mapShapeValue.getShape();
        int n = mapShapeValue.getMarkType();
        GeneralPath generalPath = new GeneralPath();
        ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
        colorSelect4Shape.makesureImage(image);
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            if (n == 0) {
                generalPath.moveTo((float)point.getX(), (float)point.getY());
                double d = 5.0;
                double d2 = point.getX() - d;
                double d3 = point.getY() - d;
                generalPath.append(new Arc2D.Double(d2, d3, d * 2.0, d * 2.0, 0.0, 360.0, 0), false);
                continue;
            }
            colorSelect4Shape.makesureClickPoint(point.getX(), point.getY());
            GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
            generalPath.append(generalPath2, false);
        }
        return generalPath.createTransformedShape(affineTransform);
    }

    private Image getMapImage() {
        if (this.isSvgMap) {
            MapSvgAttr mapSvgAttr = MapSvgXMLHelper.getInstance().getMapAttr(this.mapName);
            if (mapSvgAttr != null) {
                return mapSvgAttr.getMapImage();
            }
        } else {
            MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
            if (mapAttr != null) {
                return mapAttr.getMapImage();
            }
        }
        return null;
    }

    private AffineTransform getTransform() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Image image = this.getMapImage();
        if (image == null) {
            return new AffineTransform();
        }
        double_.setFrame(0.0, 0.0, image.getWidth(new JPanel()), image.getHeight(new JPanel()));
        Rectangle2D.Double double_2 = double_;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        double d = ((RectangularShape)double_3).getWidth() / ((RectangularShape)double_2).getWidth();
        double d2 = ((RectangularShape)double_3).getHeight() / ((RectangularShape)double_2).getHeight();
        d = d2 = Math.min(d, d2);
        double d3 = ((RectangularShape)double_3).getX() - d * ((RectangularShape)double_2).getX();
        double d4 = ((RectangularShape)double_3).getY() - d2 * ((RectangularShape)double_2).getY();
        if (d * ((RectangularShape)double_2).getWidth() < ((RectangularShape)double_3).getWidth()) {
            d3 += (((RectangularShape)double_3).getWidth() - d * ((RectangularShape)double_2).getWidth()) / 2.0;
        }
        if (d2 * ((RectangularShape)double_2).getHeight() < ((RectangularShape)double_3).getHeight()) {
            d4 += (((RectangularShape)double_3).getHeight() - d2 * ((RectangularShape)double_2).getHeight()) / 2.0;
        }
        return new AffineTransform(d, 0.0, 0.0, d2, d3, d4);
    }

    public void setAreaColors(MapHotAreaColor mapHotAreaColor) {
        this.areaColors = mapHotAreaColor;
    }

    public MapHotAreaColor getAreaColors() {
        return this.areaColors;
    }

    private Glyph createDrawGlyph(DataPoint dataPoint, Shape shape) {
        ShapeGlyph shapeGlyph = new ShapeGlyph();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            shape = new Arc2D.Double(rectangle2D.getX() - 2.0, rectangle2D.getY() - 2.0, 4.0, 4.0, 0.0, 360.0, 0);
        }
        shapeGlyph.setShape(shape);
        AttrBackground attrBackground = this.getConditionCollection().getAttrByResult(dataPoint).getExisted(AttrBackground.class);
        if (attrBackground != null) {
            shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
        } else if (this.areaColors != null) {
            Color color = this.areaColors.getColorWithValue(dataPoint.getValue());
            if (!dataPoint.isValueIsNull()) {
                shapeGlyph.setBackground((Background)ColorBackground.getInstance((Color)color));
            }
        }
        return shapeGlyph;
    }

    private void recalculateTextGlyphBounds(DataPoint dataPoint, Shape shape, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph != null) {
            Dimension2D dimension2D = textGlyph.preferredDimension(n);
            Rectangle2D rectangle2D = shape.getBounds2D();
            double d = dimension2D.getWidth();
            double d2 = dimension2D.getHeight();
            double d3 = rectangle2D.getCenterX() - d / 2.0;
            double d4 = rectangle2D.getCenterY() - d2 / 2.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3 + 2.0, d4 + 2.0, d - 2.0, d2 - 3.0);
            textGlyph.setBounds(double_);
        }
    }

    public String getPlotGlyphType() {
        return "MapPlotGlyph";
    }

    public void setMapName(String string) {
        this.mapName = string;
    }

    public void setSvgMap(boolean bl) {
        this.isSvgMap = bl;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapData(MapChartData mapChartData) {
        this.mapData = mapChartData;
    }

    public void setPathMap(HashMap hashMap) {
        this.pathMap = hashMap;
    }

    public void setHeatMap(boolean bl) {
        this.isHeatMap = bl;
    }

    public boolean isHeatMap() {
        return this.isHeatMap;
    }

    public boolean isSvgMap() {
        return this.isSvgMap;
    }

    public void setHeatIndex(int n) {
        this.heatIndex = n;
    }

    public void setMapType(ChartEnumDefinitions.MapType mapType) {
        this.mapType = mapType;
    }

    public ChartEnumDefinitions.MapType getMapType() {
        return this.mapType;
    }

    public void setBubblePlotGlyph(BubblePlotGlyph bubblePlotGlyph) {
        this.bubblePlotGlyph = bubblePlotGlyph;
    }

    public void setPiePlotGlyph(PiePlotGlyph piePlotGlyph) {
        this.piePlotGlyph = piePlotGlyph;
    }

    public void setBar2DPlotGlyph(Bar2DPlotGlyph bar2DPlotGlyph) {
        this.bar2DPlotGlyph = bar2DPlotGlyph;
    }

    public void draw(Graphics graphics, int n) {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawBackgroundWithShapes(graphics2D);
        int n3 = this.getSeriesSize();
        for (n2 = 0; n2 < n3; ++n2) {
            this.getSeries(n2).draw(graphics, n);
        }
        if (this.mapType != ChartEnumDefinitions.MapType.Map_Column) {
            n3 = this.getSeriesSize();
            for (n2 = 0; n2 < n3; ++n2) {
                DataSeries dataSeries = this.getSeries(n2);
                int n4 = dataSeries.getDataPointCount();
                for (int i = 0; i < n4; ++i) {
                    DataPoint4Map dataPoint4Map = (DataPoint4Map)dataSeries.getDataPoint(i);
                    dataPoint4Map.drawCombine(graphics, n);
                }
            }
        }
        n3 = this.getSeriesSize();
        for (n2 = 0; n2 < n3; ++n2) {
            this.getSeries(n2).drawLabel(graphics, n);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawBackgroundWithShapes(Graphics2D graphics2D) {
        Image image = this.getMapImage();
        if (image != null) {
            Rectangle2D rectangle2D = this.getBounds();
            int n = (int)rectangle2D.getWidth();
            int n2 = (int)rectangle2D.getHeight();
            if (n <= 0 || n2 <= 0) {
                return;
            }
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            for (int i = 0; i < n; i += n) {
                for (int j = 0 % n2; j < n2; j += n2) {
                    double d = (double)n / (double)n3;
                    double d2 = (double)n2 / (double)n4;
                    int n5 = n;
                    int n6 = n2;
                    if (d > d2) {
                        n5 = (int)((double)n * d2 / d);
                        i = (n - n5) / 2;
                    } else {
                        n6 = (int)((double)n2 * d / d2);
                        j = (n2 - n6) / 2 + j;
                    }
                    graphics2D.drawImage(image, i, j, n5, n6, null);
                }
            }
        }
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isSvgMap", this.isSvgMap);
        jSONObject.put("mapAreaColor", (Object)this.getAreaColors().toJSONObject());
        jSONObject.put("mapName", (Object)this.mapName);
        if (!this.isSvgMap) {
            this.bitMapToJson(jSONObject, repository);
        }
        jSONObject.put("isHeatMap", this.isHeatMap);
        jSONObject.put("heatIndex", this.heatIndex);
        jSONObject.put("mapType", this.mapType.ordinal());
        return jSONObject;
    }

    private void bitMapToJson(JSONObject jSONObject, Repository repository) throws JSONException {
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(this.mapName);
        if (mapAttr != null) {
            jSONObject.put("versionid", mapAttr.getVersionID());
        }
        if (!repository.getDevice().isMobile()) {
            this.putMapReturnButtonToJS(jSONObject, repository);
            this.pathMap.clear();
            HashMap<String, Dimension> hashMap = new HashMap<String, Dimension>();
            HashMap<String, Image> hashMap2 = new HashMap<String, Image>();
            ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
            if (mapAttr != null) {
                Image image = mapAttr.getMapImage();
                int n = image.getWidth(new JPanel());
                int n2 = image.getHeight(new JPanel());
                if (!colorSelect4Shape.hasLoadedImage(image)) {
                    colorSelect4Shape.makesureImage(image);
                }
                hashMap2.put(this.mapName, image);
                hashMap.put(this.mapName, new Dimension(n, n2));
                Iterator iterator = mapAttr.shapeValuesIterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
                    GeneralPath generalPath = this.createPathWithPoints(mapShapeValue, colorSelect4Shape);
                    this.pathMap.put(string, generalPath);
                }
            }
            if (!this.pathMap.isEmpty()) {
                jSONObject.put("pathMap", (Object)MapPlotGlyph.pathMap2JSONArray(mapAttr, this.pathMap));
            }
            this.putImageBounds4JS(hashMap, hashMap2, jSONObject, repository);
        }
    }

    private void putImageBounds4JS(HashMap hashMap, HashMap hashMap2, JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object k : hashMap.keySet()) {
            Dimension dimension = (Dimension)hashMap.get(k);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("mapName", k);
            jSONObject2.put("mapWidth", dimension.getWidth());
            jSONObject2.put("mapHeight", dimension.getHeight());
            Image image = (Image)hashMap2.get(k);
            if (repository.getDevice().isMobile()) {
                jSONObject2.put("img", (Object)Base64.encode((Image)image, (String)"png"));
            } else if (repository.getBrowser().isIE()) {
                jSONObject2.put("onie", (Object)ChartBaseUtils.addImageAsEmb(image));
            } else {
                jSONObject2.put("onsrc", (Object)("data:image/png;base64," + Base64.encode((Image)image, (String)"png")));
            }
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("imageBounds", (Object)jSONArray);
    }

    private void putMapReturnButtonToJS(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.getSeriesSize() > 1) {
            BufferedImage bufferedImage = BaseUtils.readImage((String)"com/fr/chart/base/mapNormal.png");
            if (repository.getDevice().isMobile()) {
                jSONObject.put("bimg", (Object)Base64.encode((Image)bufferedImage, (String)"png"));
            } else if (repository.getBrowser().isIE()) {
                jSONObject.put("normalIEsrc", (Object)ChartBaseUtils.addImageAsEmb(bufferedImage));
            } else {
                jSONObject.put("normalsrc", (Object)("data:image/png;base64," + Base64.encode((Image)bufferedImage, (String)"png")));
            }
        }
    }

    private GeneralPath createPathWithPoints(MapShapeValue mapShapeValue, ColorSelect4Shape colorSelect4Shape) {
        Point[] pointArray = mapShapeValue.getShape();
        GeneralPath generalPath = new GeneralPath();
        if (mapShapeValue.getMarkType() == 0) {
            for (int i = 0; i < pointArray.length; ++i) {
                generalPath.moveTo((float)pointArray[i].getX(), (float)pointArray[i].getY());
                double d = 5.0;
                double d2 = pointArray[i].getX() - d;
                double d3 = pointArray[i].getY() - d;
                generalPath.append(new Arc2D.Double(d2, d3, d * 2.0, d * 2.0, 0.0, 360.0, 0), false);
            }
        } else {
            for (int i = 0; i < pointArray.length; ++i) {
                colorSelect4Shape.makesureClickPoint(pointArray[i].getX(), pointArray[i].getY());
                GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
                generalPath.append(generalPath2, false);
            }
        }
        return generalPath;
    }

    public boolean equals(Object object) {
        return object instanceof MapPlotGlyph && super.equals(object);
    }

    public static void putPathMap2Json(Device device, MapAttr mapAttr, HashMap hashMap, JSONObject jSONObject) throws JSONException {
        if (device.isAndroid()) {
            jSONObject.put("pathMap", (Object)MapPlotGlyph.pathMap2JSONArray(mapAttr, hashMap));
        } else {
            jSONObject.put("pathMap", (Object)MapPlotGlyph.pathMap2JSONArray(mapAttr, hashMap));
        }
    }

    public static void putPathMap2Json(Device device, MapSvgAttr mapSvgAttr, HashMap hashMap, JSONObject jSONObject) throws JSONException {
        jSONObject.put("pathMap", (Object)MapPlotGlyph.pathMap2JSONArray(mapSvgAttr, hashMap));
    }

    private static String pathMap2String4Android(MapAttr mapAttr, HashMap hashMap) throws JSONException {
        String string = "";
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = Utils.objectToString(iterator.next());
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string2);
            GeneralPath generalPath = (GeneralPath)hashMap.get(string2);
            string = string + string2 + "_ms_";
            string = string + ChartBaseUtils.generalPath2Android(generalPath) + "_ms_";
            string = string + mapShapeValue.getMarkType() + "_op_";
        }
        return string;
    }

    private static JSONArray pathMap2JSONArray(MapAttr mapAttr, HashMap hashMap) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
            GeneralPath generalPath = (GeneralPath)hashMap.get(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", (Object)string);
            jSONObject.put("path", (Object)ChartBaseUtils.generalPath2JS(generalPath));
            jSONObject.put("markType", mapShapeValue.getMarkType());
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    private static JSONArray pathMap2JSONArray(MapSvgAttr mapSvgAttr, HashMap hashMap) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            GeneralPath generalPath = (GeneralPath)hashMap.get(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", (Object)string);
            jSONObject.put("path", (Object)ChartBaseUtils.generalPath2JS(generalPath));
            jSONObject.put("markType", 1);
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public DataPoint4Map getCurrentMapDataPoint() {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n = dataSeries.getDataPointCount();
            for (int j = 0; j < n; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (!ComparatorUtils.equals((String)dataPoint.getSeriesName(), (String)this.mapName) || dataPoint.isValueIsNull()) continue;
                return (DataPoint4Map)dataPoint;
            }
        }
        return null;
    }

    public int getAdditionalCanvasCount() {
        int n = 0;
        n += this.mapType != ChartEnumDefinitions.MapType.Map_Normal ? 1 : 0;
        return n += this.isSvgMap && this.isHeatMap ? 1 : 0;
    }

    public String getChartType() {
        return "Map";
    }
}

