/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Utils;
import com.fr.chart.base.ChartConstants;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AxisHelper {
    private static Map unit = null;
    private static final double BAI = 100.0;
    private static final double SHI = 10.0;
    private static final int FIVE = 5;
    private static final int EIGHT = 8;
    private static final int SIX = 6;
    private static final int SEVEN = 7;

    public static double getDivideUnit(String string) {
        if (unit == null) {
            unit = new HashMap();
            unit.put(ChartConstants.UNIT_I18N_KEYS[0], new Double(1.0));
            double d = 100.0;
            for (int i = 1; i < ChartConstants.UNIT_I18N_KEYS.length; ++i) {
                unit.put(ChartConstants.UNIT_I18N_KEYS[i], new Double(d));
                d *= 10.0;
            }
            unit.put("10000", new Double(10000.0));
            unit.put("100000", new Double(100000.0));
            unit.put("10000000", new Double(1.0E7));
            unit.put("100000000", new Double(1.0E8));
        }
        if (unit.containsKey(string)) {
            return (Double)unit.get(string);
        }
        return Utils.string2Number((String)string).doubleValue();
    }

    public static BigDecimal calculateIncrement(double d, double d2) {
        if (d >= d2) {
            return new BigDecimal("1");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d2 - d));
        if (bigDecimal.doubleValue() == 1.0) {
            return new BigDecimal("0.2");
        }
        double d3 = AxisHelper.getMoveInt(bigDecimal);
        BigDecimal bigDecimal2 = AxisHelper.getBaseWithMoveInt(d3);
        int n = (int)((d2 - d) / bigDecimal2.doubleValue());
        if (n == 2 || n == 1) {
            return bigDecimal2.multiply(new BigDecimal("0.5"));
        }
        if (n >= 3 && n <= 5) {
            return bigDecimal2;
        }
        if (n >= 6 && n <= 7) {
            return bigDecimal2.multiply(new BigDecimal("2"));
        }
        if (n >= 8) {
            return bigDecimal2.multiply(new BigDecimal("3"));
        }
        return bigDecimal;
    }

    public static double calIncreWithTickNumber(double d, double d2, int n) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d2 - d));
        double d3 = AxisHelper.getMoveInt(bigDecimal);
        BigDecimal bigDecimal2 = AxisHelper.getBaseWithMoveInt(d3);
        int n2 = (int)((d2 - d) / bigDecimal2.doubleValue());
        double d4 = bigDecimal2.doubleValue() * (double)n2 / (double)n;
        return d4 * 2.0;
    }

    public static double getMoveInt(BigDecimal bigDecimal) {
        double d;
        block3: {
            block2: {
                d = 0.0;
                if (!(bigDecimal.doubleValue() > 0.0) || !(bigDecimal.doubleValue() < 1.0)) break block2;
                while (bigDecimal.doubleValue() < 1.0) {
                    bigDecimal = bigDecimal.multiply(new BigDecimal("10"));
                    d -= 1.0;
                }
                break block3;
            }
            if (!(bigDecimal.doubleValue() >= 10.0)) break block3;
            while (bigDecimal.doubleValue() >= 10.0) {
                bigDecimal = bigDecimal.movePointLeft(1);
                d += 1.0;
            }
        }
        return d;
    }

    private static BigDecimal getBaseWithMoveInt(double d) {
        BigDecimal bigDecimal;
        block3: {
            block2: {
                bigDecimal = new BigDecimal("1");
                if (!(d > 0.0)) break block2;
                int n = 0;
                while ((double)n < d) {
                    bigDecimal = bigDecimal.multiply(new BigDecimal("10"));
                    ++n;
                }
                break block3;
            }
            if (!(d < 0.0)) break block3;
            int n = 0;
            while ((double)n > d) {
                bigDecimal = bigDecimal.movePointLeft(1);
                --n;
            }
        }
        return bigDecimal;
    }
}

