/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.ChartSummaryColumn;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartdata.NormalTableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.util.function.DataFunction;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MoreNameCDDefinition
extends NormalTableDataDefinition {
    private static final long serialVersionUID = 2020690082058297818L;
    public static final String XML_TAG = "MoreNameCDDefinition";
    private ChartSummaryColumn[] chartSummaryColumn;

    public MoreNameCDDefinition() {
    }

    public MoreNameCDDefinition(TableData tableData, String string, ChartSummaryColumn[] chartSummaryColumnArray) {
        this.setTableData(tableData);
        this.setCategoryName(string);
        this.setChartSummaryColumn(chartSummaryColumnArray);
    }

    public ChartData createChartData(DataModel dataModel, DataProcessor dataProcessor) {
        NormalChartData normalChartData = null;
        ArrayList arrayList = new ArrayList();
        try {
            this.initAllCateLabels(dataModel, dataProcessor);
            int[] nArray = this.createSeriesNameArray(dataModel);
            Object[] objectArray = this.createSeriesNamesArray();
            int n = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)this.getCategoryName());
            if (n == -1) {
                this.whenOneCate(dataModel, arrayList, nArray);
            } else {
                this.add2Value2DList(dataModel, objectArray, nArray, arrayList);
            }
            Object[][] objectArray2 = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
            normalChartData = this.getNormalChartData(objectArray, objectArray2);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().error(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        return normalChartData;
    }

    protected NormalChartData getNormalChartData(Object[] objectArray, Object[][] objectArray2) {
        NormalChartData normalChartData = new NormalChartData(this.categoryLabels, objectArray, objectArray2);
        normalChartData.setSecondCates(this.secondLabels);
        normalChartData.setThirdCates(this.thirdLabels);
        return normalChartData;
    }

    protected String[] createSeriesNamesArray() {
        String[] stringArray = new String[this.chartSummaryColumn.length];
        for (int i = 0; i < this.chartSummaryColumn.length; ++i) {
            stringArray[i] = this.chartSummaryColumn[i].getCustomName() != null ? this.chartSummaryColumn[i].getCustomName() : this.chartSummaryColumn[i].getName();
        }
        return stringArray;
    }

    private void whenOneCate(DataModel dataModel, List list, int[] nArray) throws TableDataException {
        int n = dataModel.getRowCount();
        if (this.categoryLabels != null && this.categoryLabels.length == 1) {
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                DataFunction dataFunction = this.chartSummaryColumn[i].getFunction();
                for (int j = 0; j < n; ++j) {
                    dataFunction.addData(dataModel.getValueAt(j, nArray[i]));
                }
                list.add(new Object[]{dataFunction.getResult()});
                dataFunction.reset();
            }
        }
    }

    private void add2Value2DList(DataModel dataModel, Object[] objectArray, int[] nArray, List list) throws TableDataException {
        HashMap hashMap = new HashMap();
        Object object = new Object();
        this.addValuesInValueList(dataModel, objectArray, nArray, hashMap, object);
        ArrayList<Object> arrayList = null;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            DataFunction dataFunction = this.chartSummaryColumn[i].getFunction();
            arrayList = new ArrayList<Object>();
            Map map = (Map)hashMap.get(objectArray[i] == null ? object : objectArray[i]);
            if (map != null) {
                int n2 = this.categoryLabels.length;
                for (int j = 0; j < n2; ++j) {
                    List list2 = (List)map.get(new Integer(j));
                    if (list2 != null && !list2.isEmpty()) {
                        int n3 = 0;
                        int n4 = list2.size();
                        for (int k = 0; k < n4; ++k) {
                            if (list2.get(k) == null) {
                                ++n3;
                            }
                            dataFunction.addData(list2.get(k));
                        }
                        arrayList.add(n3 == list2.size() ? null : dataFunction.getResult());
                    } else {
                        arrayList.add(null);
                    }
                    dataFunction.reset();
                }
            }
            list.add(arrayList.toArray());
        }
    }

    private void addValuesInValueList(DataModel dataModel, Object[] objectArray, int[] nArray, Map map, Object object) throws TableDataException {
        for (int i = 0; i < this.chartSummaryColumn.length; ++i) {
            int n = nArray[i];
            int n2 = dataModel.getRowCount();
            for (int j = 0; j < n2; ++j) {
                int n3;
                ArrayList<Object> arrayList;
                HashMap<Integer, ArrayList<Object>> hashMap;
                Object object2 = objectArray[i];
                if (object2 == null) {
                    object2 = object;
                }
                if ((hashMap = (HashMap<Integer, ArrayList<Object>>)map.get(object2)) == null) {
                    hashMap = new HashMap<Integer, ArrayList<Object>>();
                    map.put(object2, hashMap);
                }
                if ((arrayList = (ArrayList<Object>)hashMap.get(new Integer(n3 = this.getCategoryIndex(dataModel, j)))) == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(new Integer(n3), arrayList);
                }
                arrayList.add(dataModel.getValueAt(j, n));
            }
        }
    }

    protected int[] createSeriesNameArray(DataModel dataModel) throws TableDataException {
        int n;
        int[] nArray = new int[this.chartSummaryColumn.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        int n2 = this.chartSummaryColumn.length;
        block1: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < dataModel.getColumnCount(); ++i) {
                if (!ComparatorUtils.tableDataColumnNameEquals((String)this.chartSummaryColumn[n].getName(), (String)dataModel.getColumnName(i))) continue;
                nArray[n] = i;
                continue block1;
            }
        }
        return nArray;
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        if (this.chartSummaryColumn != null) {
            JSONArray jSONArray = new JSONArray();
            for (ChartSummaryColumn chartSummaryColumn : this.chartSummaryColumn) {
                jSONArray.put((Object)chartSummaryColumn.toJSONObject());
            }
            jSONObject.put("summaryColumns", (Object)jSONArray);
        }
        return jSONObject;
    }

    public String getDataDefinitionType() {
        return "MutiColumnDefinition";
    }

    public void setChartSummaryColumn(ChartSummaryColumn[] chartSummaryColumnArray) {
        this.chartSummaryColumn = chartSummaryColumnArray;
    }

    public ChartSummaryColumn[] getChartSummaryColumn() {
        return this.chartSummaryColumn;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.chartSummaryColumn != null) {
            for (int i = 0; i < this.chartSummaryColumn.length; ++i) {
                this.chartSummaryColumn[i].writeXML(xMLPrintWriter);
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("ChartSummaryColumn")) {
            ChartSummaryColumn chartSummaryColumn = (ChartSummaryColumn)xMLableReader.readXMLObject((XMLReadable)new ChartSummaryColumn());
            if (this.chartSummaryColumn == null) {
                this.chartSummaryColumn = new ChartSummaryColumn[]{chartSummaryColumn};
            } else {
                ChartSummaryColumn[] chartSummaryColumnArray = this.chartSummaryColumn;
                this.chartSummaryColumn = new ChartSummaryColumn[chartSummaryColumnArray.length + 1];
                System.arraycopy(chartSummaryColumnArray, 0, this.chartSummaryColumn, 0, chartSummaryColumnArray.length);
                this.chartSummaryColumn[chartSummaryColumnArray.length] = chartSummaryColumn;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MoreNameCDDefinition moreNameCDDefinition = (MoreNameCDDefinition)super.clone();
        if (this.chartSummaryColumn != null) {
            ChartSummaryColumn[] chartSummaryColumnArray = new ChartSummaryColumn[this.chartSummaryColumn.length];
            for (int i = 0; i < this.chartSummaryColumn.length; ++i) {
                chartSummaryColumnArray[i] = (ChartSummaryColumn)this.chartSummaryColumn[i].clone();
            }
            moreNameCDDefinition.setChartSummaryColumn(chartSummaryColumnArray);
        }
        return moreNameCDDefinition;
    }

    public boolean equals(Object object) {
        return object instanceof MoreNameCDDefinition && ComparatorUtils.equals((Object[])((MoreNameCDDefinition)object).chartSummaryColumn, (Object[])this.chartSummaryColumn) && super.equals(object);
    }
}

