/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.filter.GaussianBlur;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class GaussianBlur3D
implements PlugIn {
    private static double xsigma = 2.0;
    private static double ysigma = 2.0;
    private static double zsigma = 2.0;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp.isComposite() && imp.getNChannels() == imp.getStackSize()) {
            IJ.error("3D Gaussian Blur", "Composite color images not supported");
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        imp.startTiming();
        GaussianBlur3D.blur(imp, xsigma, ysigma, zsigma);
        IJ.showTime(imp, imp.getStartTime(), "", imp.getStackSize());
    }

    private boolean showDialog() {
        GenericDialog gd = new GenericDialog("3D Gaussian Blur");
        gd.addNumericField("X sigma:", xsigma, 1);
        gd.addNumericField("Y sigma:", ysigma, 1);
        gd.addNumericField("Z sigma:", zsigma, 1);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        xsigma = gd.getNextNumber();
        ysigma = gd.getNextNumber();
        zsigma = gd.getNextNumber();
        return true;
    }

    public static void blur(ImagePlus imp, double sigmaX, double sigmaY, double sigmaZ) {
        imp.deleteRoi();
        ImageStack stack = imp.getStack();
        if (sigmaX > 0.0 || sigmaY > 0.0) {
            GaussianBlur gb = new GaussianBlur();
            int channels = stack.getProcessor(1).getNChannels();
            gb.setNPasses(channels * imp.getStackSize());
            int i = 1;
            while (i <= imp.getStackSize()) {
                ImageProcessor ip = stack.getProcessor(i);
                double accuracy = imp.getBitDepth() == 8 || imp.getBitDepth() == 24 ? 0.002 : 2.0E-4;
                gb.blurGaussian(ip, sigmaX, sigmaY, accuracy);
                ++i;
            }
        }
        if (sigmaZ > 0.0) {
            if (imp.isHyperStack()) {
                GaussianBlur3D.blurHyperStackZ(imp, sigmaZ);
            } else {
                GaussianBlur3D.blurZ(stack, sigmaZ);
            }
            imp.updateAndDraw();
        }
    }

    private static void blurZ(ImageStack stack, double sigmaZ) {
        GaussianBlur gb = new GaussianBlur();
        double accuracy = stack.getBitDepth() == 8 || stack.getBitDepth() == 24 ? 0.002 : 2.0E-4;
        int w = stack.getWidth();
        int h = stack.getHeight();
        int d = stack.getSize();
        float[] zpixels = null;
        FloatProcessor fp = null;
        IJ.showStatus("Z blurring");
        gb.showProgress(false);
        int channels = stack.getProcessor(1).getNChannels();
        int y = 0;
        while (y < h) {
            IJ.showProgress(y, h - 1);
            int channel = 0;
            while (channel < channels) {
                zpixels = stack.getVoxels(0, y, 0, w, 1, d, zpixels, channel);
                if (fp == null) {
                    fp = new FloatProcessor(w, d, zpixels);
                }
                gb.blur1Direction(fp, sigmaZ, accuracy, false, 0);
                stack.setVoxels(0, y, 0, w, 1, d, zpixels, channel);
                ++channel;
            }
            ++y;
        }
        IJ.showStatus("");
    }

    private static void blurHyperStackZ(ImagePlus imp, double zsigma) {
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int timePoints = imp.getNFrames();
        int nVolumes = channels * timePoints;
        int c = 1;
        while (c <= channels) {
            if (slices == 1) {
                ImageStack stack = GaussianBlur3D.getVolume(imp, c, 1);
                GaussianBlur3D.blurZ(stack, zsigma);
            } else {
                int t = 1;
                while (t <= timePoints) {
                    ImageStack stack = GaussianBlur3D.getVolume(imp, c, t);
                    GaussianBlur3D.blurZ(stack, zsigma);
                    ++t;
                }
            }
            ++c;
        }
    }

    private static ImageStack getVolume(ImagePlus imp, int c, int t) {
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(imp.getWidth(), imp.getHeight());
        if (imp.getNSlices() == 1) {
            t = 1;
            while (t <= imp.getNFrames()) {
                int n = imp.getStackIndex(c, 1, t);
                stack2.addSlice(stack1.getProcessor(n));
                ++t;
            }
        } else {
            int z = 1;
            while (z <= imp.getNSlices()) {
                int n = imp.getStackIndex(c, z, t);
                stack2.addSlice(stack1.getProcessor(n));
                ++z;
            }
        }
        return stack2;
    }
}

