/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class FITS_Reader
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open FITS...", arg);
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + directory + fileName);
        FitsDecoder fd = new FitsDecoder(directory, fileName);
        FileInfo fi = null;
        try {
            fi = fd.getInfo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            if (fi.nImages == 1) {
                ImageProcessor ip = imp.getProcessor();
                ip.flipVertical();
                this.setProcessor(fileName, ip);
            } else {
                ImageStack stack = imp.getStack();
                int i = 1;
                while (i <= stack.getSize()) {
                    stack.getProcessor(i).flipVertical();
                    ++i;
                }
                this.setStack(fileName, stack);
            }
            Calibration cal = imp.getCalibration();
            if (fi.fileType == 1 && fd.bscale == 1.0 && fd.bzero == 32768.0) {
                cal.setFunction(20, null, "Gray Value");
            }
            this.setCalibration(cal);
            this.setProperty("Info", fd.getHeaderInfo());
            this.setFileInfo(fi);
            if (arg.equals("")) {
                this.show();
            }
        } else {
            IJ.error("This does not appear to be a FITS file.");
        }
        IJ.showStatus("");
    }
}

