/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class CommandFinder
implements PlugIn,
ActionListener,
WindowListener,
KeyListener,
ItemListener,
MouseListener {
    private static final int TABLE_WIDTH = 640;
    private static final int TABLE_ROWS = 18;
    private int multiClickInterval;
    private long lastClickTime;
    private static JFrame frame;
    private JTextField prompt;
    private JScrollPane scrollPane;
    private JButton runButton;
    private JButton sourceButton;
    private JButton closeButton;
    private JCheckBox closeCheckBox;
    private Hashtable commandsHash;
    private String[] commands;
    private static boolean closeWhenRunning;
    private JTable table;
    private TableModel tableModel;
    private int lastClickedRow;

    static {
        closeWhenRunning = Prefs.get("command-finder.close", false);
    }

    public CommandFinder() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer interval = (Integer)toolkit.getDesktopProperty("awt.multiClickInterval");
        this.multiClickInterval = interval == null ? 300 : interval;
    }

    protected String[] makeRow(String command, CommandAction ca) {
        String jarFile;
        String[] result = new String[this.tableModel.getColumnCount()];
        result[0] = command;
        if (ca.menuLocation != null) {
            result[1] = ca.menuLocation;
        }
        if (ca.classCommand != null) {
            result[2] = ca.classCommand;
        }
        if ((jarFile = Menus.getJarFileForMenuEntry(command)) != null) {
            result[3] = jarFile;
        }
        return result;
    }

    protected void populateList(String matchingSubstring) {
        String substring = matchingSubstring.toLowerCase();
        ArrayList<String[]> list = new ArrayList<String[]>();
        boolean count = false;
        int i = 0;
        while (i < this.commands.length) {
            String commandName = this.commands[i];
            String command = commandName.toLowerCase();
            CommandAction ca = (CommandAction)this.commandsHash.get(commandName);
            String menuPath = ca.menuLocation;
            if (menuPath == null) {
                menuPath = "";
            }
            menuPath = menuPath.toLowerCase();
            if (command.indexOf(substring) >= 0 || menuPath.indexOf(substring) >= 0) {
                String[] row = this.makeRow(commandName, ca);
                list.add(row);
            }
            ++i;
        }
        this.tableModel.setData(list);
        this.prompt.requestFocus();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.runButton) {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                this.error("Please select a command to run");
                return;
            }
            this.runCommand(this.tableModel.getCommand(row));
        } else if (source == this.sourceButton) {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                this.error("Please select a command");
                return;
            }
            this.showSource(this.tableModel.getCommand(row));
        } else if (source == this.closeButton) {
            this.closeWindow();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        this.populateList(this.prompt.getText());
    }

    public void mouseClicked(MouseEvent e) {
        long now = System.currentTimeMillis();
        int row = this.table.getSelectedRow();
        long thisClickInterval = now - this.lastClickTime;
        if (thisClickInterval < (long)this.multiClickInterval && row >= 0 && this.lastClickedRow >= 0 && row == this.lastClickedRow) {
            this.runCommand(this.tableModel.getCommand(row));
        }
        this.lastClickTime = now;
        this.lastClickedRow = row;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    void showSource(String cmd) {
        int openParen;
        Hashtable table = Menus.getCommands();
        String className = (String)table.get(cmd);
        if (IJ.debugMode) {
            IJ.log("showSource: " + cmd + "   " + className);
        }
        if (className == null) {
            this.error("No source associated with this command:\n  " + cmd);
            return;
        }
        int mstart = className.indexOf("ij.plugin.Macro_Runner(\"");
        if (mstart >= 0) {
            int mend = className.indexOf("\")");
            if (mend == -1) {
                return;
            }
            String macro = className.substring(mstart + 24, mend);
            IJ.open(String.valueOf(IJ.getDirectory("plugins")) + macro);
            return;
        }
        if (className.endsWith("\")") && (openParen = className.lastIndexOf("(\"")) > 0) {
            className = className.substring(0, openParen);
        }
        if (className.startsWith("ij.")) {
            className = className.replaceAll("\\.", "/");
            IJ.runPlugIn("ij.plugin.BrowserLauncher", "http://imagej.nih.gov/ij/source/" + className + ".java");
            return;
        }
        className = String.valueOf(IJ.getDirectory("plugins")) + className.replaceAll("\\.", "/");
        String path = String.valueOf(className) + ".java";
        File f = new File(path);
        if (f.exists()) {
            IJ.open(path);
            return;
        }
        this.error("Unable to display source for this plugin:\n  " + className);
    }

    private void error(String msg) {
        IJ.error("Command Finder", msg);
    }

    protected void runCommand(String command) {
        IJ.showStatus("Running command " + command);
        IJ.doCommand(command);
        closeWhenRunning = this.closeCheckBox.isSelected();
        if (closeWhenRunning) {
            this.closeWindow();
        }
    }

    public void keyPressed(KeyEvent ke) {
        boolean meta;
        int key = ke.getKeyCode();
        int flags = ke.getModifiers();
        int items = this.tableModel.getRowCount();
        Object source = ke.getSource();
        boolean bl = meta = (flags & 4) != 0 || (flags & 2) != 0;
        if (key == 27 || key == 87 && meta) {
            this.closeWindow();
        } else if (source == this.prompt) {
            if (key == 10 && 1 == items) {
                this.runCommand(this.tableModel.getCommand(0));
            }
            int index = -1;
            if (key == 38) {
                index = this.table.getSelectedRow() - 1;
                if (index < 0) {
                    index = items - 1;
                }
            } else if (key == 40 && (index = this.table.getSelectedRow() + 1) >= items) {
                index = Math.min(items - 1, 0);
            }
            if (index >= 0) {
                this.table.requestFocus();
                this.table.setRowSelectionInterval(index, index);
            }
        } else if (key == 8) {
            this.prompt.requestFocus();
        } else if (source == this.table && key == 10) {
            ke.consume();
            int row = this.table.getSelectedRow();
            if (row >= 0) {
                this.runCommand(this.tableModel.getCommand(row));
            }
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void parseMenu(String path, Menu menu) {
        int n = menu.getItemCount();
        int i = 0;
        while (i < n) {
            MenuItem m = menu.getItem(i);
            String label = m.getLabel();
            if (m instanceof Menu) {
                Menu subMenu = (Menu)m;
                this.parseMenu(String.valueOf(path) + ">" + label, subMenu);
            } else {
                String trimmedLabel = label.trim();
                if (trimmedLabel.length() != 0 && !trimmedLabel.equals("-")) {
                    CommandAction ca = (CommandAction)this.commandsHash.get(label);
                    if (ca == null) {
                        this.commandsHash.put(label, new CommandAction(null, m, path));
                    } else {
                        ca.menuItem = m;
                        ca.menuLocation = path;
                    }
                    CommandAction commandAction = (CommandAction)this.commandsHash.get(label);
                }
            }
            ++i;
        }
    }

    public void findAllMenuItems() {
        MenuBar menuBar = Menus.getMenuBar();
        int topLevelMenus = menuBar.getMenuCount();
        int i = 0;
        while (i < topLevelMenus) {
            Menu topLevelMenu = menuBar.getMenu(i);
            this.parseMenu(topLevelMenu.getLabel(), topLevelMenu);
            ++i;
        }
    }

    public void run(String ignored) {
        Image img;
        if (frame != null) {
            WindowManager.toFront(frame);
            return;
        }
        this.commandsHash = new Hashtable();
        Hashtable realCommandsHash = (Hashtable)Menus.getCommands().clone();
        Set realCommandSet = realCommandsHash.keySet();
        Iterator i = realCommandSet.iterator();
        while (i.hasNext()) {
            String command = (String)i.next();
            String trimmedCommand = command.trim();
            if (trimmedCommand.length() <= 0 || trimmedCommand.equals("-")) continue;
            this.commandsHash.put(command, new CommandAction((String)realCommandsHash.get(command), null, null));
        }
        this.findAllMenuItems();
        this.commands = this.commandsHash.keySet().toArray(new String[0]);
        Arrays.sort(this.commands);
        ImageJ imageJ = IJ.getInstance();
        frame = new JFrame("Command Finder"){

            public void setVisible(boolean visible) {
                if (visible) {
                    WindowManager.addWindow(this);
                }
                super.setVisible(visible);
            }

            public void dispose() {
                WindowManager.removeWindow(this);
                Prefs.set("command-finder.close", closeWhenRunning);
                frame = null;
                super.dispose();
            }
        };
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        frame.addWindowListener(this);
        if (imageJ != null && !IJ.isMacOSX() && (img = imageJ.getIconImage()) != null) {
            try {
                frame.setIconImage(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeCheckBox = new JCheckBox("Close window after running command", closeWhenRunning);
        this.closeCheckBox.addItemListener(this);
        JPanel northPanel = new JPanel();
        northPanel.add(new JLabel("Search:"));
        this.prompt = new JTextField("", 20);
        this.prompt.getDocument().addDocumentListener(new PromptDocumentListener());
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        contentPane.add((Component)northPanel, "North");
        this.tableModel = new TableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.tableModel.setColumnWidths(this.table.getColumnModel());
        Dimension dim = new Dimension(640, this.table.getRowHeight() * 18);
        this.table.setPreferredScrollableViewportSize(dim);
        this.table.addKeyListener(this);
        this.table.addMouseListener(this);
        this.scrollPane = new JScrollPane(this.table);
        this.populateList("");
        contentPane.add((Component)this.scrollPane, "Center");
        this.runButton = new JButton("Run");
        this.sourceButton = new JButton("Source");
        this.closeButton = new JButton("Close");
        this.runButton.addActionListener(this);
        this.sourceButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.runButton.addKeyListener(this);
        this.sourceButton.addKeyListener(this);
        this.closeButton.addKeyListener(this);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.closeCheckBox);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.runButton);
        buttonsPanel.add(this.sourceButton);
        buttonsPanel.add(this.closeButton);
        southPanel.add((Component)optionsPanel, "Center");
        southPanel.add((Component)buttonsPanel, "South");
        contentPane.add((Component)southPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.pack();
        int dialogWidth = frame.getWidth();
        int dialogHeight = frame.getHeight();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        Point pos = imageJ.getLocationOnScreen();
        Dimension size = imageJ.getSize();
        int initialX = (int)pos.getX() + 10;
        int initialY = (int)pos.getY() + size.height + 10;
        if (initialX + dialogWidth > screenWidth) {
            initialX = screenWidth - dialogWidth;
        }
        if (initialX < 0) {
            initialX = 0;
        }
        if (initialY + dialogHeight > screenHeight) {
            initialY = screenHeight - dialogHeight;
        }
        if (initialY < 0) {
            initialY = 0;
        }
        frame.setLocation(initialX, initialY);
        frame.setVisible(true);
        frame.toFront();
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }

    private void closeWindow() {
        frame.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    class CommandAction {
        String classCommand;
        MenuItem menuItem;
        String menuLocation;

        CommandAction(String classCommand, MenuItem menuItem, String menuLocation) {
            this.classCommand = classCommand;
            this.menuItem = menuItem;
            this.menuLocation = menuLocation;
        }

        public String toString() {
            return "classCommand: " + this.classCommand + ", menuItem: " + this.menuItem + ", menuLocation: " + this.menuLocation;
        }
    }

    class PromptDocumentListener
    implements DocumentListener {
        PromptDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        public void removeUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        public void changedUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }
    }

    private class TableModel
    extends AbstractTableModel {
        protected ArrayList list = new ArrayList();
        public static final int COLUMNS = 4;

        public void setData(ArrayList list) {
            this.list = list;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Command";
                }
                case 1: {
                    return "Menu Path";
                }
                case 2: {
                    return "Class";
                }
                case 3: {
                    return "File";
                }
            }
            return null;
        }

        public int getRowCount() {
            return this.list.size();
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.list.size() || column >= 4) {
                return null;
            }
            String[] strings = (String[])this.list.get(row);
            return strings[column];
        }

        public String getCommand(int row) {
            if (row < 0 || row >= this.list.size()) {
                return "";
            }
            return (String)this.getValueAt(row, 0);
        }

        public void setColumnWidths(TableColumnModel columnModel) {
            int[] widths = new int[]{170, 150, 170, 30};
            int i = 0;
            while (i < widths.length) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
                ++i;
            }
        }
    }
}

