/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula.functions;

import com.fr.third.v2.org.apache.poi.ss.formula.TwoDEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.EvaluationException;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.OperandResolver;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ValueEval;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.LookupUtils;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public final class Lookup
extends Var2or3ArgFunction {
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        throw new RuntimeException("Two arg version of LOOKUP not supported yet");
    }

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        try {
            ValueEval lookupValue = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
            TwoDEval aeLookupVector = LookupUtils.resolveTableArrayArg(arg1);
            TwoDEval aeResultVector = LookupUtils.resolveTableArrayArg(arg2);
            LookupUtils.ValueVector lookupVector = Lookup.createVector(aeLookupVector);
            LookupUtils.ValueVector resultVector = Lookup.createVector(aeResultVector);
            if (lookupVector.getSize() > resultVector.getSize()) {
                throw new RuntimeException("Lookup vector and result vector of differing sizes not supported yet");
            }
            int index = LookupUtils.lookupIndexOfValue(lookupValue, lookupVector, true);
            return resultVector.getItem(index);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static LookupUtils.ValueVector createVector(TwoDEval ae) {
        LookupUtils.ValueVector result = LookupUtils.createVector(ae);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("non-vector lookup or result areas not supported yet");
    }
}

