/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.draw.geom;

import com.fr.third.v2.org.apache.poi.sl.draw.binding.CTCustomGeometry2D;
import com.fr.third.v2.org.apache.poi.sl.draw.binding.CTGeomGuide;
import com.fr.third.v2.org.apache.poi.sl.draw.binding.CTGeomGuideList;
import com.fr.third.v2.org.apache.poi.sl.draw.binding.CTGeomRect;
import com.fr.third.v2.org.apache.poi.sl.draw.binding.CTPath2D;
import com.fr.third.v2.org.apache.poi.sl.draw.binding.CTPath2DList;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.AdjustValue;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.ClosePathCommand;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.Guide;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.LineToCommand;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.MoveToCommand;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomGeometry
implements Iterable<Path> {
    List<Guide> adjusts = new ArrayList<Guide>();
    List<Guide> guides = new ArrayList<Guide>();
    List<Path> paths = new ArrayList<Path>();
    Path textBounds;

    public CustomGeometry(CTCustomGeometry2D geom) {
        CTGeomRect cTGeomRect;
        CTPath2DList cTPath2DList;
        CTGeomGuideList gdLst;
        CTGeomGuideList avLst = geom.getAvLst();
        if (avLst != null) {
            for (CTGeomGuide cTGeomGuide : avLst.getGd()) {
                this.adjusts.add(new AdjustValue(cTGeomGuide));
            }
        }
        if ((gdLst = geom.getGdLst()) != null) {
            for (CTGeomGuide cTGeomGuide : gdLst.getGd()) {
                this.guides.add(new Guide(cTGeomGuide));
            }
        }
        if ((cTPath2DList = geom.getPathLst()) != null) {
            for (CTPath2D spPath : cTPath2DList.getPath()) {
                this.paths.add(new Path(spPath));
            }
        }
        if ((cTGeomRect = geom.getRect()) != null) {
            this.textBounds = new Path();
            this.textBounds.addCommand(new MoveToCommand(cTGeomRect.getL().toString(), cTGeomRect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(cTGeomRect.getR().toString(), cTGeomRect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(cTGeomRect.getR().toString(), cTGeomRect.getB().toString()));
            this.textBounds.addCommand(new LineToCommand(cTGeomRect.getL().toString(), cTGeomRect.getB().toString()));
            this.textBounds.addCommand(new ClosePathCommand());
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    public Path getTextBounds() {
        return this.textBounds;
    }
}

