/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.draw;

import com.fr.third.v2.org.apache.poi.sl.draw.Drawable;
import com.fr.third.v2.org.apache.poi.sl.usermodel.PlaceableShape;
import com.fr.third.v2.org.apache.poi.sl.usermodel.Shape;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawShape
implements Drawable {
    protected final Shape<?, ?> shape;

    public DrawShape(Shape<?, ?> shape) {
        this.shape = shape;
    }

    @Override
    public void applyTransform(Graphics2D graphics) {
        if (!(this.shape instanceof PlaceableShape)) {
            return;
        }
        PlaceableShape ps = (PlaceableShape)((Object)this.shape);
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx == null) {
            tx = new AffineTransform();
        }
        Rectangle2D anchor = tx.createTransformedShape(ps.getAnchor()).getBounds2D();
        double rotation = ps.getRotation();
        if (rotation != 0.0) {
            double centerX = anchor.getCenterX();
            double centerY = anchor.getCenterY();
            if ((rotation %= 360.0) < 0.0) {
                rotation += 360.0;
            }
            int quadrant = ((int)rotation + 45) / 90 % 4;
            double scaleX = 1.0;
            double scaleY = 1.0;
            if (quadrant == 1 || quadrant == 3) {
                AffineTransform txs;
                if (ps.getClass().getCanonicalName().toLowerCase(Locale.ROOT).contains("hslf")) {
                    txs = new AffineTransform(tx);
                } else {
                    txs = new AffineTransform();
                    txs.translate(centerX, centerY);
                    txs.rotate(1.5707963267948966);
                    txs.translate(-centerX, -centerY);
                    txs.concatenate(tx);
                }
                txs.translate(centerX, centerY);
                txs.rotate(1.5707963267948966);
                txs.translate(-centerX, -centerY);
                Rectangle2D anchor2 = txs.createTransformedShape(ps.getAnchor()).getBounds2D();
                scaleX = DrawShape.safeScale(anchor.getWidth(), anchor2.getWidth());
                scaleY = DrawShape.safeScale(anchor.getHeight(), anchor2.getHeight());
            } else {
                quadrant = 0;
            }
            graphics.translate(centerX, centerY);
            double rot = Math.toRadians(rotation - (double)quadrant * 90.0);
            if (rot != 0.0) {
                graphics.rotate(rot);
            }
            graphics.scale(scaleX, scaleY);
            rot = Math.toRadians(quadrant * 90);
            if (rot != 0.0) {
                graphics.rotate(rot);
            }
            graphics.translate(-centerX, -centerY);
        }
        if (ps.getFlipHorizontal()) {
            graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
            graphics.scale(-1.0, 1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        if (ps.getFlipVertical()) {
            graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
            graphics.scale(1.0, -1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
    }

    private static double safeScale(double dim1, double dim2) {
        if (dim1 == 0.0) {
            return 1.0;
        }
        return dim2 == 0.0 ? 1.0 : dim1 / dim2;
    }

    @Override
    public void draw(Graphics2D graphics) {
    }

    @Override
    public void drawContent(Graphics2D graphics) {
    }

    public static Rectangle2D getAnchor(Graphics2D graphics, PlaceableShape<?, ?> shape) {
        return DrawShape.getAnchor(graphics, shape.getAnchor());
    }

    public static Rectangle2D getAnchor(Graphics2D graphics, Rectangle2D anchor) {
        if (graphics == null) {
            return anchor;
        }
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx != null) {
            anchor = tx.createTransformedShape(anchor).getBounds2D();
        }
        return anchor;
    }

    protected Shape<?, ?> getShape() {
        return this.shape;
    }
}

