/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;

public class Radians
extends NumericFunction {
    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        double d = 0.0;
        ErrorEval retval = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    NumericValueEval ne = (NumericValueEval)ve;
                    d = ne.getNumberValue();
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.NUM_ERROR;
            }
        }
        if (retval == null) {
            retval = Double.isNaN(d = Math.toRadians(d)) || Double.isInfinite(d) ? ErrorEval.VALUE_INVALID : new NumberEval(d);
        }
        return retval;
    }
}

