/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.Location;
import com.fr.third.javax.xml.stream.PropertyManager;
import com.fr.third.javax.xml.stream.XMLErrorReporter;
import com.fr.third.javax.xml.stream.XMLReporter;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.xerces.impl.msg.XMLMessageFormatter;
import com.fr.third.javax.xml.stream.xerces.util.MessageFormatter;
import com.fr.third.javax.xml.stream.xerces.xni.XMLLocator;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;

public class StaxErrorReporter
extends XMLErrorReporter {
    protected XMLReporter fXMLReporter = null;

    public StaxErrorReporter(PropertyManager propertyManager) {
        this.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", new XMLMessageFormatter());
        this.reset(propertyManager);
    }

    public StaxErrorReporter() {
        this.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", new XMLMessageFormatter());
    }

    public void reset(PropertyManager propertyManager) {
        this.fXMLReporter = (XMLReporter)propertyManager.getProperty("com.fr.third.javax.xml.stream.reporter");
    }

    public void reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
        String message;
        MessageFormatter messageFormatter = this.getMessageFormatter(domain);
        if (messageFormatter != null) {
            message = messageFormatter.formatMessage(this.fLocale, key, arguments);
        } else {
            int argCount;
            StringBuffer str = new StringBuffer();
            str.append(domain);
            str.append('#');
            str.append(key);
            int n = argCount = arguments != null ? arguments.length : 0;
            if (argCount > 0) {
                str.append('?');
                int i = 0;
                while (i < argCount) {
                    str.append(arguments[i]);
                    if (i < argCount - 1) {
                        str.append('&');
                    }
                    ++i;
                }
            }
            message = str.toString();
        }
        switch (severity) {
            case 0: {
                try {
                    if (this.fXMLReporter != null) {
                        this.fXMLReporter.report(message, "WARNING", null, this.convertToStaxLocation(location));
                    }
                }
                catch (XMLStreamException ex) {
                    throw new XNIException(ex);
                }
            }
            case 1: {
                try {
                    if (this.fXMLReporter != null) {
                        this.fXMLReporter.report(message, "ERROR", null, this.convertToStaxLocation(location));
                    }
                }
                catch (XMLStreamException ex) {
                    throw new XNIException(ex);
                }
            }
            case 2: {
                if (this.fContinueAfterFatalError) break;
                throw new XNIException(message);
            }
        }
    }

    Location convertToStaxLocation(final XMLLocator location) {
        return new Location(){

            public int getColumnNumber() {
                return location.getColumnNumber();
            }

            public int getLineNumber() {
                return location.getLineNumber();
            }

            public String getPublicId() {
                return location.getPublicId();
            }

            public String getSystemId() {
                return location.getLiteralSystemId();
            }

            public int getCharacterOffset() {
                return location.getCharacterOffset();
            }
        };
    }
}

