/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.io.font.FontMetrics;
import com.fr.third.fr.pdf.io.font.TrueTypeFont;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.font.otf.GlyphLine;
import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.font.PdfType0Font;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.canvas.CanvasArtifact;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagTreePointer;
import com.fr.third.fr.pdf.layout.element.Text;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutContext;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.layout.TextLayoutResult;
import com.fr.third.fr.pdf.layout.property.FontKerning;
import com.fr.third.fr.pdf.layout.property.Underline;
import com.fr.third.fr.pdf.layout.renderer.AbstractRenderer;
import com.fr.third.fr.pdf.layout.renderer.AccessibleAttributesApplier;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.TypographyUtils;
import com.fr.third.fr.pdf.layout.splitting.DefaultSplitCharacters;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRenderer
extends AbstractRenderer {
    protected static final float TEXT_SPACE_COEFF = 1000.0f;
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final float BOLD_SIMULATION_STROKE_COEFF = 0.05f;
    private static final float TYPO_ASCENDER_SCALE_COEFF = 1.2f;
    protected float yLineOffset;
    protected GlyphLine text;
    protected GlyphLine line;
    protected String strToBeConverted;
    protected boolean otfFeaturesApplied = false;
    protected float tabAnchorCharacterPosition = -1.0f;
    private static Float DefaultLayoutPosition = Float.valueOf(1.0f);

    public TextRenderer(Text textElement) {
        this(textElement, textElement.getText());
    }

    public TextRenderer(Text textElement, String text) {
        super(textElement);
        this.strToBeConverted = text;
    }

    protected TextRenderer(TextRenderer other) {
        super(other);
        this.text = other.text;
        this.line = other.line;
        this.strToBeConverted = other.strToBeConverted;
        this.otfFeaturesApplied = other.otfFeaturesApplied;
        this.tabAnchorCharacterPosition = other.tabAnchorCharacterPosition;
    }

    public static boolean isPunctuation(GlyphLine text, int glyphPos) {
        return TextRenderer.isPunctuation(text.get(glyphPos));
    }

    public static boolean isPunctuation(Glyph c) {
        if (c == null) {
            return false;
        }
        char[] cs = c.getChars();
        if (cs == null || cs.length == 0) {
            return false;
        }
        int type = Character.getType(cs[0]);
        return type == 24 || type == 20 || type == 21 || type == 22 || type == 23;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        float descender;
        float ascender;
        this.convertWaitingStringToGlyphLine();
        LayoutArea area = layoutContext.getArea();
        Rectangle layoutBox = area.getBBox().clone();
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), 0.0f, 0.0f));
        boolean anythingPlaced = false;
        int currentTextPos = this.text.start;
        float fontSize = this.getFontSize();
        float textRise = 0.0f;
        float characterSpacing = 0.0f;
        float wordSpacing = 0.0f;
        PdfFont font = this.getPdfFont();
        float hScale = 1.0f;
        DefaultSplitCharacters splitCharacters = new DefaultSplitCharacters();
        float italicSkewAddition = this.isITALIC() ? 0.21256f * fontSize : 0.0f;
        float boldSimulationAddition = this.isBold() ? 0.05f * fontSize : 0.0f;
        this.line = new GlyphLine(this.text);
        this.line.end = -1;
        this.line.start = -1;
        FontMetrics fontMetrics = font.getFontProgram().getFontMetrics();
        if (fontMetrics.getWinAscender() == 0 || fontMetrics.getWinDescender() == 0 || fontMetrics.getTypoAscender() == fontMetrics.getWinAscender() && fontMetrics.getTypoDescender() == fontMetrics.getWinDescender()) {
            ascender = (float)fontMetrics.getTypoAscender() * 1.2f;
            descender = (float)fontMetrics.getTypoDescender() * 1.2f;
        } else {
            ascender = fontMetrics.getWinAscender();
            descender = fontMetrics.getWinDescender();
        }
        float currentLineAscender = 0.0f;
        float currentLineDescender = 0.0f;
        float currentLineHeight = 0.0f;
        int initialLineTextPos = currentTextPos;
        float currentLineWidth = 0.0f;
        int previousCharPos = -1;
        Character tabAnchorCharacter = null;
        LayoutResult result = null;
        boolean isSplitForcedByImmediateNewLine = false;
        boolean isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol = false;
        while (currentTextPos < this.text.end) {
            if (TextRenderer.noPrint(this.text.get(currentTextPos))) {
                ++currentTextPos;
                continue;
            }
            int nonBreakablePartEnd = this.text.end - 1;
            float nonBreakablePartFullWidth = 0.0f;
            float nonBreakablePartWidthWhichDoesNotExceedAllowedWidth = 0.0f;
            float nonBreakablePartMaxAscender = 0.0f;
            float nonBreakablePartMaxDescender = 0.0f;
            float nonBreakablePartMaxHeight = 0.0f;
            int firstCharacterWhichExceedsAllowedWidth = -1;
            for (int ind = currentTextPos; ind < this.text.end; ++ind) {
                boolean isLast;
                float xAdvance;
                if (this.isNewLine(this.text, ind)) {
                    isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol = true;
                    firstCharacterWhichExceedsAllowedWidth = ind + 1;
                    if (this.text.start != currentTextPos) break;
                    isSplitForcedByImmediateNewLine = true;
                    isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol = false;
                    break;
                }
                Glyph currentGlyph = this.text.get(ind);
                if (TextRenderer.noPrint(currentGlyph)) continue;
                if (tabAnchorCharacter != null && tabAnchorCharacter.charValue() == this.text.get(ind).getUnicode().intValue()) {
                    this.tabAnchorCharacterPosition = currentLineWidth + nonBreakablePartFullWidth;
                    tabAnchorCharacter = null;
                }
                float glyphWidth = this.getCharWidth(currentGlyph, fontSize, hScale, characterSpacing, wordSpacing) / 1000.0f;
                float f = xAdvance = previousCharPos != -1 ? (float)this.text.get(previousCharPos).getXAdvance() : 0.0f;
                if (xAdvance != 0.0f) {
                    xAdvance = this.scaleXAdvance(xAdvance, fontSize, hScale) / 1000.0f;
                }
                if (nonBreakablePartFullWidth + glyphWidth + xAdvance + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() - currentLineWidth && firstCharacterWhichExceedsAllowedWidth == -1) {
                    firstCharacterWhichExceedsAllowedWidth = ind;
                }
                if (firstCharacterWhichExceedsAllowedWidth == -1) {
                    nonBreakablePartWidthWhichDoesNotExceedAllowedWidth += glyphWidth + xAdvance;
                }
                nonBreakablePartMaxAscender = Math.max(nonBreakablePartMaxAscender, ascender);
                nonBreakablePartMaxDescender = Math.min(nonBreakablePartMaxDescender, descender);
                nonBreakablePartMaxHeight = (nonBreakablePartMaxAscender - nonBreakablePartMaxDescender) * fontSize / 1000.0f + textRise;
                previousCharPos = ind;
                if ((nonBreakablePartFullWidth += glyphWidth + xAdvance) + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth()) break;
                boolean bl = isLast = ind + 1 == this.text.end;
                if (!isLast && TextRenderer.isPunctuation(this.text, ind + 1) || !splitCharacters.isSplitCharacter(this.text, ind) && !isLast && !splitCharacters.isSplitCharacter(this.text, ind + 1)) continue;
                nonBreakablePartEnd = ind;
                break;
            }
            if (firstCharacterWhichExceedsAllowedWidth == -1) {
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                this.line.end = Math.max(this.line.end, nonBreakablePartEnd + 1);
                currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                currentTextPos = nonBreakablePartEnd + 1;
                currentLineWidth += nonBreakablePartFullWidth;
                anythingPlaced = true;
                continue;
            }
            boolean wordSplit = false;
            if (nonBreakablePartFullWidth + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() && !anythingPlaced || isSplitForcedByImmediateNewLine) {
                wordSplit = true;
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                currentTextPos = firstCharacterWhichExceedsAllowedWidth;
                this.line.end = Math.max(this.line.end, firstCharacterWhichExceedsAllowedWidth);
                if (nonBreakablePartFullWidth + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() && !anythingPlaced) {
                    currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                    currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                    currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                    currentLineWidth += nonBreakablePartWidthWhichDoesNotExceedAllowedWidth;
                } else {
                    currentLineAscender = ascender;
                    currentLineDescender = descender;
                    currentLineHeight = (currentLineAscender - currentLineDescender) * fontSize / 1000.0f + textRise;
                    currentLineWidth += this.getCharWidth(this.line.get(0), fontSize, hScale, characterSpacing, wordSpacing) / 1000.0f;
                }
            }
            if (this.line.end <= 0) {
                result = new TextLayoutResult(3, this.occupiedArea, null, this);
                break;
            }
            result = new TextLayoutResult(2, this.occupiedArea, null, null).setWordHasBeenSplit(wordSplit);
            break;
        }
        if (result != null && result.getStatus() == 3) {
            return result;
        }
        this.yLineOffset = currentLineAscender * fontSize / 1000.0f;
        this.occupiedArea.getBBox().moveDown(currentLineHeight);
        this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + currentLineHeight);
        this.occupiedArea.getBBox().setWidth(Math.max(this.occupiedArea.getBBox().getWidth(), currentLineWidth));
        layoutBox.setHeight(area.getBBox().getHeight() - currentLineHeight);
        this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() + italicSkewAddition + boldSimulationAddition);
        if (result != null) {
            TextRenderer[] split = isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol ? this.split(currentTextPos + 1) : this.split(currentTextPos);
            if (isSplitForcedByNewLineAndWeNeedToIgnoreNewLineSymbol) {
                ((TextLayoutResult)result).setSplitForcedByNewline(true);
            }
            result.setSplitRenderer(split[0]);
            if (split[1].text.start != split[1].text.end) {
                result.setOverflowRenderer(split[1]);
            }
        } else {
            result = new TextLayoutResult(1, this.occupiedArea, null, null);
        }
        return result;
    }

    public void applyOtf() {
        this.convertWaitingStringToGlyphLine();
        FontKerning fontKerning = FontKerning.NO;
        PdfFont font = this.getPdfFont();
        if (!this.otfFeaturesApplied) {
            if (fontKerning == FontKerning.YES) {
                TypographyUtils.applyKerning(font.getFontProgram(), this.text);
            }
            this.otfFeaturesApplied = true;
        }
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
    }

    @Override
    public void draw(DrawContext drawContext) {
        super.draw(drawContext);
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean isArtifact = false;
        TagTreePointer tagPointer = null;
        IAccessibleElement accessibleElement = null;
        if (isTagged) {
            accessibleElement = (IAccessibleElement)((Object)this.getModelElement());
            PdfName role = accessibleElement.getRole();
            if (role != null && !PdfName.Artifact.equals(role)) {
                tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
                if (!tagPointer.isElementConnectedToTag(accessibleElement)) {
                    AccessibleAttributesApplier.applyLayoutAttributes(accessibleElement.getRole(), this, document);
                }
                tagPointer.addTag(accessibleElement, true);
            } else {
                isTagged = false;
                if (PdfName.Artifact.equals(role)) {
                    isArtifact = true;
                }
            }
        }
        float leftBBoxX = this.occupiedArea.getBBox().getX();
        if (this.line.end > this.line.start) {
            Object underlines;
            PdfFont font = this.getPdfFont();
            float fontSize = this.getFontSize();
            Color fontColor = this.getFontColor();
            int textRenderingMode = 0;
            Object skew = null;
            boolean italicSimulation = this.isITALIC();
            boolean boldSimulation = this.isBold();
            float strokeWidth = 0.0f;
            if (boldSimulation) {
                textRenderingMode = 2;
                strokeWidth = fontSize / 20.0f;
            }
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag(tagPointer.getTagReference());
            } else if (isArtifact) {
                canvas.openTag(new CanvasArtifact());
            }
            canvas.saveState().beginText().setFontAndSize(font, fontSize);
            if (skew != null && (skew).length == 2) {
                canvas.setTextMatrix(1.0f, (float)skew[0], (float)skew[1], 1.0f, leftBBoxX, this.getYLine());
            } else if (italicSimulation) {
                canvas.setTextMatrix(1.0f, 0.0f, 0.21256f, 1.0f, leftBBoxX, this.getYLine());
            } else {
                canvas.moveText(leftBBoxX, this.getYLine());
            }
            if (textRenderingMode != 0) {
                canvas.setTextRenderingMode(textRenderingMode);
            }
            if (textRenderingMode == 1 || textRenderingMode == 2) {
                Color strokeColor;
                if (strokeWidth == 0.0f) {
                    strokeWidth = this.getPropertyAsFloat(64);
                }
                if (strokeWidth != 0.0f && strokeWidth != 1.0f) {
                    canvas.setLineWidth(strokeWidth);
                }
                if ((strokeColor = this.getRenderStrokeColor()) == null) {
                    strokeColor = fontColor;
                }
                if (strokeColor != null) {
                    canvas.setStrokeColor(strokeColor);
                }
            }
            if (fontColor != null) {
                canvas.setFillColor(fontColor);
            }
            GlyphLine.IGlyphLineFilter filter = new GlyphLine.IGlyphLineFilter(){

                public boolean accept(Glyph glyph) {
                    return !TextRenderer.noPrint(glyph);
                }
            };
            canvas.showText(this.line.filter(filter));
            canvas.endText().restoreState();
            if (isTagged || isArtifact) {
                canvas.closeTag();
            }
            if ((underlines = this.getUnderLine()) instanceof List) {
                for (Object underline : (List)underlines) {
                    if (!(underline instanceof Underline)) continue;
                    this.drawSingleUnderline((Underline)underline, fontColor, canvas, fontSize, italicSimulation ? 0.21256f : 0.0f);
                }
            } else if (underlines instanceof Underline) {
                this.drawSingleUnderline((Underline)underlines, fontColor, canvas, fontSize, italicSimulation ? 0.21256f : 0.0f);
            }
        }
        if (isTagged) {
            tagPointer.moveToParent();
            if (this.isLastRendererForModelElement) {
                tagPointer.removeElementConnectionToTag(accessibleElement);
            }
        }
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 29: {
                return (T1)DefaultLayoutPosition;
            }
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        switch (property) {
            case 29: {
                return 1.0f;
            }
        }
        return super.getDefaultFloatProperty(property);
    }

    public void trimFirst() {
    }

    public float trimLast() {
        Glyph currentGlyph;
        int firstNonSpaceCharIndex;
        float trimmedSpace = 0.0f;
        if (this.line.end <= 0) {
            return trimmedSpace;
        }
        float fontSize = this.getFontSize();
        float characterSpacing = 0.0f;
        float wordSpacing = 0.0f;
        float hScale = 0.0f;
        for (firstNonSpaceCharIndex = this.line.end - 1; firstNonSpaceCharIndex >= this.line.start && (currentGlyph = this.line.get(firstNonSpaceCharIndex)).hasValidUnicode() && Character.isWhitespace(currentGlyph.getUnicode()); --firstNonSpaceCharIndex) {
            float currentCharWidth = this.getCharWidth(currentGlyph, fontSize, hScale, characterSpacing, wordSpacing) / 1000.0f;
            float xAdvance = firstNonSpaceCharIndex > this.line.start ? this.scaleXAdvance(this.line.get(firstNonSpaceCharIndex - 1).getXAdvance(), fontSize, hScale) / 1000.0f : 0.0f;
            trimmedSpace += currentCharWidth - xAdvance;
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - currentCharWidth);
        }
        this.line.end = firstNonSpaceCharIndex + 1;
        return trimmedSpace;
    }

    public float getAscent() {
        return this.yLineOffset;
    }

    public float getDescent() {
        return -(this.occupiedArea.getBBox().getHeight() - this.yLineOffset);
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.yLineOffset;
    }

    public void moveYLineTo(float y) {
        float curYLine = this.getYLine();
        float delta = y - curYLine;
        this.occupiedArea.getBBox().setY(this.occupiedArea.getBBox().getY() + delta);
    }

    public void setText(String text) {
        GlyphLine glyphLine = this.convertToGlyphLine(text);
        this.setText(glyphLine, glyphLine.start, glyphLine.end);
    }

    public void setText(GlyphLine text, int leftPos, int rightPos) {
        this.text = new GlyphLine(text);
        this.text.start = leftPos;
        this.text.end = rightPos;
        this.otfFeaturesApplied = false;
    }

    public GlyphLine getText() {
        this.convertWaitingStringToGlyphLine();
        return this.text;
    }

    public int length() {
        return this.text == null ? 0 : this.text.end - this.text.start;
    }

    @Override
    public String toString() {
        return this.line != null ? this.line.toUnicodeString(this.line.start, this.line.end) : this.strToBeConverted;
    }

    public int charAt(int pos) {
        return this.text.get(pos + this.text.start).getUnicode();
    }

    public float getTabAnchorCharacterPosition() {
        return this.tabAnchorCharacterPosition;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new TextRenderer((Text)this.modelElement, null);
    }

    private boolean isNewLine(GlyphLine text, int ind) {
        return text.get(ind).hasValidUnicode() && text.get(ind).getUnicode() == 10;
    }

    private GlyphLine convertToGlyphLine(String text) {
        PdfFont font = this.getPdfFont();
        return font.createGlyphLine(text);
    }

    private boolean isOtfFont(PdfFont font) {
        return font instanceof PdfType0Font && font.getFontProgram() instanceof TrueTypeFont;
    }

    @Override
    protected float getFirstYLineRecursively() {
        return this.getYLine();
    }

    protected int lineLength() {
        return this.line.end > 0 ? this.line.end - this.line.start : 0;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (int i = this.line.start; i < this.line.end; ++i) {
            Glyph glyph = this.line.get(i);
            if (glyph.hasPlacement()) continue;
            ++count;
        }
        return count;
    }

    protected int getNumberOfSpaces() {
        if (this.line.end <= 0) {
            return 0;
        }
        int spaces = 0;
        for (int i = this.line.start; i < this.line.end; ++i) {
            Glyph currentGlyph = this.line.get(i);
            if (!currentGlyph.hasValidUnicode() || currentGlyph.getUnicode() != 32) continue;
            ++spaces;
        }
        return spaces;
    }

    protected TextRenderer createSplitRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer createOverflowRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer[] split(int initialOverflowTextPos) {
        TextRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.setText(this.text, this.text.start, initialOverflowTextPos);
        splitRenderer.line = this.line;
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.yLineOffset = this.yLineOffset;
        splitRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        TextRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.setText(this.text, initialOverflowTextPos, this.text.end);
        overflowRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return new TextRenderer[]{splitRenderer, overflowRenderer};
    }

    protected void drawSingleUnderline(Underline underline, Color fontStrokeColor, PdfCanvas canvas, float fontSize, float italicAngleTan) {
        float underlineThickness;
        Color underlineColor = underline.getColor() != null ? underline.getColor() : fontStrokeColor;
        canvas.saveState();
        if (underlineColor != null) {
            canvas.setStrokeColor(underlineColor);
        }
        if ((underlineThickness = underline.getThickness(fontSize)) != 0.0f) {
            canvas.setLineWidth(underlineThickness);
            float yLine = this.getYLine();
            float underlineYPosition = underline.getYPosition(fontSize) + yLine;
            float italicWidthSubstraction = 0.5f * fontSize * italicAngleTan;
            canvas.moveTo(this.occupiedArea.getBBox().getX(), underlineYPosition).lineTo(this.occupiedArea.getBBox().getX() + this.occupiedArea.getBBox().getWidth() - italicWidthSubstraction, underlineYPosition).stroke();
        }
        canvas.restoreState();
    }

    protected float calculateLineWidth() {
        return this.getGlyphLineWidth(this.line, this.getFontSize(), Float.valueOf(1.0f), 0.0f, 0.0f);
    }

    private Map<GlyphLine, Boolean> getOutputChunks() {
        List reversedRange = (List)this.getProperty(53);
        LinkedHashMap<GlyphLine, Boolean> outputs = new LinkedHashMap<GlyphLine, Boolean>();
        if (reversedRange != null) {
            if (((int[])reversedRange.get(0))[0] > 0) {
                outputs.put(this.line.copy(0, ((int[])reversedRange.get(0))[0]), false);
            }
            for (int i = 0; i < reversedRange.size(); ++i) {
                int[] range = (int[])reversedRange.get(i);
                outputs.put(this.line.copy(range[0], range[1] + 1), true);
                if (i == reversedRange.size() - 1) continue;
                outputs.put(this.line.copy(range[1] + 1, ((int[])reversedRange.get(i + 1))[0]), false);
            }
            int lastIndex = ((int[])reversedRange.get(reversedRange.size() - 1))[1];
            if (lastIndex < this.line.size()) {
                outputs.put(this.line.copy(lastIndex + 1, this.line.size()), false);
            }
        } else {
            outputs.put(this.line, false);
        }
        return outputs;
    }

    private static boolean noPrint(Glyph g) {
        if (!g.hasValidUnicode()) {
            return false;
        }
        int c = g.getUnicode();
        return c >= 8203 && c <= 8207 || c >= 8234 && c <= 8238 || c == 173;
    }

    private float getCharWidth(Glyph g, float fontSize, float hScale, float characterSpacing, float wordSpacing) {
        if (hScale == 0.0f) {
            hScale = 1.0f;
        }
        float resultWidth = (float)g.getWidth() * fontSize * hScale;
        if (characterSpacing != 0.0f) {
            resultWidth += characterSpacing * hScale * 1000.0f;
        }
        if (wordSpacing != 0.0f && g.hasValidUnicode() && g.getUnicode() == 32) {
            resultWidth += wordSpacing * hScale * 1000.0f;
        }
        return resultWidth;
    }

    private float scaleXAdvance(float xAdvance, float fontSize, float hScale) {
        return xAdvance * fontSize * hScale;
    }

    private float getGlyphLineWidth(GlyphLine glyphLine, float fontSize, Float hScale, float characterSpacing, float wordSpacing) {
        float width = 0.0f;
        for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            float charWidth = this.getCharWidth(glyphLine.get(i), fontSize, hScale.floatValue(), characterSpacing, wordSpacing);
            width += charWidth;
            float xAdvance = i != glyphLine.start ? this.scaleXAdvance(glyphLine.get(i - 1).getXAdvance(), fontSize, hScale.floatValue()) : 0.0f;
            width += xAdvance;
        }
        return width / 1000.0f;
    }

    private int[] getWordBoundsForHyphenation(GlyphLine text, int leftTextPos, int rightTextPos, int wordMiddleCharPos) {
        while (wordMiddleCharPos >= leftTextPos && !this.isGlyphPartOfWordForHyphenation(text.get(wordMiddleCharPos)) && !this.isWhitespaceGlyph(text.get(wordMiddleCharPos))) {
            --wordMiddleCharPos;
        }
        if (wordMiddleCharPos >= leftTextPos) {
            int right;
            int left;
            for (left = wordMiddleCharPos; left >= leftTextPos && this.isGlyphPartOfWordForHyphenation(text.get(left)); --left) {
            }
            for (right = wordMiddleCharPos; right < rightTextPos && this.isGlyphPartOfWordForHyphenation(text.get(right)); ++right) {
            }
            return new int[]{left + 1, right};
        }
        return null;
    }

    private boolean isGlyphPartOfWordForHyphenation(Glyph g) {
        return g.hasValidUnicode() && (Character.isLetter(g.getUnicode()) || Character.isDigit(g.getUnicode()) || 173 == g.getUnicode());
    }

    private boolean isWhitespaceGlyph(Glyph g) {
        return g.hasValidUnicode() && g.getUnicode() == 32;
    }

    private void convertWaitingStringToGlyphLine() {
        if (this.strToBeConverted != null) {
            GlyphLine glyphLine = this.convertToGlyphLine(this.strToBeConverted);
            this.setText(glyphLine, glyphLine.start, glyphLine.end);
            this.strToBeConverted = null;
        }
    }
}

