/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.tagutils;

import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfStructElem;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.AccessibilityProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BackedAccessibleProperties
extends AccessibilityProperties {
    private static final long serialVersionUID = 4080083623525383278L;
    private PdfStructElem backingElem;

    BackedAccessibleProperties(PdfStructElem backingElem) {
        this.backingElem = backingElem;
    }

    @Override
    public String getLanguage() {
        return this.backingElem.getLang().getValue();
    }

    @Override
    public AccessibilityProperties setLanguage(String language) {
        this.backingElem.setLang(new PdfString(language));
        return this;
    }

    @Override
    public String getActualText() {
        return this.backingElem.getActualText().getValue();
    }

    @Override
    public AccessibilityProperties setActualText(String actualText) {
        this.backingElem.setActualText(new PdfString(actualText));
        return this;
    }

    @Override
    public String getAlternateDescription() {
        return this.backingElem.getAlt().getValue();
    }

    @Override
    public AccessibilityProperties setAlternateDescription(String alternateDescription) {
        this.backingElem.setAlt(new PdfString(alternateDescription));
        return this;
    }

    @Override
    public String getExpansion() {
        return this.backingElem.getE().getValue();
    }

    @Override
    public AccessibilityProperties setExpansion(String expansion) {
        this.backingElem.setE(new PdfString(expansion));
        return this;
    }

    @Override
    public AccessibilityProperties addAttributes(PdfDictionary attributes) {
        PdfObject attributesObject = this.backingElem.getAttributes(false);
        PdfObject combinedAttributes = this.combineAttributesList(attributesObject, Collections.singletonList(attributes), ((PdfDictionary)this.backingElem.getPdfObject()).getAsNumber(PdfName.R));
        this.backingElem.setAttributes(combinedAttributes);
        return this;
    }

    @Override
    public AccessibilityProperties clearAttributes() {
        ((PdfDictionary)this.backingElem.getPdfObject()).remove(PdfName.A);
        return this;
    }

    @Override
    public List<PdfDictionary> getAttributesList() {
        ArrayList<PdfDictionary> attributesList = new ArrayList<PdfDictionary>();
        PdfObject elemAttributesObj = this.backingElem.getAttributes(false);
        if (elemAttributesObj != null) {
            if (elemAttributesObj.isDictionary()) {
                attributesList.add((PdfDictionary)elemAttributesObj);
            } else if (elemAttributesObj.isArray()) {
                PdfArray attributesArray = (PdfArray)elemAttributesObj;
                for (PdfObject attributeObj : attributesArray) {
                    if (!attributeObj.isDictionary()) continue;
                    attributesList.add((PdfDictionary)attributeObj);
                }
            }
        }
        return attributesList;
    }

    @Override
    void setToStructElem(PdfStructElem elem) {
    }
}

