/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.collection;

import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.collection.PdfCollectionSchema;
import com.fr.third.fr.pdf.kernel.pdf.collection.PdfCollectionSort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCollection
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 5184499156015360355L;
    public static final int DETAILS = 0;
    public static final int TILE = 1;
    public static final int HIDDEN = 2;

    public PdfCollection(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfCollection() {
        this(new PdfDictionary());
    }

    public PdfCollection setSchema(PdfCollectionSchema schema) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Schema, (PdfObject)schema.getPdfObject());
        return this;
    }

    public PdfCollectionSchema getSchema() {
        return new PdfCollectionSchema(((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Schema));
    }

    public PdfCollection setInitialDocument(String documentName) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.D, new PdfString(documentName));
        return this;
    }

    public PdfString getInitialDocument() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.D);
    }

    public PdfCollection setView(int viewType) {
        switch (viewType) {
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.View, PdfName.D);
                break;
            }
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.View, PdfName.T);
                break;
            }
            case 2: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.View, PdfName.H);
            }
        }
        return this;
    }

    public PdfNumber getView() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.View);
    }

    public PdfCollection setSort(PdfCollectionSort sort) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Sort, (PdfObject)sort.getPdfObject());
        return this;
    }

    public PdfCollectionSort getSort() {
        return new PdfCollectionSort(((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Sort));
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

