/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.parser;

import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.IContentOperator;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.PdfCanvasProcessor;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener.IEventListener;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfDocumentContentParser {
    private final PdfDocument pdfDocument;

    public PdfDocumentContentParser(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    public <E extends IEventListener> E processContent(int pageNumber, E renderListener, Map<String, IContentOperator> additionalContentOperators) {
        PdfCanvasProcessor processor = new PdfCanvasProcessor(renderListener);
        for (Map.Entry<String, IContentOperator> entry : additionalContentOperators.entrySet()) {
            processor.registerContentOperator(entry.getKey(), entry.getValue());
        }
        processor.processPageContent(this.pdfDocument.getPage(pageNumber));
        return renderListener;
    }

    public <E extends IEventListener> E processContent(int pageNumber, E renderListener) {
        return this.processContent(pageNumber, renderListener, new HashMap<String, IContentOperator>());
    }
}

