/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.source.ByteArrayOutputStream;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.ByteBufferOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import java.io.IOException;

class PdfObjectStream
extends PdfStream {
    private static final long serialVersionUID = -3513488307665597642L;
    public static final int MAX_OBJ_STREAM_SIZE = 200;
    protected PdfNumber size = new PdfNumber(0);
    protected PdfOutputStream indexStream = new PdfOutputStream(new ByteArrayOutputStream());

    public PdfObjectStream(PdfDocument doc) {
        this.makeIndirect(doc);
        this.getOutputStream().document = doc;
        this.put(PdfName.Type, PdfName.ObjStm);
        this.put(PdfName.N, this.size);
        this.put(PdfName.First, new PdfNumber(this.indexStream.getCurrentPos()));
    }

    PdfObjectStream(PdfObjectStream prev) {
        this(prev.getIndirectReference().getDocument());
        ByteBufferOutputStream prevOutputStream = (ByteBufferOutputStream)prev.getOutputStream().getOutputStream();
        prevOutputStream.reset();
        this.initOutputStream(prevOutputStream);
        ByteBufferOutputStream prevIndexStream = (ByteBufferOutputStream)this.indexStream.getOutputStream();
        prevIndexStream.reset();
        this.indexStream = new PdfOutputStream(prevIndexStream);
    }

    public void addObject(PdfObject object) {
        if (this.size.intValue() == 200) {
            throw new PdfException("pdf.object.stream.reach.max.size");
        }
        PdfOutputStream outputStream = this.getOutputStream();
        ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)this.indexStream.writeInteger(object.getIndirectReference().getObjNumber())).writeSpace()).writeLong(outputStream.getCurrentPos())).writeSpace();
        outputStream.write(object);
        object.getIndirectReference().setObjStreamNumber(this.getIndirectReference().getObjNumber());
        object.getIndirectReference().setIndex(this.size.intValue());
        outputStream.writeSpace();
        this.size.increment();
        ((PdfNumber)this.get(PdfName.First)).setValue(this.indexStream.getCurrentPos());
    }

    public int getSize() {
        return this.size.intValue();
    }

    public PdfOutputStream getIndexStream() {
        return this.indexStream;
    }

    protected void releaseContent() {
        this.releaseContent(false);
    }

    private void releaseContent(boolean close) {
        if (close) {
            super.releaseContent();
            try {
                this.indexStream.close();
            }
            catch (IOException e) {
                throw new PdfException("io.exception", e);
            }
            this.indexStream = null;
        }
    }
}

