/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.source.ByteUtils;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPrimitiveObject;

public class PdfNumber
extends PdfPrimitiveObject {
    private static final long serialVersionUID = -250799718574024246L;
    private double value;
    private boolean isDouble;

    public PdfNumber(double value) {
        this.setValue(value);
    }

    public PdfNumber(int value) {
        this.setValue(value);
    }

    public PdfNumber(byte[] content) {
        super(content);
        this.isDouble = true;
        this.value = Double.NaN;
    }

    private PdfNumber() {
    }

    public byte getType() {
        return 8;
    }

    public double getValue() {
        if (Double.isNaN(this.value)) {
            this.generateValue();
        }
        return this.value;
    }

    public double doubleValue() {
        return this.getValue();
    }

    public float floatValue() {
        return (float)this.getValue();
    }

    public long longValue() {
        return (long)this.getValue();
    }

    public int intValue() {
        return (int)this.getValue();
    }

    public void setValue(int value) {
        this.value = value;
        this.isDouble = false;
        this.content = null;
    }

    public void setValue(double value) {
        this.value = value;
        this.isDouble = true;
        this.content = null;
    }

    public void increment() {
        this.setValue(this.value += 1.0);
    }

    public void decrement() {
        this.setValue(this.value -= 1.0);
    }

    public PdfNumber makeIndirect(PdfDocument document) {
        return (PdfNumber)super.makeIndirect(document);
    }

    public PdfNumber makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfNumber)super.makeIndirect(document, reference);
    }

    public PdfNumber copyTo(PdfDocument document) {
        return (PdfNumber)super.copyTo(document, true);
    }

    public PdfNumber copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfNumber)super.copyTo(document, allowDuplicating);
    }

    public String toString() {
        if (this.content != null) {
            return new String(this.content);
        }
        if (this.isDouble) {
            return new String(ByteUtils.getIsoBytes(this.getValue()));
        }
        return new String(ByteUtils.getIsoBytes(this.intValue()));
    }

    protected PdfNumber newInstance() {
        return new PdfNumber();
    }

    protected boolean isDoubleNumber() {
        return this.isDouble;
    }

    protected void generateContent() {
        this.content = this.isDouble ? ByteUtils.getIsoBytes(this.value) : ByteUtils.getIsoBytes((int)this.value);
    }

    protected void generateValue() {
        try {
            this.value = Double.parseDouble(new String(this.content));
        }
        catch (NumberFormatException e) {
            this.value = Double.NaN;
        }
        this.isDouble = true;
    }

    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfNumber number = (PdfNumber)from;
        this.value = number.value;
        this.isDouble = number.isDouble;
    }
}

