/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfDictionary
extends PdfObject {
    private static final long serialVersionUID = -1122075818690871644L;
    private Map<PdfName, PdfObject> map = new TreeMap<PdfName, PdfObject>();
    private int hashCode = -1;

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object v) {
        return this == v;
    }

    public PdfDictionary() {
    }

    public PdfDictionary(Map<PdfName, PdfObject> map) {
        this.map.putAll(map);
    }

    public PdfDictionary(Set<Map.Entry<PdfName, PdfObject>> entrySet) {
        for (Map.Entry<PdfName, PdfObject> entry : entrySet) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public PdfDictionary(PdfDictionary dictionary) {
        this.map.putAll(dictionary.map);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(PdfName key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(PdfObject value) {
        return this.map.containsValue(value);
    }

    public PdfObject get(PdfName key) {
        return this.get(key, true);
    }

    public PdfArray getAsArray(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 1) {
            return (PdfArray)direct;
        }
        return null;
    }

    public PdfDictionary getAsDictionary(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 3) {
            return (PdfDictionary)direct;
        }
        return null;
    }

    public PdfStream getAsStream(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 9) {
            return (PdfStream)direct;
        }
        return null;
    }

    public PdfNumber getAsNumber(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 8) {
            return (PdfNumber)direct;
        }
        return null;
    }

    public PdfName getAsName(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 6) {
            return (PdfName)direct;
        }
        return null;
    }

    public PdfString getAsString(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 10) {
            return (PdfString)direct;
        }
        return null;
    }

    public PdfBoolean getAsBoolean(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 2) {
            return (PdfBoolean)direct;
        }
        return null;
    }

    public Rectangle getAsRectangle(PdfName key) {
        PdfArray a = this.getAsArray(key);
        return a == null ? null : a.toRectangle();
    }

    public Float getAsFloat(PdfName key) {
        PdfNumber number = this.getAsNumber(key);
        return number == null ? null : Float.valueOf(number.floatValue());
    }

    public Integer getAsInt(PdfName key) {
        PdfNumber number = this.getAsNumber(key);
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    public Boolean getAsBool(PdfName key) {
        PdfBoolean b = this.getAsBoolean(key);
        return b == null ? null : Boolean.valueOf(b.getValue());
    }

    public PdfObject put(PdfName key, PdfObject value) {
        assert (value != null);
        return this.map.put(key, value);
    }

    public PdfObject remove(PdfName key) {
        return this.map.remove(key);
    }

    public void putAll(PdfDictionary d) {
        this.map.putAll(d.map);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<PdfName> keySet() {
        return this.map.keySet();
    }

    public Collection<PdfObject> values() {
        return this.map.values();
    }

    public Set<Map.Entry<PdfName, PdfObject>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public byte getType() {
        return 3;
    }

    public String toString() {
        if (!this.isFlushed()) {
            String string = "<<";
            for (Map.Entry<PdfName, PdfObject> entry : this.entrySet()) {
                PdfIndirectReference indirectReference = entry.getValue().getIndirectReference();
                string = string + entry.getKey().toString() + " " + (indirectReference == null ? entry.getValue().toString() : indirectReference.toString()) + " ";
            }
            string = string + ">>";
            return string;
        }
        return this.indirectReference.toString();
    }

    public PdfDictionary clone(List<PdfName> excludeKeys) {
        TreeMap<PdfName, PdfObject> excluded = new TreeMap<PdfName, PdfObject>();
        for (PdfName key : excludeKeys) {
            PdfObject obj = this.map.get(key);
            if (obj == null) continue;
            excluded.put(key, this.map.remove(key));
        }
        PdfDictionary dictionary = (PdfDictionary)this.clone();
        this.map.putAll(excluded);
        return dictionary;
    }

    @Override
    public PdfDictionary makeIndirect(PdfDocument document) {
        return (PdfDictionary)super.makeIndirect(document);
    }

    @Override
    public PdfDictionary makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfDictionary)super.makeIndirect(document, reference);
    }

    @Override
    public PdfDictionary copyTo(PdfDocument document) {
        return (PdfDictionary)super.copyTo(document, true);
    }

    @Override
    public PdfDictionary copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfDictionary)super.copyTo(document, allowDuplicating);
    }

    public PdfDictionary copyTo(PdfDocument document, List<PdfName> excludeKeys, boolean allowDuplicating) {
        TreeMap<PdfName, PdfObject> excluded = new TreeMap<PdfName, PdfObject>();
        for (PdfName key : excludeKeys) {
            PdfObject obj = this.map.get(key);
            if (obj == null) continue;
            excluded.put(key, this.map.remove(key));
        }
        PdfDictionary dictionary = this.copyTo(document, allowDuplicating);
        this.map.putAll(excluded);
        return dictionary;
    }

    public PdfObject get(PdfName key, boolean asDirect) {
        if (!asDirect) {
            return this.map.get(key);
        }
        PdfObject obj = this.map.get(key);
        if (obj != null && obj.getType() == 5) {
            return ((PdfIndirectReference)obj).getRefersTo(true);
        }
        return obj;
    }

    public void mergeDifferent(PdfDictionary other) {
        for (PdfName key : other.keySet()) {
            if (this.containsKey(key)) continue;
            this.put(key, other.get(key));
        }
    }

    @Override
    protected PdfDictionary newInstance() {
        return new PdfDictionary();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfDictionary dictionary = (PdfDictionary)from;
        for (Map.Entry<PdfName, PdfObject> entry : dictionary.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue().processCopying(document, false));
        }
    }

    protected void releaseContent() {
        this.map = null;
    }
}

