/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.font;

import com.fr.third.fr.pdf.io.font.FontEncoding;
import com.fr.third.fr.pdf.io.font.Type1Font;
import com.fr.third.fr.pdf.io.font.cmap.CMapToUnicode;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.kernel.font.DocFontEncoding;
import com.fr.third.fr.pdf.kernel.font.DocType1Font;
import com.fr.third.fr.pdf.kernel.font.FontUtil;
import com.fr.third.fr.pdf.kernel.font.IDocFontProgram;
import com.fr.third.fr.pdf.kernel.font.PdfSimpleFont;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfType1Font
extends PdfSimpleFont<Type1Font> {
    private static final long serialVersionUID = 7009919945291639441L;

    PdfType1Font(Type1Font type1Font, String encoding, boolean embedded) {
        this.setFontProgram(type1Font);
        boolean bl = this.embedded = embedded && !type1Font.isBuiltInFont();
        if ((encoding == null || encoding.length() == 0) && type1Font.isFontSpecific()) {
            encoding = "FontSpecific";
        }
        this.fontEncoding = encoding != null && "FontSpecific".toLowerCase().equals(encoding.toLowerCase()) ? FontEncoding.createFontSpecificEncoding() : FontEncoding.createFontEncoding(encoding);
    }

    PdfType1Font(Type1Font type1Font, String encoding) {
        this(type1Font, encoding, false);
    }

    PdfType1Font(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.newFont = false;
        this.checkFontDictionary(fontDictionary, PdfName.Type1);
        CMapToUnicode toUni = FontUtil.processToUnicode(fontDictionary.get(PdfName.ToUnicode));
        this.fontEncoding = DocFontEncoding.createDocFontEncoding(fontDictionary.get(PdfName.Encoding), toUni);
        this.fontProgram = DocType1Font.createFontProgram(fontDictionary, this.fontEncoding, toUni);
        if (this.fontProgram instanceof IDocFontProgram) {
            this.embedded = ((IDocFontProgram)((Object)this.fontProgram)).getFontFile() != null;
        }
        this.subset = false;
    }

    @Override
    public boolean isSubset() {
        return this.subset;
    }

    @Override
    public void setSubset(boolean subset) {
        this.subset = subset;
    }

    @Override
    public void flush() {
        if (this.newFont) {
            this.flushFontData(this.fontProgram.getFontNames().getFontName(), PdfName.Type1);
        }
        super.flush();
    }

    @Override
    public Glyph getGlyph(int unicode) {
        if (this.fontEncoding.canEncode(unicode)) {
            Glyph glyph;
            if (this.fontEncoding.isFontSpecific()) {
                glyph = ((Type1Font)this.getFontProgram()).getGlyphByCode(unicode);
            } else {
                glyph = ((Type1Font)this.getFontProgram()).getGlyph(this.fontEncoding.getUnicodeDifference(unicode));
                if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null) {
                    glyph = new Glyph(-1, 0, unicode);
                    this.notdefGlyphs.put(unicode, glyph);
                }
            }
            return glyph;
        }
        return null;
    }

    @Override
    protected boolean isBuiltInFont() {
        return ((Type1Font)this.getFontProgram()).isBuiltInFont();
    }

    @Override
    protected void addFontStream(PdfDictionary fontDescriptor) {
        if (this.embedded) {
            if (this.fontProgram instanceof IDocFontProgram) {
                IDocFontProgram docType1Font = (IDocFontProgram)((Object)this.fontProgram);
                fontDescriptor.put(docType1Font.getFontFileName(), docType1Font.getFontFile());
                if (docType1Font.getSubtype() != null) {
                    fontDescriptor.put(PdfName.Subtype, docType1Font.getSubtype());
                }
            } else {
                byte[] fontStreamBytes = ((Type1Font)this.getFontProgram()).getFontStreamBytes();
                if (fontStreamBytes != null) {
                    PdfStream fontStream = new PdfStream(fontStreamBytes);
                    int[] fontStreamLengths = ((Type1Font)this.getFontProgram()).getFontStreamLengths();
                    for (int k = 0; k < fontStreamLengths.length; ++k) {
                        fontStream.put(new PdfName("Length" + (k + 1)), new PdfNumber(fontStreamLengths[k]));
                    }
                    fontDescriptor.put(PdfName.FontFile, fontStream);
                }
            }
        }
    }
}

