/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.crypto.securityhandler;

import com.fr.third.fr.pdf.io.util.StreamUtil;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.crypto.securityhandler.PublicKeyRecipient;
import com.fr.third.fr.pdf.kernel.crypto.securityhandler.SecurityHandler;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfEncryptor;
import com.fr.third.fr.pdf.kernel.pdf.PdfLiteral;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.security.IExternalDecryptionProcess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.RecipientInformation;

public abstract class PubKeySecurityHandler
extends SecurityHandler {
    private static final int SEED_LENGTH = 20;
    private List<PublicKeyRecipient> recipients = null;
    private byte[] seed = new byte[20];

    protected PubKeySecurityHandler() {
        try {
            KeyGenerator key = KeyGenerator.getInstance("AES");
            key.init(192, new SecureRandom());
            SecretKey sk = key.generateKey();
            System.arraycopy(sk.getEncoded(), 0, this.seed, 0, 20);
        }
        catch (NoSuchAlgorithmException e) {
            this.seed = SecureRandom.getSeed(20);
        }
        this.recipients = new ArrayList<PublicKeyRecipient>();
    }

    protected byte[] computeGlobalKey(String messageDigestAlgorithm, boolean encryptMetadata) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(messageDigestAlgorithm);
            md.update(this.getSeed());
            for (int i = 0; i < this.getRecipientsSize(); ++i) {
                byte[] encodedRecipient = this.getEncodedRecipient(i);
                md.update(encodedRecipient);
            }
            if (!encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
        }
        catch (Exception e) {
            throw new PdfException("pdf.encryption", e);
        }
        return md.digest();
    }

    protected static byte[] computeGlobalKeyOnReading(PdfDictionary encryptionDictionary, PrivateKey certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata, String digestAlgorithm) {
        byte[] encryptionKey;
        CMSEnvelopedData data;
        PdfString recipient;
        int i;
        X509CertificateHolder certHolder;
        PdfArray recipients = encryptionDictionary.getAsArray(PdfName.Recipients);
        if (recipients == null) {
            recipients = encryptionDictionary.getAsDictionary(PdfName.CF).getAsDictionary(PdfName.DefaultCryptFilter).getAsArray(PdfName.Recipients);
        }
        boolean foundRecipient = false;
        byte[] envelopedData = null;
        try {
            certHolder = new X509CertificateHolder(certificate.getEncoded());
        }
        catch (Exception f) {
            throw new PdfException("pdf.decryption", f);
        }
        if (externalDecryptionProcess == null) {
            for (i = 0; i < recipients.size(); ++i) {
                recipient = recipients.getAsString(i);
                try {
                    data = new CMSEnvelopedData(recipient.getValueBytes());
                    for (RecipientInformation recipientInfo : data.getRecipientInfos().getRecipients()) {
                        if (!recipientInfo.getRID().match(certHolder) || foundRecipient) continue;
                        envelopedData = PdfEncryptor.getContent(recipientInfo, certificateKey, certificateKeyProvider);
                        foundRecipient = true;
                    }
                    continue;
                }
                catch (Exception f) {
                    throw new PdfException("pdf.decryption", f);
                }
            }
        } else {
            for (i = 0; i < recipients.size(); ++i) {
                recipient = recipients.getAsString(i);
                try {
                    data = new CMSEnvelopedData(recipient.getValueBytes());
                    RecipientInformation recipientInfo = data.getRecipientInfos().get(externalDecryptionProcess.getCmsRecipientId());
                    if (recipientInfo == null) continue;
                    envelopedData = recipientInfo.getContent(externalDecryptionProcess.getCmsRecipient());
                    foundRecipient = true;
                    continue;
                }
                catch (Exception f) {
                    throw new PdfException("pdf.decryption", f);
                }
            }
        }
        if (!foundRecipient || envelopedData == null) {
            throw new PdfException("bad.certificate.and.key");
        }
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(envelopedData, 0, 20);
            for (int i2 = 0; i2 < recipients.size(); ++i2) {
                byte[] encodedRecipient = recipients.getAsString(i2).getValueBytes();
                md.update(encodedRecipient);
            }
            if (!encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            encryptionKey = md.digest();
        }
        catch (Exception f) {
            throw new PdfException("pdf.decryption", f);
        }
        return encryptionKey;
    }

    protected void addAllRecipients(Certificate[] certs, int[] permissions) {
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                this.addRecipient(certs[i], permissions[i]);
            }
        }
    }

    protected PdfArray createRecipientsArray() {
        PdfArray recipients;
        try {
            recipients = this.getEncodedRecipients();
        }
        catch (Exception e) {
            throw new PdfException("pdf.encryption", e);
        }
        return recipients;
    }

    protected abstract void setPubSecSpecificHandlerDicEntries(PdfDictionary var1, boolean var2, boolean var3);

    protected abstract String getDigestAlgorithm();

    protected abstract void initKey(byte[] var1, int var2);

    protected void initKeyAndFillDictionary(PdfDictionary encryptionDictionary, Certificate[] certs, int[] permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        this.addAllRecipients(certs, permissions);
        Integer keyLen = encryptionDictionary.getAsInt(PdfName.Length);
        int keyLength = keyLen != null ? keyLen : 40;
        String digestAlgorithm = this.getDigestAlgorithm();
        byte[] digest = this.computeGlobalKey(digestAlgorithm, encryptMetadata);
        this.initKey(digest, keyLength);
        this.setPubSecSpecificHandlerDicEntries(encryptionDictionary, encryptMetadata, embeddedFilesOnly);
    }

    protected void initKeyAndReadDictionary(PdfDictionary encryptionDictionary, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata) {
        String digestAlgorithm = this.getDigestAlgorithm();
        byte[] encryptionKey = PubKeySecurityHandler.computeGlobalKeyOnReading(encryptionDictionary, (PrivateKey)certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, encryptMetadata, digestAlgorithm);
        Integer keyLen = encryptionDictionary.getAsInt(PdfName.Length);
        int keyLength = keyLen != null ? keyLen : 40;
        this.initKey(encryptionKey, keyLength);
    }

    private void addRecipient(Certificate cert, int permission) {
        this.recipients.add(new PublicKeyRecipient(cert, permission));
    }

    private byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    private int getRecipientsSize() {
        return this.recipients.size();
    }

    private byte[] getEncodedRecipient(int index) throws IOException, GeneralSecurityException {
        PublicKeyRecipient recipient = this.recipients.get(index);
        byte[] cms = recipient.getCms();
        if (cms != null) {
            return cms;
        }
        Certificate certificate = recipient.getCertificate();
        int permission = recipient.getPermission();
        permission |= 0xFFFFF0C0;
        permission &= 0xFFFFFFFC;
        byte[] pkcs7input = new byte[24];
        byte one = (byte)(++permission);
        byte two = (byte)(permission >> 8);
        byte three = (byte)(permission >> 16);
        byte four = (byte)(permission >> 24);
        System.arraycopy(this.seed, 0, pkcs7input, 0, 20);
        pkcs7input[20] = four;
        pkcs7input[21] = three;
        pkcs7input[22] = two;
        pkcs7input[23] = one;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream k = new DEROutputStream(baos);
        ASN1Primitive obj = this.createDERForRecipient(pkcs7input, (X509Certificate)certificate);
        k.writeObject((ASN1Encodable)obj);
        cms = baos.toByteArray();
        recipient.setCms(cms);
        return cms;
    }

    private PdfArray getEncodedRecipients() throws IOException, GeneralSecurityException {
        PdfArray EncodedRecipients = new PdfArray();
        for (int i = 0; i < this.recipients.size(); ++i) {
            try {
                byte[] cms = this.getEncodedRecipient(i);
                EncodedRecipients.add(new PdfLiteral(StreamUtil.createEscapedString(cms)));
                continue;
            }
            catch (GeneralSecurityException e) {
                EncodedRecipients = null;
                break;
            }
            catch (IOException e) {
                EncodedRecipients = null;
                break;
            }
        }
        return EncodedRecipients;
    }

    private ASN1Primitive createDERForRecipient(byte[] in, X509Certificate cert) throws IOException, GeneralSecurityException {
        String s = "1.2.840.113549.3.2";
        AlgorithmParameterGenerator algorithmparametergenerator = AlgorithmParameterGenerator.getInstance(s);
        AlgorithmParameters algorithmparameters = algorithmparametergenerator.generateParameters();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(algorithmparameters.getEncoded("ASN.1"));
        ASN1InputStream asn1inputstream = new ASN1InputStream(bytearrayinputstream);
        ASN1Primitive derobject = asn1inputstream.readObject();
        KeyGenerator keygenerator = KeyGenerator.getInstance(s);
        keygenerator.init(128);
        SecretKey secretkey = keygenerator.generateKey();
        Cipher cipher = Cipher.getInstance(s);
        cipher.init(1, (Key)secretkey, algorithmparameters);
        byte[] abyte1 = cipher.doFinal(in);
        DEROctetString deroctetstring = new DEROctetString(abyte1);
        KeyTransRecipientInfo keytransrecipientinfo = this.computeRecipientInfo(cert, secretkey.getEncoded());
        DERSet derset = new DERSet((ASN1Encodable)new RecipientInfo(keytransrecipientinfo));
        AlgorithmIdentifier algorithmidentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(s), (ASN1Encodable)derobject);
        EncryptedContentInfo encryptedcontentinfo = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmidentifier, (ASN1OctetString)deroctetstring);
        EnvelopedData env = new EnvelopedData(null, derset, encryptedcontentinfo, null);
        ContentInfo contentinfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, (ASN1Encodable)env);
        return contentinfo.toASN1Primitive();
    }

    private KeyTransRecipientInfo computeRecipientInfo(X509Certificate x509certificate, byte[] abyte0) throws GeneralSecurityException, IOException {
        ASN1InputStream asn1inputstream = new ASN1InputStream(new ByteArrayInputStream(x509certificate.getTBSCertificate()));
        TBSCertificateStructure tbscertificatestructure = TBSCertificateStructure.getInstance(asn1inputstream.readObject());
        assert (tbscertificatestructure != null);
        AlgorithmIdentifier algorithmidentifier = tbscertificatestructure.getSubjectPublicKeyInfo().getAlgorithm();
        IssuerAndSerialNumber issuerandserialnumber = new IssuerAndSerialNumber(tbscertificatestructure.getIssuer(), tbscertificatestructure.getSerialNumber().getValue());
        Cipher cipher = Cipher.getInstance(algorithmidentifier.getAlgorithm().getId());
        try {
            cipher.init(1, x509certificate);
        }
        catch (InvalidKeyException e) {
            cipher.init(1, x509certificate.getPublicKey());
        }
        DEROctetString deroctetstring = new DEROctetString(cipher.doFinal(abyte0));
        RecipientIdentifier recipId = new RecipientIdentifier(issuerandserialnumber);
        return new KeyTransRecipientInfo(recipId, algorithmidentifier, deroctetstring);
    }
}

