/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.util;

import java.io.InputStream;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static InputStream getResourceStream(String key) {
        return ResourceUtil.getResourceStream(key, null);
    }

    public static InputStream getResourceStream(String key, ClassLoader loader) {
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        InputStream stream = null;
        if (loader != null && (stream = loader.getResourceAsStream(key)) != null) {
            return stream;
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                stream = contextClassLoader.getResourceAsStream(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stream == null) {
            stream = ResourceUtil.class.getResourceAsStream("/" + key);
        }
        if (stream == null) {
            stream = ClassLoader.getSystemResourceAsStream(key);
        }
        return stream;
    }
}

