/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.image;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.codec.CCITTG4Encoder;
import com.fr.third.fr.pdf.io.codec.TIFFDirectory;
import com.fr.third.fr.pdf.io.codec.TIFFFaxDecoder;
import com.fr.third.fr.pdf.io.codec.TIFFField;
import com.fr.third.fr.pdf.io.codec.TIFFLZWDecoder;
import com.fr.third.fr.pdf.io.color.IccProfile;
import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.io.image.ImageDataFactory;
import com.fr.third.fr.pdf.io.image.ImageType;
import com.fr.third.fr.pdf.io.image.JpegImageHelper;
import com.fr.third.fr.pdf.io.image.RawImageData;
import com.fr.third.fr.pdf.io.image.RawImageHelper;
import com.fr.third.fr.pdf.io.image.TiffImageData;
import com.fr.third.fr.pdf.io.source.ByteArrayOutputStream;
import com.fr.third.fr.pdf.io.source.DeflaterOutputStream;
import com.fr.third.fr.pdf.io.source.IRandomAccessSource;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.source.RandomAccessSourceFactory;
import com.fr.third.fr.pdf.io.util.FilterUtil;
import java.util.HashMap;
import java.util.Map;

class TiffImageHelper {
    TiffImageHelper() {
    }

    public static void processImage(ImageData image) {
        if (image.getOriginalType() != ImageType.TIFF) {
            throw new IllegalArgumentException("TIFF image expected");
        }
        try {
            if (image.getData() == null) {
                image.loadData();
            }
            IRandomAccessSource ras = new RandomAccessSourceFactory().createSource(image.getData());
            RandomAccessFileOrArray raf = new RandomAccessFileOrArray(ras);
            TiffParameters tiff = new TiffParameters((TiffImageData)image);
            TiffImageHelper.processTiffImage(raf, tiff);
            raf.close();
            if (!tiff.jpegProcessing) {
                RawImageHelper.updateImageAttributes(tiff.image, tiff.additional);
            }
        }
        catch (java.io.IOException e) {
            throw new IOException("tiff.image.exception", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void processTiffImage(RandomAccessFileOrArray s, TiffParameters tiff) {
        recoverFromImageError = tiff.image.isRecoverFromImageError();
        page = tiff.image.getPage();
        direct = tiff.image.isDirect();
        if (page < 1) {
            throw new IOException("page.number.must.be.gt.eq {0}");
        }
        try {
            block48: {
                block47: {
                    dir = new TIFFDirectory(s, page - 1);
                    if (dir.isTagPresent(322)) {
                        throw new IOException("tiles.are.not.supported");
                    }
                    compression = (int)dir.getFieldAsLong(259);
                    switch (compression) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 32771: {
                            break;
                        }
                        default: {
                            TiffImageHelper.processTiffImageColor(dir, s, tiff);
                            return;
                        }
                    }
                    rotation = 0.0f;
                    if (dir.isTagPresent(274)) {
                        rot = (int)dir.getFieldAsLong(274);
                        if (rot == 3 || rot == 4) {
                            rotation = 3.1415927f;
                        } else if (rot == 5 || rot == 8) {
                            rotation = 1.5707964f;
                        } else if (rot == 6 || rot == 7) {
                            rotation = -1.5707964f;
                        }
                    }
                    tiffT4Options = 0L;
                    tiffT6Options = 0L;
                    fillOrder = 1;
                    h = (int)dir.getFieldAsLong(257);
                    w = (int)dir.getFieldAsLong(256);
                    XYRatio = 0.0f;
                    resolutionUnit = 2;
                    if (dir.isTagPresent(296)) {
                        resolutionUnit = (int)dir.getFieldAsLong(296);
                    }
                    dpiX = TiffImageHelper.getDpi(dir.getField(282), resolutionUnit);
                    dpiY = TiffImageHelper.getDpi(dir.getField(283), resolutionUnit);
                    if (resolutionUnit == 1) {
                        if (dpiY != 0) {
                            XYRatio = (float)dpiX / (float)dpiY;
                        }
                        dpiX = 0;
                        dpiY = 0;
                    }
                    rowsStrip = h;
                    if (dir.isTagPresent(278)) {
                        rowsStrip = (int)dir.getFieldAsLong(278);
                    }
                    if (rowsStrip <= 0 || rowsStrip > h) {
                        rowsStrip = h;
                    }
                    offset = TiffImageHelper.getArrayLongShort(dir, 273);
                    size = TiffImageHelper.getArrayLongShort(dir, 279);
                    if ((size == null || size.length == 1 && (size[0] == 0L || size[0] + offset[0] > s.length())) && h == rowsStrip) {
                        size = new long[]{s.length() - (long)((int)offset[0])};
                    }
                    reverse = false;
                    fillOrderField = dir.getField(266);
                    if (fillOrderField != null) {
                        fillOrder = fillOrderField.getAsInt(0);
                    }
                    reverse = fillOrder == 2;
                    parameters = 0;
                    if (dir.isTagPresent(262) && (photo = dir.getFieldAsLong(262)) == 1L) {
                        parameters |= 1;
                    }
                    imagecomp = 0;
                    switch (compression) {
                        case 2: 
                        case 32771: {
                            imagecomp = 257;
                            parameters |= 10;
                            break;
                        }
                        case 3: {
                            imagecomp = 257;
                            parameters |= 12;
                            t4OptionsField = dir.getField(292);
                            if (t4OptionsField == null) break;
                            tiffT4Options = t4OptionsField.getAsLong(0);
                            if ((tiffT4Options & 1L) != 0L) {
                                imagecomp = 258;
                            }
                            if ((tiffT4Options & 4L) == 0L) break;
                            parameters |= 2;
                            break;
                        }
                        case 4: {
                            imagecomp = 256;
                            t6OptionsField = dir.getField(293);
                            if (t6OptionsField == null) break;
                            tiffT6Options = t6OptionsField.getAsLong(0);
                        }
                    }
                    if (!direct || rowsStrip != h) break block47;
                    im = new byte[(int)size[0]];
                    s.seek(offset[0]);
                    s.readFully(im);
                    RawImageHelper.updateRawImageParameters(tiff.image, w, h, false, imagecomp, parameters, im, null);
                    tiff.image.setInverted(true);
                    break block48;
                }
                rowsLeft = h;
                g4 = new CCITTG4Encoder(w);
                for (k = 0; k < offset.length; ++k) {
                    im = new byte[(int)size[k]];
                    s.seek(offset[k]);
                    s.readFully(im);
                    height = Math.min(rowsStrip, rowsLeft);
                    decoder = new TIFFFaxDecoder(fillOrder, w, height);
                    decoder.setRecoverFromImageError(recoverFromImageError);
                    outBuf = new byte[(w + 7) / 8 * height];
                    switch (compression) {
                        case 2: 
                        case 32771: {
                            decoder.decode1D(outBuf, im, 0, height);
                            g4.fax4Encode(outBuf, height);
                            break;
                        }
                        case 3: {
                            try {
                                decoder.decode2D(outBuf, im, 0, height, tiffT4Options);
                            }
                            catch (RuntimeException e) {
                                tiffT4Options ^= 4L;
                                try {
                                    decoder.decode2D(outBuf, im, 0, height, tiffT4Options);
                                }
                                catch (RuntimeException e2) {
                                    if (!recoverFromImageError) {
                                        throw e;
                                    }
                                    if (rowsStrip == 1) {
                                        throw e;
                                    }
                                    im = new byte[(int)size[0]];
                                    s.seek(offset[0]);
                                    s.readFully(im);
                                    RawImageHelper.updateRawImageParameters(tiff.image, w, h, false, imagecomp, parameters, im, null);
                                    tiff.image.setInverted(true);
                                    tiff.image.setDpi(dpiX, dpiY);
                                    tiff.image.setXYRatio(XYRatio);
                                    if (rotation != 0.0f) {
                                        tiff.image.setRotation(rotation);
                                    }
                                    return;
                                }
                            }
                            g4.fax4Encode(outBuf, height);
                            break;
                        }
                        case 4: {
                            try {
                                decoder.decodeT6(outBuf, im, 0, height, tiffT6Options);
                            }
                            catch (IOException e) {
                                if (recoverFromImageError) ** GOTO lbl139
                                throw e;
                            }
lbl139:
                            // 2 sources

                            g4.fax4Encode(outBuf, height);
                        }
                    }
                    rowsLeft -= rowsStrip;
                }
                g4pic = g4.close();
                RawImageHelper.updateRawImageParameters(tiff.image, w, h, false, 256, parameters & 1, g4pic, null);
            }
            tiff.image.setDpi(dpiX, dpiY);
            if (dir.isTagPresent(34675)) {
                try {
                    fd = dir.getField(34675);
                    icc_prof = IccProfile.getInstance(fd.getAsBytes());
                    if (icc_prof.getNumComponents() == 1) {
                        tiff.image.setProfile(icc_prof);
                    }
                }
                catch (RuntimeException var26_30) {
                    // empty catch block
                }
            }
            if (rotation != 0.0f) {
                tiff.image.setRotation(rotation);
            }
        }
        catch (Exception e) {
            throw new IOException("cannot.read.tiff.image");
        }
    }

    private static void processTiffImageColor(TIFFDirectory dir, RandomAccessFileOrArray s, TiffParameters tiff) {
        try {
            TIFFField predictorField;
            int compression = (int)dir.getFieldAsLong(259);
            int predictor = 1;
            TIFFLZWDecoder lzwDecoder = null;
            switch (compression) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 32773: 
                case 32946: {
                    break;
                }
                default: {
                    throw new IOException("compression {0} is.not.supported").setMessageParams(compression);
                }
            }
            int photometric = (int)dir.getFieldAsLong(262);
            switch (photometric) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    if (compression == 6 || compression == 7) break;
                    throw new IOException("photometric.1.is.not.supported").setMessageParams(photometric);
                }
            }
            float rotation = 0.0f;
            if (dir.isTagPresent(274)) {
                int rot = (int)dir.getFieldAsLong(274);
                if (rot == 3 || rot == 4) {
                    rotation = (float)Math.PI;
                } else if (rot == 5 || rot == 8) {
                    rotation = 1.5707964f;
                } else if (rot == 6 || rot == 7) {
                    rotation = -1.5707964f;
                }
            }
            if (dir.isTagPresent(284) && dir.getFieldAsLong(284) == 2L) {
                throw new IOException("planar.images.are.not.supported");
            }
            int extraSamples = 0;
            if (dir.isTagPresent(338)) {
                extraSamples = 1;
            }
            int samplePerPixel = 1;
            if (dir.isTagPresent(277)) {
                samplePerPixel = (int)dir.getFieldAsLong(277);
            }
            int bitsPerSample = 1;
            if (dir.isTagPresent(258)) {
                bitsPerSample = (int)dir.getFieldAsLong(258);
            }
            switch (bitsPerSample) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new IOException("bits.per.sample {0} is.not.supported").setMessageParams(bitsPerSample);
                }
            }
            int h = (int)dir.getFieldAsLong(257);
            int w = (int)dir.getFieldAsLong(256);
            int resolutionUnit = 2;
            if (dir.isTagPresent(296)) {
                resolutionUnit = (int)dir.getFieldAsLong(296);
            }
            int dpiX = TiffImageHelper.getDpi(dir.getField(282), resolutionUnit);
            int dpiY = TiffImageHelper.getDpi(dir.getField(283), resolutionUnit);
            int fillOrder = 1;
            TIFFField fillOrderField = dir.getField(266);
            if (fillOrderField != null) {
                fillOrder = fillOrderField.getAsInt(0);
            }
            boolean reverse = fillOrder == 2;
            int rowsStrip = h;
            if (dir.isTagPresent(278)) {
                rowsStrip = (int)dir.getFieldAsLong(278);
            }
            if (rowsStrip <= 0 || rowsStrip > h) {
                rowsStrip = h;
            }
            long[] offset = TiffImageHelper.getArrayLongShort(dir, 273);
            long[] size = TiffImageHelper.getArrayLongShort(dir, 279);
            if ((size == null || size.length == 1 && (size[0] == 0L || size[0] + offset[0] > s.length())) && h == rowsStrip) {
                size = new long[]{s.length() - (long)((int)offset[0])};
            }
            if ((compression == 5 || compression == 32946 || compression == 8) && (predictorField = dir.getField(317)) != null) {
                predictor = predictorField.getAsInt(0);
                if (predictor != 1 && predictor != 2) {
                    throw new IOException("illegal.value.for.predictor.in.tiff.file");
                }
                if (predictor == 2 && bitsPerSample != 8) {
                    throw new IOException("{0} bit.samples.are.not.supported.for.horizontal.differencing.predictor").setMessageParams(bitsPerSample);
                }
            }
            if (compression == 5) {
                lzwDecoder = new TIFFLZWDecoder(w, predictor, samplePerPixel);
            }
            int rowsLeft = h;
            ByteArrayOutputStream stream = null;
            ByteArrayOutputStream mstream = null;
            DeflaterOutputStream zip = null;
            DeflaterOutputStream mzip = null;
            if (extraSamples > 0) {
                mstream = new ByteArrayOutputStream();
                mzip = new DeflaterOutputStream(mstream);
            }
            CCITTG4Encoder g4 = null;
            if (bitsPerSample == 1 && samplePerPixel == 1 && photometric != 3) {
                g4 = new CCITTG4Encoder(w);
            } else {
                stream = new ByteArrayOutputStream();
                if (compression != 6 && compression != 7) {
                    zip = new DeflaterOutputStream(stream);
                }
            }
            if (compression == 6) {
                if (!dir.isTagPresent(513)) {
                    throw new IOException("missing.tag.s.for.ojpeg.compression");
                }
                int jpegOffset = (int)dir.getFieldAsLong(513);
                int jpegLength = (int)s.length() - jpegOffset;
                if (dir.isTagPresent(514)) {
                    jpegLength = (int)dir.getFieldAsLong(514) + (int)size[0];
                }
                byte[] jpeg = new byte[Math.min(jpegLength, (int)s.length() - jpegOffset)];
                int posFilePointer = (int)s.getPosition();
                s.seek(posFilePointer += jpegOffset);
                s.readFully(jpeg);
                tiff.image.data = jpeg;
                tiff.image.setOriginalType(ImageType.JPEG);
                JpegImageHelper.processImage(tiff.image);
                tiff.jpegProcessing = true;
            } else if (compression == 7) {
                if (size.length > 1) {
                    throw new IOException("compression.jpeg.is.only.supported.with.a.single.strip.this.image.has {0} strips").setMessageParams(size.length);
                }
                byte[] jpeg = new byte[(int)size[0]];
                s.seek(offset[0]);
                s.readFully(jpeg);
                TIFFField jpegtables = dir.getField(347);
                if (jpegtables != null) {
                    byte[] temp = jpegtables.getAsBytes();
                    int tableoffset = 0;
                    int tablelength = temp.length;
                    if (temp[0] == -1 && temp[1] == -40) {
                        tableoffset = 2;
                        tablelength -= 2;
                    }
                    if (temp[temp.length - 2] == -1 && temp[temp.length - 1] == -39) {
                        tablelength -= 2;
                    }
                    byte[] tables = new byte[tablelength];
                    System.arraycopy(temp, tableoffset, tables, 0, tablelength);
                    byte[] jpegwithtables = new byte[jpeg.length + tables.length];
                    System.arraycopy(jpeg, 0, jpegwithtables, 0, 2);
                    System.arraycopy(tables, 0, jpegwithtables, 2, tables.length);
                    System.arraycopy(jpeg, 2, jpegwithtables, tables.length + 2, jpeg.length - 2);
                    jpeg = jpegwithtables;
                }
                tiff.image.data = jpeg;
                tiff.image.setOriginalType(ImageType.JPEG);
                JpegImageHelper.processImage(tiff.image);
                tiff.jpegProcessing = true;
                if (photometric == 2) {
                    tiff.image.setColorTransform(0);
                }
            } else {
                for (int k = 0; k < offset.length; ++k) {
                    byte[] im = new byte[(int)size[k]];
                    s.seek(offset[k]);
                    s.readFully(im);
                    int height = Math.min(rowsStrip, rowsLeft);
                    byte[] outBuf = null;
                    if (compression != 1) {
                        outBuf = new byte[(w * bitsPerSample * samplePerPixel + 7) / 8 * height];
                    }
                    if (reverse) {
                        TIFFFaxDecoder.reverseBits(im);
                    }
                    switch (compression) {
                        case 8: 
                        case 32946: {
                            FilterUtil.inflateData(im, outBuf);
                            TiffImageHelper.applyPredictor(outBuf, predictor, w, height, samplePerPixel);
                            break;
                        }
                        case 1: {
                            outBuf = im;
                            break;
                        }
                        case 32773: {
                            TiffImageHelper.decodePackbits(im, outBuf);
                            break;
                        }
                        case 5: {
                            lzwDecoder.decode(im, outBuf, height);
                        }
                    }
                    if (bitsPerSample == 1 && samplePerPixel == 1 && photometric != 3) {
                        g4.fax4Encode(outBuf, height);
                    } else if (extraSamples > 0) {
                        TiffImageHelper.processExtraSamples(zip, mzip, outBuf, samplePerPixel, bitsPerSample, w, height);
                    } else {
                        zip.write(outBuf);
                    }
                    rowsLeft -= rowsStrip;
                }
                if (bitsPerSample == 1 && samplePerPixel == 1 && photometric != 3) {
                    RawImageHelper.updateRawImageParameters(tiff.image, w, h, false, 256, photometric == 1 ? 1 : 0, g4.close(), null);
                } else {
                    zip.close();
                    RawImageHelper.updateRawImageParameters(tiff.image, w, h, samplePerPixel - extraSamples, bitsPerSample, stream.toByteArray());
                    tiff.image.setDeflated(true);
                }
            }
            tiff.image.setDpi(dpiX, dpiY);
            if (compression != 6 && compression != 7) {
                if (dir.isTagPresent(34675)) {
                    try {
                        TIFFField fd = dir.getField(34675);
                        IccProfile icc_prof = IccProfile.getInstance(fd.getAsBytes());
                        if (samplePerPixel - extraSamples == icc_prof.getNumComponents()) {
                            tiff.image.setProfile(icc_prof);
                        }
                    }
                    catch (RuntimeException fd) {
                        // empty catch block
                    }
                }
                if (dir.isTagPresent(320)) {
                    int k;
                    TIFFField fd = dir.getField(320);
                    char[] rgb = fd.getAsChars();
                    byte[] palette = new byte[rgb.length];
                    int gColor = rgb.length / 3;
                    int bColor = gColor * 2;
                    for (int k2 = 0; k2 < gColor; ++k2) {
                        palette[k2 * 3] = (byte)(rgb[k2] >> 8);
                        palette[k2 * 3 + 1] = (byte)(rgb[k2 + gColor] >> 8);
                        palette[k2 * 3 + 2] = (byte)(rgb[k2 + bColor] >> 8);
                    }
                    boolean colormapBroken = true;
                    for (k = 0; k < palette.length; ++k) {
                        if (palette[k] == 0) continue;
                        colormapBroken = false;
                        break;
                    }
                    if (colormapBroken) {
                        for (k = 0; k < gColor; ++k) {
                            palette[k * 3] = (byte)rgb[k];
                            palette[k * 3 + 1] = (byte)rgb[k + gColor];
                            palette[k * 3 + 2] = (byte)rgb[k + bColor];
                        }
                    }
                    Object[] indexed = new Object[]{"Indexed", "DeviceRGB", gColor - 1, PdfEncodings.convertToString(palette, null)};
                    tiff.additional = new HashMap<String, Object>();
                    tiff.additional.put("ColorSpace", indexed);
                }
            }
            if (photometric == 0) {
                tiff.image.setInverted(true);
            }
            if (rotation != 0.0f) {
                tiff.image.setRotation(rotation);
            }
            if (extraSamples > 0) {
                mzip.close();
                RawImageData mimg = (RawImageData)ImageDataFactory.createRawImage(null);
                RawImageHelper.updateRawImageParameters(mimg, w, h, 1, bitsPerSample, mstream.toByteArray());
                mimg.makeMask();
                mimg.setDeflated(true);
                tiff.image.setImageMask(mimg);
            }
        }
        catch (Exception e) {
            throw new IOException("cannot.get.tiff.image.color");
        }
    }

    private static int getDpi(TIFFField fd, int resolutionUnit) {
        if (fd == null) {
            return 0;
        }
        long[] res = fd.getAsRational(0);
        float frac = (float)res[0] / (float)res[1];
        int dpi = 0;
        switch (resolutionUnit) {
            case 1: 
            case 2: {
                dpi = (int)((double)frac + 0.5);
                break;
            }
            case 3: {
                dpi = (int)((double)frac * 2.54 + 0.5);
            }
        }
        return dpi;
    }

    private static void processExtraSamples(DeflaterOutputStream zip, DeflaterOutputStream mzip, byte[] outBuf, int samplePerPixel, int bitsPerSample, int width, int height) throws java.io.IOException {
        int optr;
        int mptr;
        byte[] mask;
        if (bitsPerSample == 8) {
            mask = new byte[width * height];
            mptr = 0;
            optr = 0;
            int total = width * height * samplePerPixel;
            for (int k = 0; k < total; k += samplePerPixel) {
                for (int s = 0; s < samplePerPixel - 1; ++s) {
                    outBuf[optr++] = outBuf[k + s];
                }
                mask[mptr++] = outBuf[k + samplePerPixel - 1];
            }
        } else {
            throw new IOException("extra.samples.are.not.supported");
        }
        zip.write(outBuf, 0, optr);
        mzip.write(mask, 0, mptr);
    }

    private static long[] getArrayLongShort(TIFFDirectory dir, int tag) {
        long[] offset;
        TIFFField field = dir.getField(tag);
        if (field == null) {
            return null;
        }
        if (field.getType() == 4) {
            offset = field.getAsLongs();
        } else {
            char[] temp = field.getAsChars();
            offset = new long[temp.length];
            for (int k = 0; k < temp.length; ++k) {
                offset[k] = temp[k];
            }
        }
        return offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static void decodePackbits(byte[] data, byte[] dst) {
        int srcCount = 0;
        int dstCount = 0;
        try {
            block2: while (dstCount < dst.length) {
                int i;
                byte b;
                if ((b = data[srcCount++]) >= 0) {
                    i = 0;
                    while (true) {
                        if (i >= b + 1) continue block2;
                        dst[dstCount++] = data[srcCount++];
                        ++i;
                    }
                }
                if (b <= -1 && b >= -127) {
                    byte repeat = data[srcCount++];
                    i = 0;
                    while (true) {
                        if (i >= -b + 1) continue block2;
                        dst[dstCount++] = repeat;
                        ++i;
                    }
                }
                ++srcCount;
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyPredictor(byte[] uncompData, int predictor, int w, int h, int samplesPerPixel) {
        if (predictor != 2) {
            return;
        }
        for (int j = 0; j < h; ++j) {
            int count = samplesPerPixel * (j * w + 1);
            for (int i = samplesPerPixel; i < w * samplesPerPixel; ++i) {
                int n = count;
                uncompData[n] = (byte)(uncompData[n] + uncompData[count - samplesPerPixel]);
                ++count;
            }
        }
    }

    private static class TiffParameters {
        TiffImageData image;
        boolean jpegProcessing;
        Map<String, Object> additional;

        TiffParameters(TiffImageData image) {
            this.image = image;
        }
    }
}

