/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.cmap;

import com.fr.third.fr.pdf.io.font.cmap.AbstractCMap;
import com.fr.third.fr.pdf.io.font.cmap.CMapContentParser;
import com.fr.third.fr.pdf.io.font.cmap.CMapObject;
import com.fr.third.fr.pdf.io.font.cmap.ICMapLocation;
import com.fr.third.fr.pdf.io.source.PdfTokenizer;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;

public class CMapParser {
    private static final String def = "def";
    private static final String endcidrange = "endcidrange";
    private static final String endcidchar = "endcidchar";
    private static final String endbfrange = "endbfrange";
    private static final String endbfchar = "endbfchar";
    private static final String usecmap = "usecmap";
    private static final String Registry = "Registry";
    private static final String Ordering = "Ordering";
    private static final String Supplement = "Supplement";
    private static final String CMapName = "CMapName";
    private static final int MAX_LEVEL = 10;

    public static void parseCid(String cmapName, AbstractCMap cmap, ICMapLocation location) throws IOException {
        CMapParser.parseCid(cmapName, cmap, location, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCid(String cmapName, AbstractCMap cmap, ICMapLocation location, int level) throws IOException {
        if (level >= 10) {
            return;
        }
        PdfTokenizer inp = location.getLocation(cmapName);
        try {
            ArrayList<CMapObject> list = new ArrayList<CMapObject>();
            CMapContentParser cp = new CMapContentParser(inp);
            int maxExc = 50;
            block9: while (true) {
                try {
                    cp.parse(list);
                }
                catch (Exception ex) {
                    if (--maxExc >= 0) continue;
                    break;
                }
                if (list.size() == 0) {
                    break;
                }
                String last = ((CMapObject)list.get(list.size() - 1)).toString();
                if (level == 0 && list.size() == 3 && last.equals(def)) {
                    CMapObject cmapObject = (CMapObject)list.get(0);
                    if (Registry.equals(cmapObject.toString())) {
                        cmap.setRegistry(((CMapObject)list.get(1)).toString());
                        continue;
                    }
                    if (Ordering.equals(cmapObject.toString())) {
                        cmap.setOrdering(((CMapObject)list.get(1)).toString());
                        continue;
                    }
                    if (CMapName.equals(cmapObject.toString())) {
                        cmap.setName(((CMapObject)list.get(1)).toString());
                        continue;
                    }
                    if (!Supplement.equals(cmapObject.toString())) continue;
                    try {
                        cmap.setSupplement((Integer)((CMapObject)list.get(1)).getValue());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ((last.equals(endcidchar) || last.equals(endbfchar)) && list.size() >= 3) {
                    int lMax = list.size() - 2;
                    int k = 0;
                    while (true) {
                        if (k >= lMax) continue block9;
                        if (((CMapObject)list.get(k)).isString()) {
                            cmap.addChar(((CMapObject)list.get(k)).toString(), (CMapObject)list.get(k + 1));
                        }
                        k += 2;
                    }
                }
                if ((last.equals(endcidrange) || last.equals(endbfrange)) && list.size() >= 4) {
                    int lMax = list.size() - 3;
                    int k = 0;
                    while (true) {
                        if (k >= lMax) continue block9;
                        if (((CMapObject)list.get(k)).isString() && ((CMapObject)list.get(k + 1)).isString()) {
                            cmap.addRange(((CMapObject)list.get(k)).toString(), ((CMapObject)list.get(k + 1)).toString(), (CMapObject)list.get(k + 2));
                        }
                        k += 3;
                    }
                }
                if (!last.equals(usecmap) || list.size() != 2 || !((CMapObject)list.get(0)).isName()) continue;
                CMapParser.parseCid(((CMapObject)list.get(0)).toString(), cmap, location, level + 1);
            }
        }
        catch (Exception ex) {
            Logger logger = LoggerFactory.getLogger(CMapParser.class);
            logger.error("Unknown error while processing CMap.");
        }
        finally {
            inp.close();
        }
    }
}

