/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf.codec;

public class TIFFFaxDecoder {
    private int bitPointer;
    private int bytePointer;
    private byte[] data;
    private int w;
    private int h;
    private int fillOrder;
    private int changingElemSize = 0;
    private int[] prevChangingElems;
    private int[] currChangingElems;
    private int lastChangingElement = 0;
    private int compression = 2;
    private int uncompressedMode = 0;
    private int fillBits = 0;
    private int oneD;
    static int[] table1;
    static int[] table2;
    static byte[] flipTable;
    static short[] white;
    static short[] additionalMakeup;
    static short[] initBlack;
    static short[] twoBitBlack;
    static short[] black;
    static byte[] twoDCodes;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        table1 = nArray;
        int[] nArray2 = new int[9];
        nArray2[1] = 128;
        nArray2[2] = 192;
        nArray2[3] = 224;
        nArray2[4] = 240;
        nArray2[5] = 248;
        nArray2[6] = 252;
        nArray2[7] = 254;
        nArray2[8] = 255;
        table2 = nArray2;
        byte[] byArray = new byte[256];
        byArray[1] = -128;
        byArray[2] = 64;
        byArray[3] = -64;
        byArray[4] = 32;
        byArray[5] = -96;
        byArray[6] = 96;
        byArray[7] = -32;
        byArray[8] = 16;
        byArray[9] = -112;
        byArray[10] = 80;
        byArray[11] = -48;
        byArray[12] = 48;
        byArray[13] = -80;
        byArray[14] = 112;
        byArray[15] = -16;
        byArray[16] = 8;
        byArray[17] = -120;
        byArray[18] = 72;
        byArray[19] = -56;
        byArray[20] = 40;
        byArray[21] = -88;
        byArray[22] = 104;
        byArray[23] = -24;
        byArray[24] = 24;
        byArray[25] = -104;
        byArray[26] = 88;
        byArray[27] = -40;
        byArray[28] = 56;
        byArray[29] = -72;
        byArray[30] = 120;
        byArray[31] = -8;
        byArray[32] = 4;
        byArray[33] = -124;
        byArray[34] = 68;
        byArray[35] = -60;
        byArray[36] = 36;
        byArray[37] = -92;
        byArray[38] = 100;
        byArray[39] = -28;
        byArray[40] = 20;
        byArray[41] = -108;
        byArray[42] = 84;
        byArray[43] = -44;
        byArray[44] = 52;
        byArray[45] = -76;
        byArray[46] = 116;
        byArray[47] = -12;
        byArray[48] = 12;
        byArray[49] = -116;
        byArray[50] = 76;
        byArray[51] = -52;
        byArray[52] = 44;
        byArray[53] = -84;
        byArray[54] = 108;
        byArray[55] = -20;
        byArray[56] = 28;
        byArray[57] = -100;
        byArray[58] = 92;
        byArray[59] = -36;
        byArray[60] = 60;
        byArray[61] = -68;
        byArray[62] = 124;
        byArray[63] = -4;
        byArray[64] = 2;
        byArray[65] = -126;
        byArray[66] = 66;
        byArray[67] = -62;
        byArray[68] = 34;
        byArray[69] = -94;
        byArray[70] = 98;
        byArray[71] = -30;
        byArray[72] = 18;
        byArray[73] = -110;
        byArray[74] = 82;
        byArray[75] = -46;
        byArray[76] = 50;
        byArray[77] = -78;
        byArray[78] = 114;
        byArray[79] = -14;
        byArray[80] = 10;
        byArray[81] = -118;
        byArray[82] = 74;
        byArray[83] = -54;
        byArray[84] = 42;
        byArray[85] = -86;
        byArray[86] = 106;
        byArray[87] = -22;
        byArray[88] = 26;
        byArray[89] = -102;
        byArray[90] = 90;
        byArray[91] = -38;
        byArray[92] = 58;
        byArray[93] = -70;
        byArray[94] = 122;
        byArray[95] = -6;
        byArray[96] = 6;
        byArray[97] = -122;
        byArray[98] = 70;
        byArray[99] = -58;
        byArray[100] = 38;
        byArray[101] = -90;
        byArray[102] = 102;
        byArray[103] = -26;
        byArray[104] = 22;
        byArray[105] = -106;
        byArray[106] = 86;
        byArray[107] = -42;
        byArray[108] = 54;
        byArray[109] = -74;
        byArray[110] = 118;
        byArray[111] = -10;
        byArray[112] = 14;
        byArray[113] = -114;
        byArray[114] = 78;
        byArray[115] = -50;
        byArray[116] = 46;
        byArray[117] = -82;
        byArray[118] = 110;
        byArray[119] = -18;
        byArray[120] = 30;
        byArray[121] = -98;
        byArray[122] = 94;
        byArray[123] = -34;
        byArray[124] = 62;
        byArray[125] = -66;
        byArray[126] = 126;
        byArray[127] = -2;
        byArray[128] = 1;
        byArray[129] = -127;
        byArray[130] = 65;
        byArray[131] = -63;
        byArray[132] = 33;
        byArray[133] = -95;
        byArray[134] = 97;
        byArray[135] = -31;
        byArray[136] = 17;
        byArray[137] = -111;
        byArray[138] = 81;
        byArray[139] = -47;
        byArray[140] = 49;
        byArray[141] = -79;
        byArray[142] = 113;
        byArray[143] = -15;
        byArray[144] = 9;
        byArray[145] = -119;
        byArray[146] = 73;
        byArray[147] = -55;
        byArray[148] = 41;
        byArray[149] = -87;
        byArray[150] = 105;
        byArray[151] = -23;
        byArray[152] = 25;
        byArray[153] = -103;
        byArray[154] = 89;
        byArray[155] = -39;
        byArray[156] = 57;
        byArray[157] = -71;
        byArray[158] = 121;
        byArray[159] = -7;
        byArray[160] = 5;
        byArray[161] = -123;
        byArray[162] = 69;
        byArray[163] = -59;
        byArray[164] = 37;
        byArray[165] = -91;
        byArray[166] = 101;
        byArray[167] = -27;
        byArray[168] = 21;
        byArray[169] = -107;
        byArray[170] = 85;
        byArray[171] = -43;
        byArray[172] = 53;
        byArray[173] = -75;
        byArray[174] = 117;
        byArray[175] = -11;
        byArray[176] = 13;
        byArray[177] = -115;
        byArray[178] = 77;
        byArray[179] = -51;
        byArray[180] = 45;
        byArray[181] = -83;
        byArray[182] = 109;
        byArray[183] = -19;
        byArray[184] = 29;
        byArray[185] = -99;
        byArray[186] = 93;
        byArray[187] = -35;
        byArray[188] = 61;
        byArray[189] = -67;
        byArray[190] = 125;
        byArray[191] = -3;
        byArray[192] = 3;
        byArray[193] = -125;
        byArray[194] = 67;
        byArray[195] = -61;
        byArray[196] = 35;
        byArray[197] = -93;
        byArray[198] = 99;
        byArray[199] = -29;
        byArray[200] = 19;
        byArray[201] = -109;
        byArray[202] = 83;
        byArray[203] = -45;
        byArray[204] = 51;
        byArray[205] = -77;
        byArray[206] = 115;
        byArray[207] = -13;
        byArray[208] = 11;
        byArray[209] = -117;
        byArray[210] = 75;
        byArray[211] = -53;
        byArray[212] = 43;
        byArray[213] = -85;
        byArray[214] = 107;
        byArray[215] = -21;
        byArray[216] = 27;
        byArray[217] = -101;
        byArray[218] = 91;
        byArray[219] = -37;
        byArray[220] = 59;
        byArray[221] = -69;
        byArray[222] = 123;
        byArray[223] = -5;
        byArray[224] = 7;
        byArray[225] = -121;
        byArray[226] = 71;
        byArray[227] = -57;
        byArray[228] = 39;
        byArray[229] = -89;
        byArray[230] = 103;
        byArray[231] = -25;
        byArray[232] = 23;
        byArray[233] = -105;
        byArray[234] = 87;
        byArray[235] = -41;
        byArray[236] = 55;
        byArray[237] = -73;
        byArray[238] = 119;
        byArray[239] = -9;
        byArray[240] = 15;
        byArray[241] = -113;
        byArray[242] = 79;
        byArray[243] = -49;
        byArray[244] = 47;
        byArray[245] = -81;
        byArray[246] = 111;
        byArray[247] = -17;
        byArray[248] = 31;
        byArray[249] = -97;
        byArray[250] = 95;
        byArray[251] = -33;
        byArray[252] = 63;
        byArray[253] = -65;
        byArray[254] = 127;
        byArray[255] = -1;
        flipTable = byArray;
        white = new short[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
        additionalMakeup = new short[]{28679, 28679, 31752, -32759, -31735, -30711, -29687, -28663, 29703, 29703, 30727, 30727, -27639, -26615, -25591, -24567};
        initBlack = new short[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
        twoBitBlack = new short[]{292, 260, 226, 226};
        short[] sArray = new short[512];
        sArray[0] = 62;
        sArray[1] = 62;
        sArray[2] = 30;
        sArray[3] = 30;
        sArray[32] = 3225;
        sArray[33] = 3225;
        sArray[34] = 3225;
        sArray[35] = 3225;
        sArray[36] = 3225;
        sArray[37] = 3225;
        sArray[38] = 3225;
        sArray[39] = 3225;
        sArray[40] = 3225;
        sArray[41] = 3225;
        sArray[42] = 3225;
        sArray[43] = 3225;
        sArray[44] = 3225;
        sArray[45] = 3225;
        sArray[46] = 3225;
        sArray[47] = 3225;
        sArray[48] = 3225;
        sArray[49] = 3225;
        sArray[50] = 3225;
        sArray[51] = 3225;
        sArray[52] = 3225;
        sArray[53] = 3225;
        sArray[54] = 3225;
        sArray[55] = 3225;
        sArray[56] = 3225;
        sArray[57] = 3225;
        sArray[58] = 3225;
        sArray[59] = 3225;
        sArray[60] = 3225;
        sArray[61] = 3225;
        sArray[62] = 3225;
        sArray[63] = 3225;
        sArray[64] = 588;
        sArray[65] = 588;
        sArray[66] = 588;
        sArray[67] = 588;
        sArray[68] = 588;
        sArray[69] = 588;
        sArray[70] = 588;
        sArray[71] = 588;
        sArray[72] = 1680;
        sArray[73] = 1680;
        sArray[74] = 20499;
        sArray[75] = 22547;
        sArray[76] = 24595;
        sArray[77] = 26643;
        sArray[78] = 1776;
        sArray[79] = 1776;
        sArray[80] = 1808;
        sArray[81] = 1808;
        sArray[82] = -24557;
        sArray[83] = -22509;
        sArray[84] = -20461;
        sArray[85] = -18413;
        sArray[86] = 1904;
        sArray[87] = 1904;
        sArray[88] = 1936;
        sArray[89] = 1936;
        sArray[90] = -16365;
        sArray[91] = -14317;
        sArray[92] = 782;
        sArray[93] = 782;
        sArray[94] = 782;
        sArray[95] = 782;
        sArray[96] = 814;
        sArray[97] = 814;
        sArray[98] = 814;
        sArray[99] = 814;
        sArray[100] = -12269;
        sArray[101] = -10221;
        sArray[102] = 10257;
        sArray[103] = 10257;
        sArray[104] = 12305;
        sArray[105] = 12305;
        sArray[106] = 14353;
        sArray[107] = 14353;
        sArray[108] = 16403;
        sArray[109] = 18451;
        sArray[110] = 1712;
        sArray[111] = 1712;
        sArray[112] = 1744;
        sArray[113] = 1744;
        sArray[114] = 28691;
        sArray[115] = 30739;
        sArray[116] = -32749;
        sArray[117] = -30701;
        sArray[118] = -28653;
        sArray[119] = -26605;
        sArray[120] = 2061;
        sArray[121] = 2061;
        sArray[122] = 2061;
        sArray[123] = 2061;
        sArray[124] = 2061;
        sArray[125] = 2061;
        sArray[126] = 2061;
        sArray[127] = 2061;
        sArray[128] = 424;
        sArray[129] = 424;
        sArray[130] = 424;
        sArray[131] = 424;
        sArray[132] = 424;
        sArray[133] = 424;
        sArray[134] = 424;
        sArray[135] = 424;
        sArray[136] = 424;
        sArray[137] = 424;
        sArray[138] = 424;
        sArray[139] = 424;
        sArray[140] = 424;
        sArray[141] = 424;
        sArray[142] = 424;
        sArray[143] = 424;
        sArray[144] = 424;
        sArray[145] = 424;
        sArray[146] = 424;
        sArray[147] = 424;
        sArray[148] = 424;
        sArray[149] = 424;
        sArray[150] = 424;
        sArray[151] = 424;
        sArray[152] = 424;
        sArray[153] = 424;
        sArray[154] = 424;
        sArray[155] = 424;
        sArray[156] = 424;
        sArray[157] = 424;
        sArray[158] = 424;
        sArray[159] = 424;
        sArray[160] = 750;
        sArray[161] = 750;
        sArray[162] = 750;
        sArray[163] = 750;
        sArray[164] = 1616;
        sArray[165] = 1616;
        sArray[166] = 1648;
        sArray[167] = 1648;
        sArray[168] = 1424;
        sArray[169] = 1424;
        sArray[170] = 1456;
        sArray[171] = 1456;
        sArray[172] = 1488;
        sArray[173] = 1488;
        sArray[174] = 1520;
        sArray[175] = 1520;
        sArray[176] = 1840;
        sArray[177] = 1840;
        sArray[178] = 1872;
        sArray[179] = 1872;
        sArray[180] = 1968;
        sArray[181] = 1968;
        sArray[182] = 8209;
        sArray[183] = 8209;
        sArray[184] = 524;
        sArray[185] = 524;
        sArray[186] = 524;
        sArray[187] = 524;
        sArray[188] = 524;
        sArray[189] = 524;
        sArray[190] = 524;
        sArray[191] = 524;
        sArray[192] = 556;
        sArray[193] = 556;
        sArray[194] = 556;
        sArray[195] = 556;
        sArray[196] = 556;
        sArray[197] = 556;
        sArray[198] = 556;
        sArray[199] = 556;
        sArray[200] = 1552;
        sArray[201] = 1552;
        sArray[202] = 1584;
        sArray[203] = 1584;
        sArray[204] = 2000;
        sArray[205] = 2000;
        sArray[206] = 2032;
        sArray[207] = 2032;
        sArray[208] = 976;
        sArray[209] = 976;
        sArray[210] = 1008;
        sArray[211] = 1008;
        sArray[212] = 1040;
        sArray[213] = 1040;
        sArray[214] = 1072;
        sArray[215] = 1072;
        sArray[216] = 1296;
        sArray[217] = 1296;
        sArray[218] = 1328;
        sArray[219] = 1328;
        sArray[220] = 718;
        sArray[221] = 718;
        sArray[222] = 718;
        sArray[223] = 718;
        sArray[224] = 456;
        sArray[225] = 456;
        sArray[226] = 456;
        sArray[227] = 456;
        sArray[228] = 456;
        sArray[229] = 456;
        sArray[230] = 456;
        sArray[231] = 456;
        sArray[232] = 456;
        sArray[233] = 456;
        sArray[234] = 456;
        sArray[235] = 456;
        sArray[236] = 456;
        sArray[237] = 456;
        sArray[238] = 456;
        sArray[239] = 456;
        sArray[240] = 456;
        sArray[241] = 456;
        sArray[242] = 456;
        sArray[243] = 456;
        sArray[244] = 456;
        sArray[245] = 456;
        sArray[246] = 456;
        sArray[247] = 456;
        sArray[248] = 456;
        sArray[249] = 456;
        sArray[250] = 456;
        sArray[251] = 456;
        sArray[252] = 456;
        sArray[253] = 456;
        sArray[254] = 456;
        sArray[255] = 456;
        sArray[256] = 326;
        sArray[257] = 326;
        sArray[258] = 326;
        sArray[259] = 326;
        sArray[260] = 326;
        sArray[261] = 326;
        sArray[262] = 326;
        sArray[263] = 326;
        sArray[264] = 326;
        sArray[265] = 326;
        sArray[266] = 326;
        sArray[267] = 326;
        sArray[268] = 326;
        sArray[269] = 326;
        sArray[270] = 326;
        sArray[271] = 326;
        sArray[272] = 326;
        sArray[273] = 326;
        sArray[274] = 326;
        sArray[275] = 326;
        sArray[276] = 326;
        sArray[277] = 326;
        sArray[278] = 326;
        sArray[279] = 326;
        sArray[280] = 326;
        sArray[281] = 326;
        sArray[282] = 326;
        sArray[283] = 326;
        sArray[284] = 326;
        sArray[285] = 326;
        sArray[286] = 326;
        sArray[287] = 326;
        sArray[288] = 326;
        sArray[289] = 326;
        sArray[290] = 326;
        sArray[291] = 326;
        sArray[292] = 326;
        sArray[293] = 326;
        sArray[294] = 326;
        sArray[295] = 326;
        sArray[296] = 326;
        sArray[297] = 326;
        sArray[298] = 326;
        sArray[299] = 326;
        sArray[300] = 326;
        sArray[301] = 326;
        sArray[302] = 326;
        sArray[303] = 326;
        sArray[304] = 326;
        sArray[305] = 326;
        sArray[306] = 326;
        sArray[307] = 326;
        sArray[308] = 326;
        sArray[309] = 326;
        sArray[310] = 326;
        sArray[311] = 326;
        sArray[312] = 326;
        sArray[313] = 326;
        sArray[314] = 326;
        sArray[315] = 326;
        sArray[316] = 326;
        sArray[317] = 326;
        sArray[318] = 326;
        sArray[319] = 326;
        sArray[320] = 358;
        sArray[321] = 358;
        sArray[322] = 358;
        sArray[323] = 358;
        sArray[324] = 358;
        sArray[325] = 358;
        sArray[326] = 358;
        sArray[327] = 358;
        sArray[328] = 358;
        sArray[329] = 358;
        sArray[330] = 358;
        sArray[331] = 358;
        sArray[332] = 358;
        sArray[333] = 358;
        sArray[334] = 358;
        sArray[335] = 358;
        sArray[336] = 358;
        sArray[337] = 358;
        sArray[338] = 358;
        sArray[339] = 358;
        sArray[340] = 358;
        sArray[341] = 358;
        sArray[342] = 358;
        sArray[343] = 358;
        sArray[344] = 358;
        sArray[345] = 358;
        sArray[346] = 358;
        sArray[347] = 358;
        sArray[348] = 358;
        sArray[349] = 358;
        sArray[350] = 358;
        sArray[351] = 358;
        sArray[352] = 358;
        sArray[353] = 358;
        sArray[354] = 358;
        sArray[355] = 358;
        sArray[356] = 358;
        sArray[357] = 358;
        sArray[358] = 358;
        sArray[359] = 358;
        sArray[360] = 358;
        sArray[361] = 358;
        sArray[362] = 358;
        sArray[363] = 358;
        sArray[364] = 358;
        sArray[365] = 358;
        sArray[366] = 358;
        sArray[367] = 358;
        sArray[368] = 358;
        sArray[369] = 358;
        sArray[370] = 358;
        sArray[371] = 358;
        sArray[372] = 358;
        sArray[373] = 358;
        sArray[374] = 358;
        sArray[375] = 358;
        sArray[376] = 358;
        sArray[377] = 358;
        sArray[378] = 358;
        sArray[379] = 358;
        sArray[380] = 358;
        sArray[381] = 358;
        sArray[382] = 358;
        sArray[383] = 358;
        sArray[384] = 490;
        sArray[385] = 490;
        sArray[386] = 490;
        sArray[387] = 490;
        sArray[388] = 490;
        sArray[389] = 490;
        sArray[390] = 490;
        sArray[391] = 490;
        sArray[392] = 490;
        sArray[393] = 490;
        sArray[394] = 490;
        sArray[395] = 490;
        sArray[396] = 490;
        sArray[397] = 490;
        sArray[398] = 490;
        sArray[399] = 490;
        sArray[400] = 4113;
        sArray[401] = 4113;
        sArray[402] = 6161;
        sArray[403] = 6161;
        sArray[404] = 848;
        sArray[405] = 848;
        sArray[406] = 880;
        sArray[407] = 880;
        sArray[408] = 912;
        sArray[409] = 912;
        sArray[410] = 944;
        sArray[411] = 944;
        sArray[412] = 622;
        sArray[413] = 622;
        sArray[414] = 622;
        sArray[415] = 622;
        sArray[416] = 654;
        sArray[417] = 654;
        sArray[418] = 654;
        sArray[419] = 654;
        sArray[420] = 1104;
        sArray[421] = 1104;
        sArray[422] = 1136;
        sArray[423] = 1136;
        sArray[424] = 1168;
        sArray[425] = 1168;
        sArray[426] = 1200;
        sArray[427] = 1200;
        sArray[428] = 1232;
        sArray[429] = 1232;
        sArray[430] = 1264;
        sArray[431] = 1264;
        sArray[432] = 686;
        sArray[433] = 686;
        sArray[434] = 686;
        sArray[435] = 686;
        sArray[436] = 1360;
        sArray[437] = 1360;
        sArray[438] = 1392;
        sArray[439] = 1392;
        sArray[440] = 12;
        sArray[441] = 12;
        sArray[442] = 12;
        sArray[443] = 12;
        sArray[444] = 12;
        sArray[445] = 12;
        sArray[446] = 12;
        sArray[447] = 12;
        sArray[448] = 390;
        sArray[449] = 390;
        sArray[450] = 390;
        sArray[451] = 390;
        sArray[452] = 390;
        sArray[453] = 390;
        sArray[454] = 390;
        sArray[455] = 390;
        sArray[456] = 390;
        sArray[457] = 390;
        sArray[458] = 390;
        sArray[459] = 390;
        sArray[460] = 390;
        sArray[461] = 390;
        sArray[462] = 390;
        sArray[463] = 390;
        sArray[464] = 390;
        sArray[465] = 390;
        sArray[466] = 390;
        sArray[467] = 390;
        sArray[468] = 390;
        sArray[469] = 390;
        sArray[470] = 390;
        sArray[471] = 390;
        sArray[472] = 390;
        sArray[473] = 390;
        sArray[474] = 390;
        sArray[475] = 390;
        sArray[476] = 390;
        sArray[477] = 390;
        sArray[478] = 390;
        sArray[479] = 390;
        sArray[480] = 390;
        sArray[481] = 390;
        sArray[482] = 390;
        sArray[483] = 390;
        sArray[484] = 390;
        sArray[485] = 390;
        sArray[486] = 390;
        sArray[487] = 390;
        sArray[488] = 390;
        sArray[489] = 390;
        sArray[490] = 390;
        sArray[491] = 390;
        sArray[492] = 390;
        sArray[493] = 390;
        sArray[494] = 390;
        sArray[495] = 390;
        sArray[496] = 390;
        sArray[497] = 390;
        sArray[498] = 390;
        sArray[499] = 390;
        sArray[500] = 390;
        sArray[501] = 390;
        sArray[502] = 390;
        sArray[503] = 390;
        sArray[504] = 390;
        sArray[505] = 390;
        sArray[506] = 390;
        sArray[507] = 390;
        sArray[508] = 390;
        sArray[509] = 390;
        sArray[510] = 390;
        sArray[511] = 390;
        black = sArray;
        twoDCodes = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};
    }

    public TIFFFaxDecoder(int fillOrder, int w, int h) {
        this.fillOrder = fillOrder;
        this.w = w;
        this.h = h;
        this.bitPointer = 0;
        this.bytePointer = 0;
        this.prevChangingElems = new int[w];
        this.currChangingElems = new int[w];
    }

    public static void reverseBits(byte[] b) {
        int k = 0;
        while (k < b.length) {
            b[k] = flipTable[b[k] & 0xFF];
            ++k;
        }
    }

    public void decode1D(byte[] buffer, byte[] compData, int startX, int height) {
        this.data = compData;
        int lineOffset = 0;
        int scanlineStride = (this.w + 7) / 8;
        this.bitPointer = 0;
        this.bytePointer = 0;
        int i = 0;
        while (i < height) {
            this.decodeNextScanline(buffer, lineOffset, startX);
            lineOffset += scanlineStride;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decodeNextScanline(byte[] buffer, int lineOffset, int bitOffset) {
        bits = 0;
        code = 0;
        isT = 0;
        isWhite = true;
        this.changingElemSize = 0;
        ** GOTO lbl87
        {
            current = this.nextNBits(10);
            entry = TIFFFaxDecoder.white[current];
            isT = entry & 1;
            bits = entry >>> 1 & 15;
            if (bits == 12) {
                twoBits = this.nextLesserThan8Bits(2);
                current = current << 2 & 12 | twoBits;
                entry = TIFFFaxDecoder.additionalMakeup[current];
                bits = entry >>> 1 & 7;
                code = entry >>> 4 & 4095;
                bitOffset += code;
                this.updatePointer(4 - bits);
            } else {
                if (bits == 0) {
                    throw new RuntimeException("Invalid code encountered.");
                }
                if (bits == 15) {
                    throw new RuntimeException("EOL code word encountered in White run.");
                }
                code = entry >>> 5 & 2047;
                bitOffset += code;
                this.updatePointer(10 - bits);
                if (isT == 0) {
                    isWhite = false;
                    this.currChangingElems[this.changingElemSize++] = bitOffset;
                }
            }
            do {
                if (isWhite) continue block0;
                if (bitOffset != this.w) ** GOTO lbl81
                if (this.compression != 2) break block0;
                this.advancePointer();
                break block0;
lbl-1000:
                // 1 sources

                {
                    current = this.nextLesserThan8Bits(4);
                    entry = TIFFFaxDecoder.initBlack[current];
                    isT = entry & 1;
                    bits = entry >>> 1 & 15;
                    code = entry >>> 5 & 2047;
                    if (code == 100) {
                        current = this.nextNBits(9);
                        entry = TIFFFaxDecoder.black[current];
                        isT = entry & 1;
                        bits = entry >>> 1 & 15;
                        code = entry >>> 5 & 2047;
                        if (bits == 12) {
                            this.updatePointer(5);
                            current = this.nextLesserThan8Bits(4);
                            entry = TIFFFaxDecoder.additionalMakeup[current];
                            bits = entry >>> 1 & 7;
                            code = entry >>> 4 & 4095;
                            this.setToBlack(buffer, lineOffset, bitOffset, code);
                            bitOffset += code;
                            this.updatePointer(4 - bits);
                            continue;
                        }
                        if (bits == 15) {
                            throw new RuntimeException("EOL code word encountered in Black run.");
                        }
                        this.setToBlack(buffer, lineOffset, bitOffset, code);
                        bitOffset += code;
                        this.updatePointer(9 - bits);
                        if (isT != 0) continue;
                        isWhite = true;
                        this.currChangingElems[this.changingElemSize++] = bitOffset;
                        continue;
                    }
                    if (code == 200) {
                        current = this.nextLesserThan8Bits(2);
                        entry = TIFFFaxDecoder.twoBitBlack[current];
                        code = entry >>> 5 & 2047;
                        bits = entry >>> 1 & 15;
                        this.setToBlack(buffer, lineOffset, bitOffset, code);
                        this.updatePointer(2 - bits);
                        isWhite = true;
                        this.currChangingElems[this.changingElemSize++] = bitOffset += code;
                        continue;
                    }
                    this.setToBlack(buffer, lineOffset, bitOffset, code);
                    this.updatePointer(4 - bits);
                    isWhite = true;
                    this.currChangingElems[this.changingElemSize++] = bitOffset += code;
lbl81:
                    // 6 sources

                    ** while (!isWhite)
                }
lbl82:
                // 1 sources

                if (bitOffset != this.w) continue;
                if (this.compression != 2) break block0;
                this.advancePointer();
                break block0;
lbl87:
                // 2 sources

            } while (bitOffset < this.w);
        }
        this.currChangingElems[this.changingElemSize++] = bitOffset;
    }

    public void decode2D(byte[] buffer, byte[] compData, int startX, int height, long tiffT4Options) {
        this.data = compData;
        this.compression = 3;
        this.bitPointer = 0;
        this.bytePointer = 0;
        int scanlineStride = (this.w + 7) / 8;
        int[] b = new int[2];
        int currIndex = 0;
        this.oneD = (int)(tiffT4Options & 1L);
        this.uncompressedMode = (int)((tiffT4Options & 2L) >> 1);
        this.fillBits = (int)((tiffT4Options & 4L) >> 2);
        if (this.readEOL(true) != 1) {
            throw new RuntimeException("First scanline must be 1D encoded.");
        }
        int lineOffset = 0;
        this.decodeNextScanline(buffer, lineOffset, startX);
        lineOffset += scanlineStride;
        int lines = 1;
        while (lines < height) {
            if (this.readEOL(false) == 0) {
                int[] temp = this.prevChangingElems;
                this.prevChangingElems = this.currChangingElems;
                this.currChangingElems = temp;
                currIndex = 0;
                int a0 = -1;
                boolean isWhite = true;
                int bitOffset = startX;
                this.lastChangingElement = 0;
                while (bitOffset < this.w) {
                    this.getNextChangingElement(a0, isWhite, b);
                    int b1 = b[0];
                    int b2 = b[1];
                    int entry = this.nextLesserThan8Bits(7);
                    entry = twoDCodes[entry] & 0xFF;
                    int code = (entry & 0x78) >>> 3;
                    int bits = entry & 7;
                    if (code == 0) {
                        if (!isWhite) {
                            this.setToBlack(buffer, lineOffset, bitOffset, b2 - bitOffset);
                        }
                        bitOffset = a0 = b2;
                        this.updatePointer(7 - bits);
                        continue;
                    }
                    if (code == 1) {
                        int number;
                        this.updatePointer(7 - bits);
                        if (isWhite) {
                            number = this.decodeWhiteCodeWord();
                            this.currChangingElems[currIndex++] = bitOffset += number;
                            number = this.decodeBlackCodeWord();
                            this.setToBlack(buffer, lineOffset, bitOffset, number);
                            this.currChangingElems[currIndex++] = bitOffset += number;
                        } else {
                            number = this.decodeBlackCodeWord();
                            this.setToBlack(buffer, lineOffset, bitOffset, number);
                            this.currChangingElems[currIndex++] = bitOffset += number;
                            number = this.decodeWhiteCodeWord();
                            this.currChangingElems[currIndex++] = bitOffset += number;
                        }
                        a0 = bitOffset;
                        continue;
                    }
                    if (code <= 8) {
                        int a1 = b1 + (code - 5);
                        this.currChangingElems[currIndex++] = a1;
                        if (!isWhite) {
                            this.setToBlack(buffer, lineOffset, bitOffset, a1 - bitOffset);
                        }
                        bitOffset = a0 = a1;
                        isWhite = !isWhite;
                        this.updatePointer(7 - bits);
                        continue;
                    }
                    throw new RuntimeException("Invalid code encountered while decoding 2D group 3 compressed data.");
                }
                this.currChangingElems[currIndex++] = bitOffset;
                this.changingElemSize = currIndex;
            } else {
                this.decodeNextScanline(buffer, lineOffset, startX);
            }
            lineOffset += scanlineStride;
            ++lines;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decodeT6(byte[] buffer, byte[] compData, int startX, int height, long tiffT6Options) {
        this.data = compData;
        this.compression = 4;
        this.bitPointer = 0;
        this.bytePointer = 0;
        scanlineStride = (this.w + 7) / 8;
        b = new int[2];
        this.uncompressedMode = (int)((tiffT6Options & 2L) >> 1);
        cce = this.currChangingElems;
        this.changingElemSize = 0;
        cce[this.changingElemSize++] = this.w;
        cce[this.changingElemSize++] = this.w;
        lineOffset = 0;
        lines = 0;
        while (lines < height) {
            a0 = -1;
            isWhite = true;
            temp = this.prevChangingElems;
            this.prevChangingElems = this.currChangingElems;
            this.currChangingElems = temp;
            cce = temp;
            currIndex = 0;
            bitOffset = startX;
            this.lastChangingElement = 0;
            while (bitOffset < this.w) {
                block22: {
                    this.getNextChangingElement(a0, isWhite, b);
                    b1 = b[0];
                    b2 = b[1];
                    entry = this.nextLesserThan8Bits(7);
                    entry = TIFFFaxDecoder.twoDCodes[entry] & 255;
                    code = (entry & 120) >>> 3;
                    bits = entry & 7;
                    if (code == 0) {
                        if (!isWhite) {
                            this.setToBlack(buffer, lineOffset, bitOffset, b2 - bitOffset);
                        }
                        bitOffset = a0 = b2;
                        this.updatePointer(7 - bits);
                        continue;
                    }
                    if (code == 1) {
                        this.updatePointer(7 - bits);
                        if (isWhite) {
                            number = this.decodeWhiteCodeWord();
                            cce[currIndex++] = bitOffset += number;
                            number = this.decodeBlackCodeWord();
                            this.setToBlack(buffer, lineOffset, bitOffset, number);
                            cce[currIndex++] = bitOffset += number;
                        } else {
                            number = this.decodeBlackCodeWord();
                            this.setToBlack(buffer, lineOffset, bitOffset, number);
                            cce[currIndex++] = bitOffset += number;
                            number = this.decodeWhiteCodeWord();
                            cce[currIndex++] = bitOffset += number;
                        }
                        a0 = bitOffset;
                        continue;
                    }
                    if (code <= 8) {
                        a1 = b1 + (code - 5);
                        cce[currIndex++] = a1;
                        if (!isWhite) {
                            this.setToBlack(buffer, lineOffset, bitOffset, a1 - bitOffset);
                        }
                        bitOffset = a0 = a1;
                        isWhite = isWhite == false;
                        this.updatePointer(7 - bits);
                        continue;
                    }
                    if (code != 11) break block22;
                    if (this.nextLesserThan8Bits(3) != 7) {
                        throw new RuntimeException("Invalid code encountered while decoding 2D group 4 compressed data.");
                    }
                    zeros = 0;
                    exit = false;
                    ** GOTO lbl97
                    {
                        ++zeros;
                        do {
                            if (this.nextLesserThan8Bits(1) != 1) continue block2;
                            if (zeros > 5) {
                                if (!isWhite && (zeros -= 6) > 0) {
                                    cce[currIndex++] = bitOffset;
                                }
                                bitOffset += zeros;
                                if (zeros > 0) {
                                    isWhite = true;
                                }
                                if (this.nextLesserThan8Bits(1) == 0) {
                                    if (!isWhite) {
                                        cce[currIndex++] = bitOffset;
                                    }
                                    isWhite = true;
                                } else {
                                    if (isWhite) {
                                        cce[currIndex++] = bitOffset;
                                    }
                                    isWhite = false;
                                }
                                exit = true;
                            }
                            if (zeros == 5) {
                                if (!isWhite) {
                                    cce[currIndex++] = bitOffset;
                                }
                                bitOffset += zeros;
                                isWhite = true;
                                continue;
                            }
                            cce[currIndex++] = bitOffset += zeros;
                            this.setToBlack(buffer, lineOffset, bitOffset, 1);
                            ++bitOffset;
                            isWhite = false;
lbl97:
                            // 3 sources

                        } while (!exit);
                    }
                    continue;
                }
                bitOffset = this.w;
                this.updatePointer(7 - bits);
            }
            if (currIndex < cce.length) {
                cce[currIndex++] = bitOffset;
            }
            this.changingElemSize = currIndex;
            lineOffset += scanlineStride;
            ++lines;
        }
    }

    private void setToBlack(byte[] buffer, int lineOffset, int bitOffset, int numBits) {
        int bitNum = 8 * lineOffset + bitOffset;
        int lastBit = bitNum + numBits;
        int byteNum = bitNum >> 3;
        int shift = bitNum & 7;
        if (shift > 0) {
            int maskVal = 1 << 7 - shift;
            byte val = buffer[byteNum];
            while (maskVal > 0 && bitNum < lastBit) {
                val = (byte)(val | maskVal);
                maskVal >>= 1;
                ++bitNum;
            }
            buffer[byteNum] = val;
        }
        byteNum = bitNum >> 3;
        while (bitNum < lastBit - 7) {
            buffer[byteNum++] = -1;
            bitNum += 8;
        }
        while (bitNum < lastBit) {
            int n = byteNum = bitNum >> 3;
            buffer[n] = (byte)(buffer[n] | 1 << 7 - (bitNum & 7));
            ++bitNum;
        }
    }

    private int decodeWhiteCodeWord() {
        int code = -1;
        int runLength = 0;
        boolean isWhite = true;
        while (isWhite) {
            int current = this.nextNBits(10);
            short entry = white[current];
            int isT = entry & 1;
            int bits = entry >>> 1 & 0xF;
            if (bits == 12) {
                int twoBits = this.nextLesserThan8Bits(2);
                current = current << 2 & 0xC | twoBits;
                entry = additionalMakeup[current];
                bits = entry >>> 1 & 7;
                code = entry >>> 4 & 0xFFF;
                runLength += code;
                this.updatePointer(4 - bits);
                continue;
            }
            if (bits == 0) {
                throw new RuntimeException("Invalid code encountered.");
            }
            if (bits == 15) {
                throw new RuntimeException("EOL code word encountered in White run.");
            }
            code = entry >>> 5 & 0x7FF;
            runLength += code;
            this.updatePointer(10 - bits);
            if (isT != 0) continue;
            isWhite = false;
        }
        return runLength;
    }

    private int decodeBlackCodeWord() {
        int code = -1;
        int runLength = 0;
        boolean isWhite = false;
        while (!isWhite) {
            int current = this.nextLesserThan8Bits(4);
            short entry = initBlack[current];
            int isT = entry & 1;
            int bits = entry >>> 1 & 0xF;
            code = entry >>> 5 & 0x7FF;
            if (code == 100) {
                current = this.nextNBits(9);
                entry = black[current];
                isT = entry & 1;
                bits = entry >>> 1 & 0xF;
                code = entry >>> 5 & 0x7FF;
                if (bits == 12) {
                    this.updatePointer(5);
                    current = this.nextLesserThan8Bits(4);
                    entry = additionalMakeup[current];
                    bits = entry >>> 1 & 7;
                    code = entry >>> 4 & 0xFFF;
                    runLength += code;
                    this.updatePointer(4 - bits);
                    continue;
                }
                if (bits == 15) {
                    throw new RuntimeException("EOL code word encountered in Black run.");
                }
                runLength += code;
                this.updatePointer(9 - bits);
                if (isT != 0) continue;
                isWhite = true;
                continue;
            }
            if (code == 200) {
                current = this.nextLesserThan8Bits(2);
                entry = twoBitBlack[current];
                code = entry >>> 5 & 0x7FF;
                runLength += code;
                bits = entry >>> 1 & 0xF;
                this.updatePointer(2 - bits);
                isWhite = true;
                continue;
            }
            runLength += code;
            this.updatePointer(4 - bits);
            isWhite = true;
        }
        return runLength;
    }

    /*
     * Unable to fully structure code
     */
    private int readEOL(boolean isFirstEOL) {
        block6: {
            block5: {
                if (this.fillBits != 0) break block5;
                next12Bits = this.nextNBits(12);
                if (isFirstEOL && next12Bits == 0 && this.nextNBits(4) == 1) {
                    this.fillBits = 1;
                    return 1;
                }
                if (next12Bits != 1) {
                    throw new RuntimeException("Scanline must begin with EOL code word.");
                }
                break block6;
            }
            if (this.fillBits != 1) break block6;
            bitsLeft = 8 - this.bitPointer;
            if (this.nextNBits(bitsLeft) != 0) {
                throw new RuntimeException("All fill bits preceding EOL code must be 0.");
            }
            if (bitsLeft >= 4 || this.nextNBits(8) == 0) ** GOTO lbl18
            throw new RuntimeException("All fill bits preceding EOL code must be 0.");
lbl-1000:
            // 1 sources

            {
                if (n == 0) continue;
                throw new RuntimeException("All fill bits preceding EOL code must be 0.");
lbl18:
                // 2 sources

                ** while ((n = this.nextNBits((int)8)) != 1)
            }
        }
        if (this.oneD == 0) {
            return 1;
        }
        return this.nextLesserThan8Bits(1);
    }

    private void getNextChangingElement(int a0, boolean isWhite, int[] ret) {
        int start;
        int[] pce = this.prevChangingElems;
        int ces = this.changingElemSize;
        int n = start = this.lastChangingElement > 0 ? this.lastChangingElement - 1 : 0;
        start = isWhite ? (start &= 0xFFFFFFFE) : (start |= 1);
        int i = start;
        while (i < ces) {
            int temp = pce[i];
            if (temp > a0) {
                this.lastChangingElement = i;
                ret[0] = temp;
                break;
            }
            i += 2;
        }
        if (i + 1 < ces) {
            ret[1] = pce[i + 1];
        }
    }

    private int nextNBits(int bitsToGet) {
        byte next2next;
        byte next;
        byte b;
        int l = this.data.length - 1;
        int bp = this.bytePointer;
        if (this.fillOrder == 1) {
            b = this.data[bp];
            if (bp == l) {
                next = 0;
                next2next = 0;
            } else if (bp + 1 == l) {
                next = this.data[bp + 1];
                next2next = 0;
            } else {
                next = this.data[bp + 1];
                next2next = this.data[bp + 2];
            }
        } else if (this.fillOrder == 2) {
            b = flipTable[this.data[bp] & 0xFF];
            if (bp == l) {
                next = 0;
                next2next = 0;
            } else if (bp + 1 == l) {
                next = flipTable[this.data[bp + 1] & 0xFF];
                next2next = 0;
            } else {
                next = flipTable[this.data[bp + 1] & 0xFF];
                next2next = flipTable[this.data[bp + 2] & 0xFF];
            }
        } else {
            throw new RuntimeException("TIFF_FILL_ORDER tag must be either 1 or 2.");
        }
        int bitsLeft = 8 - this.bitPointer;
        int bitsFromNextByte = bitsToGet - bitsLeft;
        int bitsFromNext2NextByte = 0;
        if (bitsFromNextByte > 8) {
            bitsFromNext2NextByte = bitsFromNextByte - 8;
            bitsFromNextByte = 8;
        }
        ++this.bytePointer;
        int i1 = (b & table1[bitsLeft]) << bitsToGet - bitsLeft;
        int i2 = (next & table2[bitsFromNextByte]) >>> 8 - bitsFromNextByte;
        int i3 = 0;
        if (bitsFromNext2NextByte != 0) {
            i2 <<= bitsFromNext2NextByte;
            i3 = (next2next & table2[bitsFromNext2NextByte]) >>> 8 - bitsFromNext2NextByte;
            i2 |= i3;
            ++this.bytePointer;
            this.bitPointer = bitsFromNext2NextByte;
        } else if (bitsFromNextByte == 8) {
            this.bitPointer = 0;
            ++this.bytePointer;
        } else {
            this.bitPointer = bitsFromNextByte;
        }
        int i = i1 | i2;
        return i;
    }

    private int nextLesserThan8Bits(int bitsToGet) {
        int i1;
        byte next;
        byte b;
        int l = this.data.length - 1;
        int bp = this.bytePointer;
        if (this.fillOrder == 1) {
            b = this.data[bp];
            next = bp == l ? (byte)0 : this.data[bp + 1];
        } else if (this.fillOrder == 2) {
            b = flipTable[this.data[bp] & 0xFF];
            next = bp == l ? (byte)0 : flipTable[this.data[bp + 1] & 0xFF];
        } else {
            throw new RuntimeException("TIFF_FILL_ORDER tag must be either 1 or 2.");
        }
        int bitsLeft = 8 - this.bitPointer;
        int bitsFromNextByte = bitsToGet - bitsLeft;
        int shift = bitsLeft - bitsToGet;
        if (shift >= 0) {
            i1 = (b & table1[bitsLeft]) >>> shift;
            this.bitPointer += bitsToGet;
            if (this.bitPointer == 8) {
                this.bitPointer = 0;
                ++this.bytePointer;
            }
        } else {
            i1 = (b & table1[bitsLeft]) << -shift;
            int i2 = (next & table2[bitsFromNextByte]) >>> 8 - bitsFromNextByte;
            i1 |= i2;
            ++this.bytePointer;
            this.bitPointer = bitsFromNextByte;
        }
        return i1;
    }

    private void updatePointer(int bitsToMoveBack) {
        int i = this.bitPointer - bitsToMoveBack;
        if (i < 0) {
            --this.bytePointer;
            this.bitPointer = 8 + i;
        } else {
            this.bitPointer = i;
        }
    }

    private boolean advancePointer() {
        if (this.bitPointer != 0) {
            ++this.bytePointer;
            this.bitPointer = 0;
        }
        return true;
    }
}

